/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.geneontology.plaf.AbstractMenuItem;

public class TreeMenuRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -6417287017880901799L;
    protected Icon blankIcon = new Icon(){

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(c.getBackground());
            g.fillRect(x, y, this.getIconHeight(), this.getIconWidth());
        }
    };

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof AbstractMenuItem) {
            AbstractMenuItem item = (AbstractMenuItem)value;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (item.getIconPath() != null) {
                ImageIcon icon = new ImageIcon(item.getIconPath());
                this.setIcon(icon);
            } else {
                this.setIcon(this.blankIcon);
            }
            this.setText(item.getLabel());
            return this;
        }
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setText("<unrecognized item> of type: " + value.getClass());
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        return this;
    }
}

