/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing;

import java.awt.Shape;
import java.awt.geom.Point2D;
import org.geneontology.swing.PathOp;
import org.geneontology.swing.PathOpList;
import org.geneontology.swing.ShapeExtender;

public abstract class AbstractShapeExtender
implements ShapeExtender {
    public Shape[] extend(Shape a, Shape b) {
        Shape[] out = new Shape[2];
        PathOpList source = new PathOpList(a, true);
        PathOpList target = new PathOpList(b, true);
        int[] sourceIndices = source.getSubpathIndices();
        int[] targetIndices = target.getSubpathIndices();
        int i = 0;
        while (i < sourceIndices.length && i < targetIndices.length) {
            int endSourceIndex = i >= sourceIndices.length - 1 ? source.size() - 1 : sourceIndices[i + 1];
            int endTargetIndex = i >= targetIndices.length - 1 ? target.size() - 1 : targetIndices[i + 1];
            this.addPoints(source, sourceIndices[i], endSourceIndex, target, targetIndices[i], endTargetIndex);
            ++i;
        }
        source.flushPendingOps();
        target.flushPendingOps();
        if (i < sourceIndices.length) {
            this.appendEmptySubpaths(target, source, sourceIndices, sourceIndices.length - targetIndices.length);
        } else if (i < targetIndices.length) {
            this.appendEmptySubpaths(source, target, targetIndices, targetIndices.length - sourceIndices.length);
        }
        out[0] = source.getShape();
        out[1] = target.getShape();
        return out;
    }

    protected void appendEmptySubpaths(PathOpList target, PathOpList source, int[] sourceIndices, int subpathCount) {
        int startIndex;
        Point2D.Float origin = target.size() == 0 ? new Point2D.Float() : target.getSegmentEndpoint(target.size() - 1, null);
        int i = startIndex = sourceIndices[sourceIndices.length - subpathCount];
        while (i < source.size()) {
            PathOp newOp;
            float[] coords;
            PathOp op = source.getSegment(i);
            if (op.op == 0) {
                coords = new float[]{origin.x, origin.y};
                newOp = new PathOp(op.op, coords);
                target.addPendingOp(-1, newOp);
            } else if (op.op == 4) {
                newOp = new PathOp(op.op, new float[0]);
            } else {
                coords = new float[]{origin.x, origin.y};
                newOp = new PathOp(1, coords);
                target.addPendingOp(-1, newOp);
            }
            ++i;
        }
        target.flushPendingOps();
    }

    protected abstract void addPoints(PathOpList var1, int var2, int var3, PathOpList var4, int var5, int var6);
}

