/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.LineBorder;

public class EdgeBorder
extends LineBorder {
    private static final long serialVersionUID = 121887443401755004L;
    protected boolean north;
    protected boolean south;
    protected boolean east;
    protected boolean west;

    public EdgeBorder(Color color, int thickness, boolean north, boolean south, boolean east, boolean west) {
        super(color, thickness);
        this.north = north;
        this.south = south;
        this.east = east;
        this.west = west;
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        if (this.north) {
            insets.top = this.thickness;
        }
        if (this.south) {
            insets.bottom = this.thickness;
        }
        if (this.west) {
            insets.left = this.thickness;
        }
        if (this.east) {
            insets.right = this.thickness;
        }
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        if (this.north) {
            g.fillRect(x, y, width, this.thickness);
        }
        if (this.south) {
            g.fillRect(x, y + height - this.thickness, width, this.thickness);
        }
        if (this.east) {
            g.fillRect(x, y, this.thickness, height);
        }
        if (this.west) {
            g.fillRect(x + width - this.thickness, y, this.thickness, height);
        }
        g.setColor(oldColor);
    }
}

