/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geneontology.swing.PathOp;
import org.geneontology.swing.ShapeUtil;

public class PathOpList {
    protected float[] scratch = new float[6];
    protected int[] subpathIndices = null;
    protected List list = new LinkedList();
    protected List pendingOps = new LinkedList();
    protected int subpathCount = 0;
    protected int windingRule;

    public PathOpList(Shape shape, boolean finishClose) {
        this(shape.getPathIterator(null), finishClose);
    }

    public int getSubpathCount() {
        return this.subpathCount;
    }

    public void duplicateEndPoint(int segmentIndex) {
        PathOp op = (PathOp)this.list.get(segmentIndex);
        if (op.op == 4) {
            Point2D.Float startShapePoint = this.getPathStartPointForSegIndex(segmentIndex, null);
            float[] coords = new float[]{startShapePoint.x, startShapePoint.y};
            PathOp newOp = new PathOp(1, coords);
            this.addPendingOp(segmentIndex, newOp);
        } else {
            Point2D.Float endPoint = this.getSegmentEndpoint(segmentIndex, null);
            float[] coords = new float[]{endPoint.x, endPoint.y};
            PathOp newOp = new PathOp(1, coords);
            this.addPendingOp(segmentIndex + 1, newOp);
        }
    }

    public Point2D.Float getPathStartPointForSegIndex(int segIndex, Point2D.Float out) {
        int i = segIndex;
        while (i >= 0) {
            PathOp op = (PathOp)this.list.get(i);
            if (op.op == 0) {
                return this.getSegmentEndpoint(i, out);
            }
            --i;
        }
        out.setLocation(0.0f, 0.0f);
        return out;
    }

    public int[] getSubpathIndices() {
        if (this.subpathIndices == null) {
            this.rebuildSubpathIndex();
        }
        return this.subpathIndices;
    }

    protected void rebuildSubpathIndex() {
        this.subpathIndices = new int[this.subpathCount];
        Iterator it = this.list.iterator();
        int subpathIndex = 0;
        int i = 0;
        while (it.hasNext()) {
            PathOp op = (PathOp)it.next();
            if (op.op == 0) {
                this.subpathIndices[subpathIndex++] = i;
            }
            ++i;
        }
    }

    protected void addSubpathIndex(int arrIndex, int subpathIndex) {
        int[] newArr = new int[this.subpathIndices.length + 1];
        int i = 0;
        while (i < newArr.length) {
            if (i < arrIndex) {
                newArr[i] = this.subpathIndices[i];
            } else if (i == arrIndex) {
                newArr[i] = subpathIndex;
            } else if (i > arrIndex) {
                newArr[i] = this.subpathIndices[i - 1] + 1;
            }
            ++i;
        }
        this.subpathIndices = newArr;
    }

    public PathOpList(PathIterator it, boolean finishClose) {
        this.windingRule = it.getWindingRule();
        Point2D.Float lastMoveTo = new Point2D.Float();
        Point2D.Float lastPoint = new Point2D.Float();
        while (!it.isDone()) {
            int op = it.currentSegment(this.scratch);
            int coordCount = ShapeUtil.getArrayUse(op);
            float[] coords = new float[coordCount];
            int i = 0;
            while (i < coordCount) {
                coords[i] = this.scratch[i];
                if (i == coordCount - 1) {
                    lastPoint.y = coords[i];
                } else if (i == coordCount - 2) {
                    lastPoint.x = coords[i];
                }
                ++i;
            }
            if (op == 0) {
                lastMoveTo.setLocation(coords[0], coords[1]);
            }
            if (op == 4 && finishClose && !lastPoint.equals(lastMoveTo)) {
                float[] pt = new float[]{lastMoveTo.x, lastMoveTo.y};
                this.addOp(1, pt);
                lastPoint.setLocation(lastMoveTo);
            }
            this.addOp(op, coords);
            it.next();
        }
    }

    public Point2D.Float getSegmentStartPoint(int index, Point2D.Float out) {
        if (out == null) {
            out = new Point2D.Float();
        }
        if (index == 0) {
            out.setLocation(0.0f, 0.0f);
            return out;
        }
        return this.getSegmentEndpoint(index - 1, out);
    }

    public Point2D.Float getSegmentEndpoint(int index, Point2D.Float out) {
        if (out == null) {
            out = new Point2D.Float();
        }
        PathOp op = (PathOp)this.list.get(index);
        if (op.op == 4) {
            this.getPathStartPointForSegIndex(index, out);
        } else {
            out.x = op.coords[op.coords.length - 2];
            out.y = op.coords[op.coords.length - 1];
        }
        return out;
    }

    public void addOp(int op, float[] coords) {
        this.addOp(this.list.size(), op, coords);
    }

    public void addOp(int index, int op, float[] coords) {
        this.addOp(index, new PathOp(op, coords));
    }

    public int size() {
        return this.list.size();
    }

    public void addOp(PathOp op) {
        this.addOp(this.list.size(), op);
    }

    public void addOp(int index, PathOp op) {
        this.subpathIndices = null;
        if (op.op == 0) {
            ++this.subpathCount;
        }
        this.list.add(index, op);
    }

    public void addPendingOp(int index, PathOp op) {
        op.setPendingIndex(index);
        this.pendingOps.add(op);
    }

    public void flushPendingOps() {
        Iterator it = this.pendingOps.iterator();
        while (it.hasNext()) {
            PathOp op = (PathOp)it.next();
            it.remove();
            int newIndex = op.getPendingIndex();
            if (newIndex < 0) {
                newIndex = this.list.size();
            }
            this.addOp(newIndex, op);
        }
    }

    public String toString() {
        return this.list.toString();
    }

    protected void incrementPendingIndices(int lastIndex) {
        Iterator it = this.pendingOps.iterator();
        while (it.hasNext()) {
            PathOp op = (PathOp)it.next();
            if (op.getPendingIndex() < lastIndex) continue;
            op.setPendingIndex(op.getPendingIndex() + 1);
        }
    }

    public Shape getShape() {
        GeneralPath out = new GeneralPath();
        out.append(this.getPathIterator(), false);
        return out;
    }

    public PathIterator getPathIterator() {
        return new PathIterator(){
            protected int index = 0;

            public boolean isDone() {
                return this.index >= PathOpList.this.list.size();
            }

            public int getWindingRule() {
                return PathOpList.this.windingRule;
            }

            public void next() {
                ++this.index;
            }

            public int currentSegment(float[] coords) {
                PathOp op = (PathOp)PathOpList.this.list.get(this.index);
                int i = 0;
                while (i < op.coords.length) {
                    coords[i] = op.coords[i];
                    ++i;
                }
                return op.op;
            }

            public int currentSegment(double[] coords) {
                PathOp op = (PathOp)PathOpList.this.list.get(this.index);
                int i = 0;
                while (i < op.coords.length) {
                    coords[i] = op.coords[i];
                    ++i;
                }
                return op.op;
            }
        };
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public PathOp getSegment(int i) {
        return (PathOp)this.list.get(i);
    }
}

