/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geneontology.util.VectorFilter;

public class BooleanFilter
implements VectorFilter {
    private static final long serialVersionUID = -3102761890208817994L;
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int NOT = 3;
    protected int operation;
    protected List filters;

    public BooleanFilter() {
        this.filters = new ArrayList();
        this.operation = 1;
    }

    public BooleanFilter(int operation) {
        this.setOperation(operation);
        this.filters = new ArrayList();
    }

    public void removeAll() {
        this.filters.clear();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        if (operation != 1 && operation != 2 && operation != 3) {
            throw new IllegalArgumentException("Illegal Operation");
        }
        this.operation = operation;
    }

    public void addFilter(VectorFilter in) {
        if (!(this.filters.contains(in) || this.filters.size() >= 1 && this.operation == 3)) {
            this.filters.add(in);
        }
    }

    public void removeFilter(VectorFilter in) {
        this.filters.remove(in);
    }

    public List getFilters() {
        return this.filters;
    }

    public void setFilters(List filters) {
        this.filters = filters;
    }

    public boolean satisfies(Object o) {
        Iterator it = this.filters.iterator();
        while (it.hasNext()) {
            VectorFilter current = (VectorFilter)it.next();
            boolean result = current.satisfies(o);
            if (this.operation == 3) {
                return !result;
            }
            if (this.operation == 2 && result) {
                return true;
            }
            if (this.operation != 1 || result) continue;
            return false;
        }
        if (this.operation == 2) {
            return false;
        }
        return this.operation == 1;
    }
}

