/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.geneontology.util.ArgumentSpec;
import org.geneontology.util.Tag;

public class TagSpec
implements Cloneable {
    protected ArgumentSpec impliedSpec;
    protected String name;
    protected List argumentSpecs;
    protected List impliedArgs;
    protected List defaultValues;
    protected String documentation;

    public TagSpec() {
        this("");
    }

    public TagSpec(String name) {
        this(name, null);
    }

    public TagSpec(String name, String documentation) {
        this.name = name;
        this.documentation = documentation;
        this.argumentSpecs = new Vector();
        this.impliedArgs = new Vector();
        this.defaultValues = new Vector();
    }

    public TagSpec copy(String name) {
        TagSpec out = (TagSpec)this.clone();
        out.name = name;
        return out;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            return this;
        }
    }

    public String getName() {
        return this.name;
    }

    public List getDefaultValues() {
        return this.defaultValues;
    }

    public void setImpliedSpec(TagSpec spec, int cardinality) {
        this.setImpliedSpec(new ArgumentSpec(spec, cardinality));
    }

    public void setImpliedSpec(ArgumentSpec impliedSpec) {
        this.impliedSpec = impliedSpec;
    }

    public ArgumentSpec getImpliedSpec() {
        return this.impliedSpec;
    }

    public void addArgumentSpec(TagSpec spec, int cardinality) {
        this.addArgumentSpec(new ArgumentSpec(spec, cardinality));
    }

    public void addArgumentSpec(TagSpec spec, int cardinality, String documentation) {
        this.addArgumentSpec(new ArgumentSpec(spec, cardinality, documentation));
    }

    public void addArgumentSpec(ArgumentSpec spec) {
        this.argumentSpecs.add(spec);
    }

    public void addImpliedArgument(Tag tag) {
        this.impliedArgs.add(tag);
    }

    public List getImpliedArguments() {
        return this.impliedArgs;
    }

    public List getArgumentSpecs() {
        return this.argumentSpecs;
    }

    public String getDocumentation() {
        return this.getSummaryDocumentation();
    }

    public String getSummaryDocumentation() {
        if (this.documentation != null) {
            return String.valueOf(this.name) + " " + this.documentation;
        }
        StringBuffer out = new StringBuffer();
        out.append(this.name);
        out.append(" {");
        Iterator it = this.argumentSpecs.iterator();
        while (it.hasNext()) {
            ArgumentSpec as = (ArgumentSpec)it.next();
            out.append(" ");
            out.append(as.getSummaryDocumentation());
        }
        out.append("}");
        return out.toString();
    }

    public String toString() {
        return this.getName();
    }
}

