/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class TinySet
implements Set {
    protected Collection list;
    protected static final Iterator emptyIterator = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new RuntimeException("Cannot call next() on an empty iterator");
        }

        public void remove() {
            throw new RuntimeException("Cannot call next() on an empty iterator");
        }
    };

    protected void forceCollection() {
        if (this.list == null) {
            this.list = new LinkedList();
        }
    }

    public boolean add(Object o) {
        this.forceCollection();
        if (!this.list.contains(o)) {
            this.list.add(o);
            return true;
        }
        return false;
    }

    public boolean addAll(Collection c) {
        this.forceCollection();
        boolean added = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (this.list.contains(o)) continue;
            this.list.add(o);
            added = true;
        }
        return added;
    }

    public void clear() {
        this.list = null;
    }

    public boolean contains(Object o) {
        if (this.list == null) {
            return false;
        }
        return this.list.contains(o);
    }

    public boolean containsAll(Collection c) {
        if (this.list == null) {
            return c.size() == 0;
        }
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (this.list.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.list == null;
    }

    public Iterator iterator() {
        if (this.list == null) {
            return emptyIterator;
        }
        return this.list.iterator();
    }

    public boolean remove(Object o) {
        if (this.list == null) {
            return false;
        }
        if (this.list.contains(o) && this.list.size() == 1) {
            this.list = null;
            return true;
        }
        return this.list.remove(o);
    }

    public boolean removeAll(Collection c) {
        boolean removed = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (this.list.remove(o)) {
                removed = true;
            }
            if (this.list == null) break;
        }
        return removed;
    }

    public boolean retainAll(Collection c) {
        Iterator it = this.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            Object o = it.next();
            if (c.contains(o)) continue;
            it.remove();
            changed = true;
        }
        if (this.list.size() == 0) {
            this.list = null;
        }
        return changed;
    }

    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public Object[] toArray() {
        Object[] arr = new Object[this.size()];
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            Object o = it.next();
            arr[i] = o;
            ++i;
        }
        return arr;
    }

    public Object[] toArray(Object[] a) {
        Object[] arr = a != null && a.length >= this.size() ? a : new Object[this.size()];
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            Object o = it.next();
            arr[i] = o;
            ++i;
        }
        if (arr.length > this.size()) {
            arr[this.size()] = null;
        }
        return arr;
    }

    public String toString() {
        if (this.list == null) {
            return "[]";
        }
        return this.list.toString();
    }
}

