/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import org.geneontology.swing.DragFriendlyUI;

public class DragFriendlyTreeUI
extends BasicTreeUI
implements DragFriendlyUI {
    protected boolean disableEvents = false;
    protected boolean dragging = false;
    protected static int idgen = 0;
    protected int id = ++idgen;
    int[] triangleXBuffer = new int[3];
    int[] triangleYBuffer = new int[3];
    protected int triangleYSize = 4;
    protected int triangleXSize = 4;
    protected int triangleOffset = 2;
    protected int controlWidth = 8;
    protected boolean drawArrowhead = true;
    protected boolean arrowheadLeft = true;

    public String toString() {
        return "DragFriendlyTreeUI " + this.id;
    }

    public DragFriendlyTreeUI() {
        TreeIcon minusIcon = new TreeIcon(2);
        TreeIcon plusIcon = new TreeIcon(1);
        UIManager.put("Tree.expandedIcon", minusIcon);
        UIManager.put("Tree.collapsedIcon", plusIcon);
        this.setExpandedIcon(new TreeIcon(2));
        this.setCollapsedIcon(new TreeIcon(1));
    }

    public void setIsDragging(boolean dragging) {
        this.dragging = dragging;
    }

    protected MouseListener createMouseListener() {
        return new DragFriendlyMouseHandler();
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int depth = path.getPathCount() - 1;
        if ((depth == 0 || depth == 1 && !this.isRootVisible()) && !this.getShowsRootHandles()) {
            return;
        }
        int clipLeft = clipBounds.x;
        int clipRight = clipBounds.x + (clipBounds.width - 1);
        int clipTop = clipBounds.y;
        int clipBottom = clipBounds.y + (clipBounds.height - 1);
        int lineY = bounds.y + bounds.height / 2;
        int leftX = bounds.x - this.getRightChildIndent();
        int nodeX = bounds.x - this.getHorizontalLegBuffer();
        if (lineY >= clipTop && lineY <= clipBottom && nodeX >= clipLeft && leftX <= clipRight && (leftX = Math.max(Math.max(insets.left, leftX), clipLeft)) != (nodeX = Math.min(Math.max(insets.left, nodeX), clipRight))) {
            g.setColor(this.getHashColor());
            this.paintHorizontalLine(g, this.tree, lineY, leftX, nodeX, isLeaf, path);
        }
    }

    public void setTriangleYSize(int triangleYSize) {
        this.triangleYSize = triangleYSize;
    }

    public void setTriangleXSize(int triangleXSize) {
        this.triangleXSize = triangleXSize;
    }

    public void setTriangleOffset(int triangleOffset) {
        this.triangleOffset = triangleOffset;
    }

    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right, boolean isLeaf, TreePath path) {
        g.drawLine(left, y, right, y);
        if (this.drawArrowhead && path.getPathCount() > 2) {
            this.triangleYBuffer[0] = y - this.triangleYSize;
            this.triangleYBuffer[1] = y + this.triangleYSize;
            this.triangleYBuffer[2] = y;
            int xoffset = this.triangleOffset;
            if (!isLeaf) {
                xoffset += 2 + this.controlWidth / 2;
            }
            if (this.arrowheadLeft) {
                this.triangleXBuffer[0] = left + xoffset + this.triangleXSize;
                this.triangleXBuffer[1] = left + xoffset + this.triangleXSize;
                this.triangleXBuffer[2] = left + xoffset;
            } else {
                this.triangleXBuffer[0] = right - xoffset - this.triangleXSize;
                this.triangleXBuffer[1] = right - xoffset - this.triangleXSize;
                this.triangleXBuffer[2] = right - xoffset;
            }
            g.fillPolygon(this.triangleXBuffer, this.triangleYBuffer, 3);
        }
    }

    public void setDrawArrowhead(boolean drawArrowhead) {
        this.drawArrowhead = drawArrowhead;
    }

    public static class TreeIcon
    implements Icon {
        public static final int PLUS = 1;
        public static final int MINUS = 2;
        private static final int width = 8;
        private static final int height = 8;
        private int type;
        private Color foreground;
        private Color background;

        public TreeIcon(int type) {
            this(type, Color.black);
        }

        public TreeIcon(int type, Color foreground) {
            this.type = type;
            this.background = Color.white;
            this.foreground = foreground;
        }

        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 8;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.white);
            g.fillRect(x, y, 8, 8);
            g.setColor(this.foreground);
            g.drawRect(x, y, 8, 8);
            g.drawLine(x + 2, y + 4, x + 6, y + 4);
            if (this.type == 1) {
                g.drawLine(x + 4, y + 2, x + 4, y + 6);
            }
        }
    }

    public class DragFriendlyMouseHandler
    extends MouseAdapter {
        public void mouseReleased(MouseEvent e) {
            if (DragFriendlyTreeUI.this.dragging || e.isConsumed()) {
                return;
            }
            if (DragFriendlyTreeUI.this.tree != null && DragFriendlyTreeUI.this.tree.isEnabled()) {
                DragFriendlyTreeUI.this.tree.requestFocus();
                TreePath path = DragFriendlyTreeUI.this.getClosestPathForLocation(DragFriendlyTreeUI.this.tree, e.getX(), e.getY());
                if (path != null) {
                    int x;
                    Rectangle bounds = DragFriendlyTreeUI.this.getPathBounds(DragFriendlyTreeUI.this.tree, path);
                    if (e.getY() > bounds.y + bounds.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        DragFriendlyTreeUI.this.checkForClickInExpandControl(path, e.getX(), e.getY());
                    }
                    if ((x = e.getX()) > bounds.x && x <= bounds.x + bounds.width && !DragFriendlyTreeUI.this.startEditing(path, e)) {
                        DragFriendlyTreeUI.this.selectPathForEvent(path, e);
                    }
                }
            }
        }
    }
}

