/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.geneontology.util.DefaultHasher;
import org.geneontology.util.Hasher;

public class FastSet
implements Set {
    int hashCode = 0;
    protected HashMap map = new HashMap();
    protected Hasher hasher;

    public FastSet() {
        this(new DefaultHasher());
    }

    public FastSet(Hasher hasher) {
        this.setHasher(hasher);
    }

    public void setHasher(Hasher hasher) {
        if (hasher == null) {
            throw new IllegalArgumentException("null hasher not allowed");
        }
        Iterator it = this.iterator();
        Vector<Object> v = new Vector<Object>();
        while (it.hasNext()) {
            v.add(((HasherWrappedObject)it.next()).getObject());
        }
        this.hasher = hasher;
        this.clear();
        int i = 0;
        while (i < v.size()) {
            this.add(v.get(i));
            ++i;
        }
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(Object o) {
        return this.map.containsKey(new HasherWrappedObject(o));
    }

    public Iterator iterator() {
        return new HashWrappedIterator(this.map.keySet().iterator());
    }

    public Object[] toArray() {
        Object[] out = new Object[this.size()];
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            out[i++] = it.next();
        }
        return out;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = this.iterator();
        int i = 0;
        while (i < size) {
            a[i] = it.next();
            ++i;
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public boolean add(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null elements not allowed");
        }
        o = new HasherWrappedObject(o);
        this.hashCode += o.hashCode();
        if (!this.map.containsKey(o)) {
            this.map.put(o, o);
            return true;
        }
        return false;
    }

    public boolean remove(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null elements not allowed");
        }
        o = new HasherWrappedObject(o);
        this.hashCode -= o.hashCode();
        if (this.map.containsKey(o)) {
            this.map.remove(o);
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection c) {
        Iterator i = c.iterator();
        boolean added = false;
        while (i.hasNext()) {
            if (!this.add(i.next())) continue;
            added = true;
        }
        return added;
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("Can't do retain all");
    }

    public boolean removeAll(Collection c) {
        Iterator i = c.iterator();
        boolean added = false;
        while (i.hasNext()) {
            if (!this.remove(i.next())) continue;
            added = true;
        }
        return added;
    }

    public void clear() {
        this.hashCode = 0;
        this.map.clear();
    }

    public boolean equals(Object o) {
        if (o instanceof Set) {
            Set set = (Set)o;
            return set.size() == this.size() && this.containsAll((Collection)set);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected class HasherWrappedObject {
        Object object;

        public HasherWrappedObject(Object o) {
            this.object = o;
        }

        public boolean equals(Object o) {
            if (o instanceof HasherWrappedObject) {
                o = ((HasherWrappedObject)o).getObject();
            }
            return FastSet.this.hasher.equals(this.object, o);
        }

        public int hashCode() {
            return FastSet.this.hasher.hashCode(this.object);
        }

        public Object getObject() {
            return this.object;
        }
    }

    protected class HashWrappedIterator
    implements Iterator {
        Iterator it;

        public HashWrappedIterator(Iterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return ((HasherWrappedObject)this.it.next()).getObject();
        }

        public void remove() {
        }
    }
}

