/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.validator;

import psidev.psi.tools.validator.Context;
import psidev.psi.tools.validator.MessageLevel;
import psidev.psi.tools.validator.rules.Rule;
import psidev.psi.tools.validator.schema.SaxMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorMessage<T> {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final String message;
    private final MessageLevel level;
    private Context context;
    private Rule rule;

    public ValidatorMessage(String message, MessageLevel level) {
        if (message == null) {
            throw new IllegalArgumentException("A message must not be null when creating a ValidatorMessage.");
        }
        this.message = message;
        if (level == null) {
            throw new IllegalArgumentException("A message level must not be null when creating a ValidatorMessage.");
        }
        this.level = level;
    }

    public ValidatorMessage(String message, MessageLevel level, Context context, Rule rule) {
        this(message, level);
        if (context == null) {
            throw new IllegalArgumentException("A context must not be null when creating a ValidatorMessage.");
        }
        this.context = context;
        if (rule == null) {
            throw new IllegalArgumentException("A rule must not be null when creating a ValidatorMessage.");
        }
        this.rule = rule;
    }

    public ValidatorMessage(SaxMessage saxMessage, MessageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("A message level must not be null when creating a ValidatorMessage.");
        }
        this.level = level;
        if (saxMessage == null) {
            throw new IllegalArgumentException("SAX Message must not be null");
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append("L").append(saxMessage.getLineNumber());
        sb.append(" C").append(saxMessage.getColumnNumber());
        sb.append(":").append(saxMessage.getMessage());
        this.message = sb.toString();
    }

    public String getMessage() {
        return this.message;
    }

    public MessageLevel getLevel() {
        return this.level;
    }

    public Context getContext() {
        return this.context;
    }

    public Rule getRule() {
        return this.rule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatorMessage that = (ValidatorMessage)o;
        if (this.context != null ? !this.context.equals(that.context) : that.context != null) {
            return false;
        }
        if (this.level != that.level) {
            return false;
        }
        if (!this.message.equals(that.message)) {
            return false;
        }
        return !(this.rule != null ? !this.rule.equals(that.rule) : that.rule != null);
    }

    public int hashCode() {
        int result = this.message.hashCode();
        result = 29 * result + this.level.hashCode();
        result = 29 * result + (this.context != null ? this.context.hashCode() : 0);
        result = 29 * result + (this.rule != null ? this.rule.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ValidatorMessage");
        sb.append("{message='").append(this.message).append('\'');
        sb.append(", level=").append((Object)this.level);
        sb.append(", context=").append(this.context);
        sb.append(", rule=").append(this.rule);
        sb.append('}');
        return sb.toString();
    }
}

