/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.validator.schema;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import psidev.psi.tools.validator.schema.SaxMessage;
import psidev.psi.tools.validator.schema.SaxReport;

public class SaxValidatorHandler {
    public static final Log log = LogFactory.getLog(SaxValidatorHandler.class);

    public static SaxReport validate(InputStream is) throws IOException, SAXException {
        InputSource inputSource = new InputSource(is);
        return SaxValidatorHandler.validate(inputSource);
    }

    public static SaxReport validate(File file) throws IOException, SAXException {
        String filename = file.getAbsolutePath();
        InputSource inputSource = new InputSource(new FileReader(filename));
        return SaxValidatorHandler.validate(inputSource);
    }

    public static SaxReport validate(String xmlString) throws IOException, SAXException {
        InputSource inputSource = new InputSource(new StringReader(xmlString));
        return SaxValidatorHandler.validate(inputSource);
    }

    public static SaxReport validate(InputSource inputSource) throws SAXException, IOException {
        String parserClass = SAXParser.class.getName();
        String validationFeature = "http://xml.org/sax/features/validation";
        String schemaFeature = "http://apache.org/xml/features/validation/schema";
        SaxReport report = new SaxReport();
        MyErrorHandler handler = new MyErrorHandler(report);
        XMLReader r = XMLReaderFactory.createXMLReader();
        r.setFeature(validationFeature, true);
        r.setFeature(schemaFeature, true);
        r.setErrorHandler(handler);
        r.parse(inputSource);
        if (handler.hasError() || handler.hasFatal() || handler.hasWarning()) {
            log.info((Object)"SaxValidatorHandler.validate( is not valid )");
            report.setValid(false);
            if (handler.hasError()) {
                log.info((Object)"SAX Validator found at least 1 error.");
            }
            if (handler.hasFatal()) {
                log.info((Object)"SAX Validator found at least 1 fatal error.");
            }
            if (handler.hasWarning()) {
                log.info((Object)"SAX Validator found at least 1 warning.");
            }
        } else {
            log.info((Object)"SaxValidatorHandler.validate( is valid )");
            report.setValid(true);
        }
        return report;
    }

    private static class MyErrorHandler
    extends DefaultHandler {
        private PrintStream out;
        boolean warning = false;
        boolean error = false;
        boolean fatal = false;
        SaxReport report = new SaxReport();

        public MyErrorHandler(PrintStream out) {
            if (out == null) {
                throw new NullPointerException("You must give a valid PrintStream");
            }
            this.out = out;
        }

        public MyErrorHandler(SaxReport report) {
            if (report == null) {
                throw new IllegalArgumentException("Report must not be null.");
            }
            this.report = report;
        }

        public MyErrorHandler() {
            this.out = System.out;
        }

        public boolean hasWarning() {
            return this.warning;
        }

        public boolean hasError() {
            return this.error;
        }

        public boolean hasFatal() {
            return this.fatal;
        }

        public void warning(SAXParseException e) throws SAXException {
            this.warning = true;
            this.printInfo(e);
        }

        public void error(SAXParseException e) throws SAXException {
            this.error = true;
            this.printInfo(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.fatal = true;
            this.printInfo(e);
        }

        private void printInfo(SAXParseException e) {
            if (this.report != null) {
                SaxMessage message = new SaxMessage(e);
                this.report.addMessage(message);
            } else {
                StringBuilder sb = new StringBuilder(150);
                sb.append("   Public ID: " + e.getPublicId()).append("\n");
                sb.append("   System ID: " + e.getSystemId()).append("\n");
                sb.append("   Line number: " + e.getLineNumber()).append("\n");
                sb.append("   Column number: " + e.getColumnNumber()).append("\n");
                sb.append("   Message: " + e.getMessage());
                this.out.print(sb.toString());
                log.info((Object)sb.toString());
            }
        }
    }
}

