/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.geneontology.oboedit.datamodel.CategorizedObject;
import org.geneontology.oboedit.datamodel.CommentedObject;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.DbxrefedObject;
import org.geneontology.oboedit.datamodel.DefaultHistoryList;
import org.geneontology.oboedit.datamodel.DefinedObject;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.MultiIDObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.ObsoletableObject;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymCategory;
import org.geneontology.oboedit.datamodel.SynonymedObject;
import org.geneontology.oboedit.datamodel.TermCategory;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.AddDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.AddSynonymHistoryItem;
import org.geneontology.oboedit.datamodel.history.CardinalityHistoryItem;
import org.geneontology.oboedit.datamodel.history.CategoryChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.ChangeSynCategoryHistoryItem;
import org.geneontology.oboedit.datamodel.history.ChangeSynScopeHistoryItem;
import org.geneontology.oboedit.datamodel.history.CommentChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.CompletesHistoryItem;
import org.geneontology.oboedit.datamodel.history.CreateObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.CyclicHistoryItem;
import org.geneontology.oboedit.datamodel.history.DefinitionChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.DelDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.DelSynonymHistoryItem;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.history.DestroyObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.DomainHistoryItem;
import org.geneontology.oboedit.datamodel.history.InverseNecHistoryItem;
import org.geneontology.oboedit.datamodel.history.MaxCardinalityHistoryItem;
import org.geneontology.oboedit.datamodel.history.MinCardinalityHistoryItem;
import org.geneontology.oboedit.datamodel.history.NameChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.NamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.NecessarilyTrueHistoryItem;
import org.geneontology.oboedit.datamodel.history.ObsoleteObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.RangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.SecondaryIDHistoryItem;
import org.geneontology.oboedit.datamodel.history.SymmetricHistoryItem;
import org.geneontology.oboedit.datamodel.history.SynonymCategoryHistoryItem;
import org.geneontology.oboedit.datamodel.history.TRNamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCategoryHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermNamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.TransitiveHistoryItem;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.util.ObjectUtil;
import org.geneontology.util.ProgressListener;

public class HistoryGenerator
implements Serializable {
    private static final long serialVersionUID = 1L;

    protected static boolean checkInterface(IdentifiedObject io, HistoryList history, Class checkme) {
        if (!checkme.isInstance(io)) {
            history.getWarnings().add(io + " should be an instance of " + checkme + ", but it is not.");
            return false;
        }
        return true;
    }

    public static HistoryList getHistory(OBOSession oldHistory, OBOSession newHistory) {
        return HistoryGenerator.getHistory(oldHistory, newHistory, null);
    }

    public static HistoryList getHistory(OBOSession oldHistory, OBOSession newHistory, ProgressListener listener) {
        IdentifiedObject oldio;
        IdentifiedObject io;
        Cloneable cat2;
        HistoryItem item;
        Cloneable cat;
        HistoryItem item2;
        Namespace n;
        DefaultHistoryList history = new DefaultHistoryList();
        Iterator it = oldHistory.getNamespaces().iterator();
        while (it.hasNext()) {
            n = (Namespace)it.next();
            Namespace newn = TermUtil.findNamespace(n, newHistory);
            if (newn != null) continue;
            item2 = new TermNamespaceHistoryItem(n.getID(), null, false, true);
            history.addItem(item2);
        }
        it = newHistory.getNamespaces().iterator();
        while (it.hasNext()) {
            n = (Namespace)it.next();
            Namespace oldn = TermUtil.findNamespace(n, oldHistory);
            if (oldn != null) continue;
            item2 = new TermNamespaceHistoryItem(null, n.getID(), true, false);
            history.addItem(item2);
        }
        it = oldHistory.getCategories().iterator();
        while (it.hasNext()) {
            cat = (TermCategory)it.next();
            if (!newHistory.getCategories().contains(cat)) {
                item = new TermCategoryHistoryItem((TermCategory)cat, null, false, true);
                history.addItem(item);
                continue;
            }
            cat2 = TermUtil.findCategory((TermCategory)cat, newHistory);
            if (cat.getDesc().equals(cat2.getDesc())) continue;
            item2 = new TermCategoryHistoryItem((TermCategory)cat, (TermCategory)cat2, false, false);
            history.addItem(item2);
        }
        it = newHistory.getCategories().iterator();
        while (it.hasNext()) {
            cat = (TermCategory)it.next();
            if (oldHistory.getCategories().contains(cat)) continue;
            item = new TermCategoryHistoryItem(null, (TermCategory)cat, true, false);
            history.addItem(item);
        }
        it = oldHistory.getSynonymCategories().iterator();
        while (it.hasNext()) {
            cat = (SynonymCategory)it.next();
            if (!newHistory.getSynonymCategories().contains(cat)) {
                item = new SynonymCategoryHistoryItem((SynonymCategory)cat, null, false, true);
                history.addItem(item);
                continue;
            }
            cat2 = TermUtil.findSynonymCategory((SynonymCategory)cat, newHistory);
            if (cat.getName().equals(cat2.getName()) && cat.getScope() == cat2.getScope()) continue;
            item2 = new SynonymCategoryHistoryItem((SynonymCategory)cat, (SynonymCategory)cat2, false, false);
            history.addItem(item2);
        }
        it = newHistory.getSynonymCategories().iterator();
        while (it.hasNext()) {
            cat = (SynonymCategory)it.next();
            if (oldHistory.getSynonymCategories().contains(cat)) continue;
            item = new SynonymCategoryHistoryItem(null, (SynonymCategory)cat, true, false);
            history.addItem(item);
        }
        LinkedList<IdentifiedObject> newObjects = new LinkedList<IdentifiedObject>();
        it = newHistory.getObjects().iterator();
        while (it.hasNext()) {
            io = (IdentifiedObject)it.next();
            oldio = oldHistory.getObject(io.getID());
            if (oldio != null) continue;
            history.addItem(new CreateObjectHistoryItem(io.getID(), io.getType().getID()));
            newObjects.add(io);
        }
        it = newObjects.iterator();
        while (it.hasNext()) {
            io = (IdentifiedObject)it.next();
            oldio = oldHistory.getObject(io.getID());
            DefaultHistoryList creationList = new DefaultHistoryList();
            if (io.getType() instanceof OBOClass) {
                IdentifiedObject blankTerm = oldHistory.getObjectFactory().createObject(io.getID(), (OBOClass)io.getType(), io.isAnonymous());
                HistoryGenerator.getTermTextChanges(blankTerm, io, creationList);
                HistoryGenerator.getParentageChanges(blankTerm, io, creationList);
                HistoryGenerator.getObsoleteChanges(blankTerm, io, creationList);
                HistoryGenerator.getNamespaceChanges(blankTerm, io, creationList);
            }
            if (creationList.size() > 1) {
                TermMacroHistoryItem item3 = new TermMacroHistoryItem("Populated new object " + io.getID());
                item3.setHistoryList(creationList);
                history.addItem(item3);
                continue;
            }
            history.addItem(creationList.getItemAt(0));
        }
        it = oldHistory.getObjects().iterator();
        while (it.hasNext()) {
            io = (IdentifiedObject)it.next();
            IdentifiedObject newio = newHistory.getObject(io.getID());
            if (newio == null) {
                if (io instanceof LinkedObject) {
                    Link link;
                    LinkedObject lo = (LinkedObject)io;
                    Iterator it2 = lo.getParents().iterator();
                    while (it2.hasNext()) {
                        link = (Link)it2.next();
                        history.addItem(new DeleteLinkHistoryItem(link));
                    }
                    it2 = lo.getChildren().iterator();
                    while (it2.hasNext()) {
                        link = (Link)it2.next();
                        history.addItem(new DeleteLinkHistoryItem(link));
                    }
                }
                history.addItem(new DestroyObjectHistoryItem(io));
                continue;
            }
            if (!io.getType().equals(newio.getType())) {
                history.getWarnings().add("Uh oh! " + io + " changed type between versions of this file!");
            }
            HistoryGenerator.getTermTextChanges(io, newio, history);
            HistoryGenerator.getParentageChanges(io, newio, history);
            HistoryGenerator.getObsoleteChanges(io, newio, history);
        }
        return history;
    }

    public static void getChanges(IdentifiedObject io, IdentifiedObject newio, HistoryList changes) {
        HistoryGenerator.getParentageChanges(io, newio, changes);
        HistoryGenerator.getObsoleteChanges(io, newio, changes);
        HistoryGenerator.getTermTextChanges(io, newio, changes);
        HistoryGenerator.getNamespaceChanges(io, newio, changes);
    }

    public static HistoryList getChanges(IdentifiedObject io, IdentifiedObject newio) {
        DefaultHistoryList changes = new DefaultHistoryList();
        HistoryGenerator.getChanges(io, newio, changes);
        return changes;
    }

    public static void getParentageChanges(IdentifiedObject io, IdentifiedObject newio, HistoryList history) {
        if (HistoryGenerator.checkInterface(io, history, LinkedObject.class) && HistoryGenerator.checkInterface(newio, history, LinkedObject.class)) {
            Link foundLink;
            Link link;
            LinkedObject lio = (LinkedObject)io;
            LinkedObject lnewio = (LinkedObject)newio;
            Iterator it2 = lio.getParents().iterator();
            while (it2.hasNext()) {
                link = (Link)it2.next();
                foundLink = TermUtil.findParentRelNoIntersection(link, lnewio);
                if (foundLink == null) {
                    history.addItem(new DeleteLinkHistoryItem(link));
                    continue;
                }
                if (!ObjectUtil.equals((Object)link.getNamespace(), (Object)foundLink.getNamespace())) {
                    history.addItem(new TRNamespaceHistoryItem(link, foundLink.getNamespace()));
                }
                if (link instanceof OBORestriction != foundLink instanceof OBORestriction) {
                    history.getWarnings().add(link + " changed interface types!");
                }
                if (!(link instanceof OBORestriction)) continue;
                OBORestriction rlink = (OBORestriction)link;
                OBORestriction rfoundLink = (OBORestriction)foundLink;
                if (!ObjectUtil.equals((Object)rlink.getCardinality(), (Object)rfoundLink.getCardinality())) {
                    history.addItem(new CardinalityHistoryItem(rlink, rfoundLink.getCardinality()));
                }
                if (!ObjectUtil.equals((Object)rlink.getMaxCardinality(), (Object)rfoundLink.getMaxCardinality())) {
                    history.addItem(new MaxCardinalityHistoryItem(rlink, rfoundLink.getMaxCardinality()));
                }
                if (!ObjectUtil.equals((Object)rlink.getMinCardinality(), (Object)rfoundLink.getMinCardinality())) {
                    history.addItem(new MinCardinalityHistoryItem(rlink, rfoundLink.getMinCardinality()));
                }
                if (rlink.isNecessarilyTrue() != rfoundLink.isNecessarilyTrue()) {
                    history.addItem(new NecessarilyTrueHistoryItem(rlink));
                }
                if (rlink.isInverseNecessarilyTrue() != rfoundLink.isInverseNecessarilyTrue()) {
                    history.addItem(new InverseNecHistoryItem(rlink));
                }
                if (rlink.completes() == rfoundLink.completes()) continue;
                history.addItem(new CompletesHistoryItem(rlink));
            }
            it2 = lnewio.getParents().iterator();
            while (it2.hasNext()) {
                link = (Link)it2.next();
                foundLink = TermUtil.findParentRelNoIntersection(link, lio);
                if (foundLink != null) continue;
                history.addItem(new TermCopyHistoryItem(link.getParent(), link.getChild(), link.getType()));
                OBORestrictionImpl newLink = new OBORestrictionImpl(link.getChild(), link.getType(), link.getParent());
                if (link.getNamespace() != null) {
                    history.addItem(new TRNamespaceHistoryItem(new HistoryItem.StringRelationship(link), null, link.getNamespace().getID()));
                }
                if (!(link instanceof OBORestriction)) continue;
                OBORestriction rlink = (OBORestriction)link;
                if (rlink.getCardinality() != null) {
                    history.addItem(new CardinalityHistoryItem(newLink, rlink.getCardinality()));
                }
                if (rlink.getMaxCardinality() != null) {
                    history.addItem(new MaxCardinalityHistoryItem(newLink, rlink.getMaxCardinality()));
                }
                if (rlink.getMinCardinality() != null) {
                    history.addItem(new MinCardinalityHistoryItem(newLink, rlink.getMinCardinality()));
                }
                if (!rlink.isNecessarilyTrue()) {
                    history.addItem(new NecessarilyTrueHistoryItem(new HistoryItem.StringRelationship(newLink), true));
                }
                if (rlink.isInverseNecessarilyTrue()) {
                    history.addItem(new InverseNecHistoryItem(new HistoryItem.StringRelationship(newLink), false));
                }
                if (!rlink.completes()) continue;
                history.addItem(new CompletesHistoryItem(new HistoryItem.StringRelationship(newLink), false));
            }
        }
    }

    public static void getObsoleteChanges(IdentifiedObject io, IdentifiedObject newio, HistoryList history) {
        if (TermUtil.isObsolete(newio) && !TermUtil.isObsolete(io)) {
            if (!(newio instanceof ObsoletableObject)) {
                history.getWarnings().add(newio + " is not an ObsoletableObject");
            } else {
                history.addItem(new ObsoleteObjectHistoryItem(io));
            }
        } else if (!TermUtil.isObsolete(newio) && TermUtil.isObsolete(io)) {
            history.getWarnings().add(newio + " was somehow unobsoleted!");
        }
    }

    public static void getNamespaceChanges(IdentifiedObject io, IdentifiedObject newio, HistoryList history) {
        if (!ObjectUtil.equals((Object)io.getNamespace(), (Object)newio.getNamespace())) {
            history.addItem(new NamespaceHistoryItem(io, newio.getNamespace()));
        }
    }

    public static void getTermTextChanges(IdentifiedObject io, IdentifiedObject newio, HistoryList history) {
        HistoryGenerator.getTermTextChanges(io, newio, history, false);
    }

    public static void getTermTextChanges(IdentifiedObject io, IdentifiedObject newio, HistoryList history, boolean ignoreSecondaryIDs) {
        Dbxref ref;
        IdentifiedObject dnewio;
        IdentifiedObject dio;
        Iterator it;
        IdentifiedObject cnewio;
        IdentifiedObject cio;
        if (!io.getName().equals(newio.getName())) {
            history.addItem(new NameChangeHistoryItem(io, newio.getName()));
        }
        if (HistoryGenerator.checkInterface(io, history, CommentedObject.class) != HistoryGenerator.checkInterface(newio, history, CommentedObject.class)) {
            history.getWarnings().add(io + " changed whether it is " + "a CommentedObject!");
            return;
        }
        if (HistoryGenerator.checkInterface(io, history, CommentedObject.class)) {
            cio = (CommentedObject)io;
            cnewio = (CommentedObject)newio;
            if (!ObjectUtil.equals((Object)cio.getComment(), (Object)cnewio.getComment())) {
                history.addItem(new CommentChangeHistoryItem((CommentedObject)cio, cnewio.getComment()));
            }
        }
        if (!ignoreSecondaryIDs) {
            if (HistoryGenerator.checkInterface(io, history, MultiIDObject.class) != HistoryGenerator.checkInterface(newio, history, MultiIDObject.class)) {
                history.getWarnings().add(io + " changed whether it is " + "a MultiIDObject!");
                return;
            }
            if (HistoryGenerator.checkInterface(io, history, MultiIDObject.class)) {
                String id;
                MultiIDObject mio = (MultiIDObject)io;
                MultiIDObject cmio = (MultiIDObject)newio;
                it = mio.getSecondaryIDs().iterator();
                while (it.hasNext()) {
                    id = (String)it.next();
                    if (cmio.getSecondaryIDs().contains(id)) continue;
                    history.addItem(new SecondaryIDHistoryItem(mio, id, true));
                }
                it = cmio.getSecondaryIDs().iterator();
                while (it.hasNext()) {
                    id = (String)it.next();
                    if (mio.getSecondaryIDs().contains(id)) continue;
                    history.addItem(new SecondaryIDHistoryItem(mio, id, false));
                }
            }
        }
        if (HistoryGenerator.checkInterface(io, history, DefinedObject.class) != HistoryGenerator.checkInterface(newio, history, DefinedObject.class)) {
            history.getWarnings().add(io + " changed whether it is " + "a DefinedObject!");
            return;
        }
        if (HistoryGenerator.checkInterface(io, history, DefinedObject.class)) {
            dio = (DefinedObject)io;
            dnewio = (DefinedObject)newio;
            if (!ObjectUtil.equals((Object)dio.getDefinition(), (Object)dnewio.getDefinition())) {
                history.addItem(new DefinitionChangeHistoryItem((DefinedObject)dio, dnewio.getDefinition()));
            }
            it = dio.getDefDbxrefs().iterator();
            while (it.hasNext()) {
                ref = (Dbxref)it.next();
                if (dnewio.getDefDbxrefs().contains(ref)) continue;
                history.addItem(new DelDbxrefHistoryItem(io.getID(), ref, true, null));
            }
            it = dnewio.getDefDbxrefs().iterator();
            while (it.hasNext()) {
                ref = (Dbxref)it.next();
                if (dio.getDefDbxrefs().contains(ref)) continue;
                history.addItem(new AddDbxrefHistoryItem(io.getID(), ref, true, null));
            }
        }
        if (HistoryGenerator.checkInterface(io, history, DbxrefedObject.class) != HistoryGenerator.checkInterface(newio, history, DbxrefedObject.class)) {
            history.getWarnings().add(io + " changed whether it is a " + "DbxrefedObject");
        } else if (HistoryGenerator.checkInterface(io, history, DbxrefedObject.class)) {
            dio = (DbxrefedObject)io;
            dnewio = (DbxrefedObject)newio;
            it = dio.getDbxrefs().iterator();
            while (it.hasNext()) {
                ref = (Dbxref)it.next();
                if (dnewio.getDbxrefs().contains(ref)) continue;
                history.addItem(new DelDbxrefHistoryItem(io.getID(), ref, false, null));
            }
            it = dnewio.getDbxrefs().iterator();
            while (it.hasNext()) {
                ref = (Dbxref)it.next();
                if (dio.getDbxrefs().contains(ref)) continue;
                history.addItem(new AddDbxrefHistoryItem(io.getID(), ref, false, null));
            }
        }
        if (HistoryGenerator.checkInterface(io, history, CategorizedObject.class) != HistoryGenerator.checkInterface(newio, history, CategorizedObject.class)) {
            history.getWarnings().add(io + " changed whether it is a " + "CategorizedObject");
        } else if (HistoryGenerator.checkInterface(io, history, CategorizedObject.class)) {
            CategoryChangeHistoryItem item;
            TermCategory termCategory;
            cio = (CategorizedObject)io;
            cnewio = (CategorizedObject)newio;
            it = cio.getCategories().iterator();
            while (it.hasNext()) {
                termCategory = (TermCategory)it.next();
                if (cnewio.getCategories().contains(termCategory)) continue;
                item = new CategoryChangeHistoryItem(termCategory.getName(), true, io.getID());
                history.addItem(item);
            }
            it = cnewio.getCategories().iterator();
            while (it.hasNext()) {
                termCategory = (TermCategory)it.next();
                if (cio.getCategories().contains(termCategory)) continue;
                item = new CategoryChangeHistoryItem(termCategory.getName(), false, io.getID());
                history.addItem(item);
            }
        }
        if (HistoryGenerator.checkInterface(io, history, SynonymedObject.class) != HistoryGenerator.checkInterface(newio, history, SynonymedObject.class)) {
            history.getWarnings().add(io + " changed whether it is a " + "SynonymedObject");
        } else if (HistoryGenerator.checkInterface(io, history, SynonymedObject.class)) {
            Iterator it2;
            Synonym s;
            SynonymedObject sio = (SynonymedObject)io;
            SynonymedObject snewio = (SynonymedObject)newio;
            it = sio.getSynonyms().iterator();
            while (it.hasNext()) {
                s = (Synonym)it.next();
                boolean found = false;
                it2 = snewio.getSynonyms().iterator();
                while (it2.hasNext()) {
                    Synonym news = (Synonym)it2.next();
                    if (!news.getText().equals(s.getText())) continue;
                    found = true;
                    Iterator it3 = s.getDbxrefs().iterator();
                    while (it3.hasNext()) {
                        Dbxref oldref = (Dbxref)it3.next();
                        if (news.getDbxrefs().contains(oldref)) continue;
                        history.addItem(new DelDbxrefHistoryItem(sio.getID(), oldref, false, s.getText()));
                    }
                    it3 = news.getDbxrefs().iterator();
                    while (it3.hasNext()) {
                        Dbxref newref = (Dbxref)it3.next();
                        if (s.getDbxrefs().contains(newref)) continue;
                        history.addItem(new AddDbxrefHistoryItem(sio.getID(), newref, false, s.getText()));
                    }
                    if (!ObjectUtil.equals((Object)news.getSynonymCategory(), (Object)s.getSynonymCategory())) {
                        history.addItem(new ChangeSynCategoryHistoryItem(sio, s, news.getSynonymCategory()));
                    }
                    if (news.getScope() == s.getScope()) break;
                    history.addItem(new ChangeSynScopeHistoryItem(io.getID(), s.getText(), s.getScope(), news.getScope()));
                    break;
                }
                if (found) continue;
                history.addItem(new DelSynonymHistoryItem(io.getID(), s.getText()));
            }
            it = snewio.getSynonyms().iterator();
            while (it.hasNext()) {
                s = (Synonym)it.next();
                boolean found = false;
                it2 = sio.getSynonyms().iterator();
                while (it2.hasNext()) {
                    Synonym olds = (Synonym)it2.next();
                    if (!olds.getText().equals(s.getText())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                history.addItem(new AddSynonymHistoryItem(io.getID(), s.getText()));
                it2 = s.getDbxrefs().iterator();
                while (it2.hasNext()) {
                    Dbxref ref2 = (Dbxref)it2.next();
                    history.addItem(new AddDbxrefHistoryItem(sio.getID(), ref2, false, s.getText()));
                }
                if (s.getSynonymCategory() != null) {
                    history.addItem(new ChangeSynCategoryHistoryItem(sio.getID(), s.getText(), null, s.getSynonymCategory().getID()));
                }
                if (s.getScope() == 0) continue;
                history.addItem(new ChangeSynScopeHistoryItem(io.getID(), s.getText(), 0, s.getScope()));
            }
        }
        if (HistoryGenerator.checkInterface(io, history, OBOProperty.class) != HistoryGenerator.checkInterface(newio, history, OBOProperty.class)) {
            history.getWarnings().add(io + " changed whether it is " + "a OBOProperty!");
            return;
        }
        if (HistoryGenerator.checkInterface(io, history, OBOProperty.class)) {
            OBOProperty prop = (OBOProperty)io;
            OBOProperty newprop = (OBOProperty)newio;
            if (!ObjectUtil.equals((Object)prop.getDomain(), (Object)newprop.getDomain())) {
                history.addItem(new DomainHistoryItem(prop, newprop.getDomain()));
            }
            if (!ObjectUtil.equals((Object)prop.getRange(), (Object)newprop.getRange())) {
                history.addItem(new RangeHistoryItem(prop, newprop.getRange()));
            }
            if (prop.isTransitive() != newprop.isTransitive()) {
                history.addItem(new TransitiveHistoryItem(prop));
            }
            if (prop.isSymmetric() != newprop.isSymmetric()) {
                history.addItem(new SymmetricHistoryItem(prop));
            }
            if (prop.isCyclic() != newprop.isCyclic()) {
                history.addItem(new CyclicHistoryItem(prop));
            }
        }
    }
}

