/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel;

import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMergeHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMoveHistoryItem;
import org.geneontology.oboedit.gui.Controller;

public class HistoryTreeModel
implements TreeModel {
    protected Vector histories;
    private Vector listeners;
    private Object root = "All histories";
    protected Controller controller;

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public HistoryTreeModel(OBOSession history, Controller controller) {
        this.histories = new Vector();
        this.histories.addAll(history.getArchivedHistories());
        this.histories.add(history.getCurrentHistory());
        this.listeners = new Vector();
        this.setController(controller);
    }

    public HistoryTreeModel(HistoryList historyList, Controller controller) {
        this.histories = new Vector();
        this.histories.add(historyList);
        this.listeners = new Vector();
        this.setController(controller);
    }

    public HistoryTreeModel(Vector histories, Controller controller) {
        this.listeners = new Vector();
        this.histories = histories;
        this.setController(controller);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.addElement(l);
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeModelListener tml = (TreeModelListener)this.listeners.elementAt(i);
            tml.treeStructureChanged(e);
        }
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.removeElement(l);
    }

    public TreePath getActiveHistoryPath() {
        Object[] nodes = new Object[]{this.root, this.controller.getSession()};
        return new TreePath(nodes);
    }

    public void reloadActiveHistory() {
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.getActiveHistoryPath()));
    }

    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            if (index < this.histories.size()) {
                return this.histories.elementAt(index);
            }
            return this.controller.getSession();
        }
        if (parent instanceof OBOSession) {
            OBOSession editHistory = (OBOSession)parent;
            if (index < editHistory.getArchivedHistories().size()) {
                return ((OBOSession)parent).getArchivedHistories().get(index);
            }
            return ((OBOSession)parent).getCurrentHistory();
        }
        if (parent instanceof HistoryList) {
            return ((HistoryList)parent).getItemAt(index);
        }
        if (parent instanceof TermMacroHistoryItem) {
            return ((TermMacroHistoryItem)parent).getHistoryItemAt(index);
        }
        if (parent instanceof TermMoveHistoryItem) {
            return "Moved";
        }
        if (parent instanceof TermCopyHistoryItem) {
            return "Copied";
        }
        if (parent instanceof DeleteLinkHistoryItem) {
            return "Deleted";
        }
        if (parent instanceof TermMergeHistoryItem) {
            return "Merge";
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent == this.root) {
            return this.histories.size();
        }
        if (parent instanceof OBOSession) {
            return ((OBOSession)parent).getArchivedHistories().size() + 1;
        }
        if (parent instanceof HistoryList) {
            return ((HistoryList)parent).size();
        }
        if (parent instanceof TermMacroHistoryItem) {
            return ((TermMacroHistoryItem)parent).getHistoryItemCount();
        }
        if (parent instanceof TermMoveHistoryItem) {
            return 0;
        }
        if (parent instanceof TermCopyHistoryItem) {
            return 0;
        }
        if (parent instanceof DeleteLinkHistoryItem) {
            return 0;
        }
        if (parent instanceof TermMergeHistoryItem) {
            return 0;
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.root) {
            return this.histories.indexOf(child);
        }
        if (parent instanceof OBOSession) {
            return ((OBOSession)parent).getCurrentHistory().getIndex((HistoryItem)child);
        }
        if (parent instanceof HistoryList) {
            return ((HistoryList)parent).getIndex((HistoryItem)child);
        }
        return -1;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

