/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.geneontology.expression.ExpressionException;
import org.geneontology.expression.JexlContext;
import org.geneontology.expression.context.HashMapContext;
import org.geneontology.oboedit.datamodel.DanglingObject;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.filters.Filter;
import org.geneontology.oboedit.gui.filters.LinkFilter;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;
import org.geneontology.util.ReusableProgressEvent;

public class SearchEngine {
    public static SearchThread getSearchThread(LinkDatabase linkDatabase, Filter filter, Filter linkFilter, JexlContext context) {
        return new SearchThread(linkDatabase, filter, linkFilter, context);
    }

    public static SearchThread getSearchThread(Set searchSet, Filter filter, Filter linkFilter, JexlContext context) {
        return new SearchThread(searchSet, filter, linkFilter, context);
    }

    public Collection search(LinkDatabase linkDatabase, Filter filter, LinkFilter linkFilter, JexlContext context) {
        SearchThread thread = SearchEngine.getSearchThread(linkDatabase, filter, (Filter)linkFilter, context);
        thread.run();
        return thread.getResults();
    }

    public Collection search(Set searchSet, Filter filter, LinkFilter linkFilter, JexlContext context) {
        SearchThread thread = SearchEngine.getSearchThread(searchSet, filter, (Filter)linkFilter, context);
        thread.run();
        return thread.getResults();
    }

    public static class SearchThread
    extends Thread {
        protected LinkDatabase linkDatabase;
        protected Filter filter;
        protected Filter linkFilter;
        protected boolean halt = false;
        protected Set searchSet;
        protected List progressListeners = new LinkedList();
        protected ReusableProgressEvent rpe = new ReusableProgressEvent((Object)this);
        protected JexlContext context;
        protected Runnable startRunnable;
        protected Runnable haltRunnable;
        protected Runnable endRunnable;
        private SearchMonitor searchMonitor;

        public void setStartRunnable(Runnable startRunnable) {
            this.startRunnable = startRunnable;
        }

        public void setHaltRunnable(Runnable haltRunnable) {
            this.haltRunnable = haltRunnable;
        }

        public void setEndRunnable(Runnable endRunnable) {
            this.endRunnable = endRunnable;
        }

        public Runnable getStartRunnable() {
            return this.startRunnable;
        }

        public Runnable getHaltRunnable() {
            return this.haltRunnable;
        }

        public Runnable getEndRunnable() {
            return this.endRunnable;
        }

        public void showProgress(String message, int val) {
            Iterator it = this.progressListeners.iterator();
            while (it.hasNext()) {
                ProgressListener listener = (ProgressListener)it.next();
                this.rpe.setFastVal(val);
                this.rpe.setDescription(message);
                listener.progressMade((ProgressEvent)this.rpe);
            }
        }

        public Collection getResults() {
            return this.searchSet;
        }

        public void addProgressListener(ProgressListener listener) {
            this.progressListeners.add(listener);
        }

        public void removeProgressListener(ProgressListener listener) {
            this.progressListeners.remove(listener);
        }

        protected SearchThread(LinkDatabase linkDatabase, Filter filter, Filter linkFilter, JexlContext context) {
            this(linkDatabase, null, filter, linkFilter, context);
        }

        protected SearchThread(Set searchSet, Filter filter, Filter linkFilter, JexlContext context) {
            this(null, searchSet, filter, linkFilter, context);
        }

        protected SearchThread(LinkDatabase linkDatabase, Set searchSet, Filter filter, Filter linkFilter, JexlContext context) {
            this.searchSet = searchSet;
            this.linkDatabase = linkDatabase;
            this.filter = filter;
            this.linkFilter = linkFilter;
            if (context == null) {
                context = new HashMapContext();
            }
            this.context = context;
        }

        protected Set getSet(LinkDatabase linkDatabase) {
            LinkedHashSet<IdentifiedObject> searchSet = new LinkedHashSet<IdentifiedObject>();
            Iterator it = linkDatabase.getObjects().iterator();
            int total = TermUtil.getObjectCount(linkDatabase);
            int i = 0;
            while (it.hasNext()) {
                IdentifiedObject io;
                if (100 * i / total % 5 == 0) {
                    this.showProgress("Building search database", 100 * i / total);
                }
                if ((io = (IdentifiedObject)it.next()) instanceof LinkedObject && !(io instanceof DanglingObject)) {
                    if (this.filter != null) {
                        searchSet.add(io);
                    }
                    if (this.linkFilter != null && io instanceof LinkedObject && !(io instanceof DanglingObject)) {
                        LinkedObject t = (LinkedObject)io;
                        searchSet.addAll(linkDatabase.getParents(t));
                    }
                    if (this.halt) break;
                }
                ++i;
            }
            return searchSet;
        }

        public void run() {
            this.searchMonitor = new SearchMonitor();
            JexlContext context = this.context.createNewFrame();
            try {
                context.setLocalVariable("Filter", (Object)this.searchMonitor, false);
            }
            catch (ExpressionException e) {
                // empty catch block
            }
            if (this.startRunnable != null) {
                SwingUtilities.invokeLater(this.startRunnable);
            }
            if (this.filter != null) {
                this.filter.setContext(context);
            }
            if (this.searchSet == null) {
                this.searchSet = this.getSet(this.linkDatabase);
                if (this.halt) {
                    if (this.haltRunnable != null) {
                        SwingUtilities.invokeLater(this.haltRunnable);
                    }
                    return;
                }
            }
            Iterator it = this.searchSet.iterator();
            int total = this.searchSet.size();
            int lastProgressNum = 0;
            int i = 0;
            while (it.hasNext()) {
                Object o;
                int newProgressNum = 100 * i / total;
                if (lastProgressNum != newProgressNum && newProgressNum % 2 == 0) {
                    this.showProgress("Searching ", 100 * i / total);
                    lastProgressNum = newProgressNum;
                }
                if ((o = it.next()) instanceof IdentifiedObject) {
                    this.searchMonitor.setCurrent(o);
                    if (this.filter == null || !this.filter.satisfies(o)) {
                        it.remove();
                    }
                } else if (o instanceof Link) {
                    this.searchMonitor.setCurrent(((Link)o).getChild());
                    if (this.linkFilter == null || !this.linkFilter.satisfies(o)) {
                        it.remove();
                    }
                } else {
                    System.err.println("Unrecognized object " + o + "!");
                    it.remove();
                }
                if (this.halt) {
                    if (this.haltRunnable != null) {
                        SwingUtilities.invokeLater(this.haltRunnable);
                    }
                    return;
                }
                ++i;
            }
            this.showProgress("Search complete", 100);
            if (this.endRunnable != null) {
                SwingUtilities.invokeLater(this.endRunnable);
            }
        }

        public void halt() {
            this.halt = true;
        }

        public void setContext(JexlContext context) {
            this.context = context;
        }
    }

    public static class SearchMonitor {
        protected Object current;

        public Object getCurrent() {
            return this.current;
        }

        public void setCurrent(Object current) {
            this.current = current;
        }
    }
}

