/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import org.geneontology.oboedit.datamodel.Datatype;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.impl.SimpleDatatype;

public class BooleanDatatype
extends SimpleDatatype {
    private static final long serialVersionUID = 4670390380971503460L;

    public String getID() {
        return "xsd:boolean";
    }

    public String getName() {
        return this.getID();
    }

    public String getComment() {
        return "Represents a boolean (true/false) value";
    }

    public Namespace getNamespace() {
        return null;
    }

    public boolean isAbstract() {
        return false;
    }

    public Datatype getSupertype() {
        return Datatype.SIMPLE_TYPE;
    }

    public boolean isLegalValue(String string) {
        return string.equals("true") || string.equals("false");
    }

    public Object getValue(String string) {
        return new Boolean(string);
    }

    public String getString(Object o) {
        if (o instanceof Boolean) {
            return o.toString();
        }
        throw new IllegalArgumentException("BooleanDatatype can only convert values of type java.lang.Boolean");
    }
}

