/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Instance;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.ObsoletableObject;
import org.geneontology.oboedit.datamodel.ReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.Relationship;
import org.geneontology.oboedit.datamodel.RootAlgorithm;
import org.geneontology.oboedit.datamodel.TermModel;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.impl.FilteredLinkDatabase;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.oboedit.datamodel.impl.TrimmedLinkDatabase;
import org.geneontology.oboedit.datamodel.impl.TrivialLink;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.event.ReconfigEvent;
import org.geneontology.oboedit.gui.event.ReconfigListener;
import org.geneontology.oboedit.gui.event.RefreshEvent;
import org.geneontology.oboedit.gui.event.RefreshListener;
import org.geneontology.oboedit.gui.event.RootChangeEvent;
import org.geneontology.oboedit.gui.event.RootChangeListener;
import org.geneontology.oboedit.gui.filters.CompoundFilter;
import org.geneontology.oboedit.gui.filters.CompoundFilterImpl;
import org.geneontology.oboedit.gui.filters.EqualsComparison;
import org.geneontology.oboedit.gui.filters.Filter;
import org.geneontology.oboedit.gui.filters.IDSearchCriterion;
import org.geneontology.oboedit.gui.filters.LinkFilter;
import org.geneontology.oboedit.gui.filters.LinkFilterImpl;
import org.geneontology.oboedit.gui.filters.ObjectFilterImpl;
import org.geneontology.util.VectorUtil;

public class DefaultTermModel
implements TermModel {
    protected Controller controller;
    protected Vector listeners = new Vector();
    protected boolean showTerms = true;
    protected boolean showTypes = true;
    protected boolean showObsoletes = true;
    protected boolean showInstances = false;
    protected Map childCache;
    protected Map leafCache;
    protected List topLevel = new Vector();
    protected List classRoots = new Vector();
    protected List typeRoots = new Vector();
    protected List instanceRoots = new Vector();
    protected List obsoleteRoots = new Vector();
    protected OBOSession history;
    protected LinkDatabase linkDatabase;
    protected Filter userTermFilter;
    protected Filter userLinkFilter;
    protected CompoundFilter linkFilter = new CompoundFilterImpl();
    protected CompoundFilter termFilter = new CompoundFilterImpl();
    protected RootAlgorithm rootAlgorithm = RootAlgorithm.GREEDY;
    protected TermSorter comparator = new TermSorter(true);
    protected OBOProperty filterProperty = null;
    protected boolean answerLeafHonestly = false;
    protected ReconfigListener reconfigListener = new ReconfigListener(){

        public void configReloaded(ReconfigEvent e) {
            DefaultTermModel.this.setSortMode(true);
        }
    };
    protected RootChangeListener rootChangeListener = new RootChangeListener(){

        public void changeRoot(RootChangeEvent e) {
            DefaultTermModel.this.reload(null);
        }
    };
    protected RefreshListener reloadListener = new RefreshListener(){

        public void reload(RefreshEvent e) {
            if (!e.getSource().equals(DefaultTermModel.this)) {
                new Exception("****DefaultTreeModel: Called reload AGAIN!!!").printStackTrace();
                DefaultTermModel.this.reload(e.getGraphEditList());
            }
        }
    };

    public LinkDatabase getLinkDatabase() {
        return this.linkDatabase;
    }

    public void setPainting(boolean isPainting) {
        this.answerLeafHonestly = isPainting;
    }

    public RootAlgorithm getRootAlgorithm() {
        return this.rootAlgorithm;
    }

    public void setRootAlgorithm(RootAlgorithm rootAlgorithm) {
        this.rootAlgorithm = rootAlgorithm;
    }

    protected void initCaches() {
        this.childCache = new LinkedHashMap(){
            private static final long serialVersionUID = -9192215743438642387L;

            protected boolean removeEldestEntry(Map.Entry eldest) {
                boolean doRemove = this.size() >= DefaultTermModel.this.controller.getViewCacheSize();
                return doRemove;
            }
        };
        this.leafCache = new LinkedHashMap(){
            private static final long serialVersionUID = -9192215743438642387L;

            protected boolean removeEldestEntry(Map.Entry eldest) {
                boolean doRemove = this.size() >= DefaultTermModel.this.controller.getViewCacheSize();
                return doRemove;
            }
        };
    }

    protected void buildTopLevel() {
        this.topLevel.clear();
        if (this.showTerms) {
            this.topLevel.add(OBOSession.CLASSES);
        }
        if (this.showTypes) {
            this.topLevel.add(OBOSession.TYPES);
        }
        if (this.showInstances) {
            this.topLevel.add(OBOSession.INSTANCES);
        }
        if (this.showObsoletes) {
            this.topLevel.add(OBOSession.OBSOLETE);
        }
    }

    public DefaultTermModel(Controller controller) {
        this.setController(controller);
        this.listeners = new Vector();
        this.initCaches();
        this.buildTopLevel();
        this.initializeFilters();
        this.setSortMode(false);
    }

    protected void initializeFilters() {
        if (this.userTermFilter != null) {
            this.termFilter.addFilter(this.userTermFilter);
        }
        this.termFilter.addFilter(this.controller.getGlobalTermFilter());
        if (this.userLinkFilter != null) {
            this.linkFilter.addFilter(this.userLinkFilter);
        }
        this.linkFilter.addFilter(this.controller.getGlobalLinkFilter());
    }

    public void setLinkFilter(Filter filter) {
        if (this.userLinkFilter != null) {
            this.linkFilter.removeFilter(this.userLinkFilter);
        }
        this.userLinkFilter = filter;
        if (this.userLinkFilter != null) {
            this.linkFilter.addFilter(this.userLinkFilter);
        }
        this.reload(null);
    }

    public void setTermFilter(Filter filter) {
        if (this.userTermFilter != null) {
            this.termFilter.removeFilter(this.userTermFilter);
        }
        this.userTermFilter = filter;
        if (this.userTermFilter != null) {
            this.termFilter.addFilter(this.userTermFilter);
        }
        this.reload(null);
    }

    public Filter getTermFilter() {
        return this.userTermFilter;
    }

    public Filter getLinkFilter() {
        return this.userLinkFilter;
    }

    public void setHistory(OBOSession history) {
        this.history = history;
        this.reload(null);
    }

    public void setShowTerms(boolean showTerms) {
        this.showTerms = showTerms;
    }

    public void setShowTypes(boolean showTypes) {
        this.showTypes = showTypes;
    }

    public void setShowObsoletes(boolean showObsoletes) {
        this.showObsoletes = showObsoletes;
    }

    public void setShowInstances(boolean showInstances) {
        this.showInstances = showInstances;
    }

    public boolean getShowTerms() {
        return this.showTerms;
    }

    public boolean getShowTypes() {
        return this.showTypes;
    }

    public boolean getShowObsoletes() {
        return this.showObsoletes;
    }

    public void setController(Controller in) {
        this.controller = in;
        this.controller.addListener(this.reconfigListener);
        this.controller.addListener(this.rootChangeListener);
        this.setHistory(this.controller.getSession());
        this.setSortMode(false);
    }

    public void cleanup() {
        this.controller.removeListener(this.reconfigListener);
        this.controller.removeListener(this.rootChangeListener);
    }

    protected void setSortMode(boolean fireReload) {
        this.comparator.setIgnoreCase(!Controller.getController().caseSensitiveSort());
        if (fireReload) {
            this.controller.fireReload(new RefreshEvent(this));
        }
    }

    public Object getChild(Object parent, int index) {
        return this.getChildren(parent).get(index);
    }

    public int getChildCount(Object parent) {
        return this.getChildren(parent).size();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return this.getChildren(parent).indexOf(child);
    }

    public Object getRoot() {
        return OBOSession.ROOT;
    }

    public boolean isLeaf(Object parent) {
        if (this.answerLeafHonestly) {
            if (parent instanceof Relationship) {
                LinkedObject lo = ((Relationship)parent).getChild();
                if (TermUtil.isObsolete(lo)) {
                    return this.getReplacements((ObsoletableObject)((Object)lo)).isEmpty();
                }
                Collection children = (Collection)this.childCache.get(lo);
                if (children != null) {
                    return children.isEmpty();
                }
                Boolean val = (Boolean)this.leafCache.get(lo);
                if (val == null) {
                    val = this.linkDatabase.getChildren(lo).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
                    this.leafCache.put(lo, val);
                }
                return val;
            }
            return this.getChildren(parent).size() == 0;
        }
        return false;
    }

    public RefreshListener getReloadListener() {
        return this.reloadListener;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.addElement(l);
    }

    public OBOProperty getPropertyFilter() {
        return this.filterProperty;
    }

    public void setPropertyFilter(OBOProperty property) {
        if (property != this.filterProperty) {
            this.filterProperty = property;
            this.reload(null);
        }
    }

    protected LinkFilter getPropertyLinkFilter() {
        LinkFilterImpl basicLinkFilter = new LinkFilterImpl();
        basicLinkFilter.setAspect(2);
        ObjectFilterImpl idfilter = new ObjectFilterImpl();
        idfilter.setCriterion(new IDSearchCriterion());
        idfilter.setComparison(new EqualsComparison());
        idfilter.setValue(this.filterProperty.getID());
        basicLinkFilter.setFilter(idfilter);
        return basicLinkFilter;
    }

    protected void buildFilteredDatabase() {
        FilteredLinkDatabase filteredLinkDatabase;
        if (this.controller.getUseReasoner()) {
            if (this.filterProperty == null) {
                filteredLinkDatabase = new FilteredLinkDatabase(this.controller.getReasonedLinkDatabase());
            } else {
                ReasonedLinkDatabase ldb = this.controller.getFullReasoner();
                FilteredLinkDatabase propertyFiltered = new FilteredLinkDatabase(ldb);
                propertyFiltered.setFilterMethod(4);
                propertyFiltered.setLinkFilter(this.getPropertyLinkFilter());
                TrimmedLinkDatabase trimFiltered = new TrimmedLinkDatabase(ldb, propertyFiltered);
                trimFiltered.setUseReusableIterator(false);
                filteredLinkDatabase = new FilteredLinkDatabase(trimFiltered);
                LinkedObject lo = (LinkedObject)Controller.getController().getSession().getObject("ZFA:0000037");
                System.err.println("ldb.getParents(ZFA:0000037) = " + ldb.getParents(lo));
                System.err.println("propertyFiltered.getParents(ZFA:0000037) = " + propertyFiltered.getParents(lo));
                System.err.println("trimFiltered.getParents(ZFA:0000037) = " + trimFiltered.getParents(lo));
                System.err.println("filteredLinkDatabase.getParents(ZFA:0000037) = " + filteredLinkDatabase.getParents(lo));
            }
            this.linkDatabase = filteredLinkDatabase;
        } else {
            filteredLinkDatabase = new FilteredLinkDatabase(this.history.getLinkDatabase());
            this.linkDatabase = filteredLinkDatabase;
        }
        filteredLinkDatabase.setTermFilter(this.termFilter, this.linkFilter);
    }

    public void reload(List graphOperations) {
        this.initCaches();
        this.buildTopLevel();
        this.history = this.controller.getSession();
        this.buildFilteredDatabase();
        this.classRoots = new Vector();
        this.typeRoots = new Vector();
        this.instanceRoots = new Vector();
        this.obsoleteRoots = new Vector();
        Set temp = TermUtil.mallocSet();
        TermUtil.detectRoots(temp, this.linkDatabase, this.getRootAlgorithm());
        Iterator it = temp.iterator();
        while (it.hasNext()) {
            IdentifiedObject identified = (IdentifiedObject)it.next();
            if (identified instanceof Instance) {
                Instance instance = (Instance)identified;
                TrivialLink link = new TrivialLink(instance);
                VectorUtil.insertSorted((List)this.instanceRoots, (Comparator)this.comparator, (Object)link);
                continue;
            }
            if (!(identified instanceof LinkedObject)) continue;
            LinkedObject io = (LinkedObject)identified;
            OBORestrictionImpl rootLink = new OBORestrictionImpl(io);
            if (TermUtil.isObsolete(io)) {
                VectorUtil.insertSorted((List)this.obsoleteRoots, (Comparator)this.comparator, (Object)rootLink);
                continue;
            }
            if (io instanceof OBOClass) {
                VectorUtil.insertSorted((List)this.classRoots, (Comparator)this.comparator, (Object)rootLink);
                continue;
            }
            if (!(io instanceof OBOProperty)) continue;
            VectorUtil.insertSorted((List)this.typeRoots, (Comparator)this.comparator, (Object)rootLink);
        }
        TermUtil.freeSet(temp);
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath(OBOSession.ROOT)));
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeModelListener tml = (TreeModelListener)this.listeners.elementAt(i);
            tml.treeStructureChanged(e);
        }
    }

    protected void fireNodesInserted(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeModelListener tml = (TreeModelListener)this.listeners.elementAt(i);
            tml.treeNodesInserted(e);
        }
    }

    protected void fireNodesRemoved(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeModelListener tml = (TreeModelListener)this.listeners.elementAt(i);
            tml.treeNodesRemoved(e);
        }
    }

    protected void fireNodeChanged(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeModelListener tml = (TreeModelListener)this.listeners.elementAt(i);
            tml.treeNodesChanged(e);
        }
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.removeElement(l);
    }

    public void valueForPathChanged(TreePath path, Object newVal) {
    }

    public List wrapSet(Collection c) {
        return this.wrapSet(c.iterator());
    }

    public List wrapSet(Iterator it) {
        ArrayList out = new ArrayList();
        while (it.hasNext()) {
            Object o = it.next();
            Link link = null;
            if (o instanceof LinkedObject) {
                LinkedObject io = (LinkedObject)o;
                link = new OBORestrictionImpl(io);
            } else if (o instanceof Link) {
                link = (Link)o;
            }
            int oldSize = out.size();
            VectorUtil.insertSorted(out, (Comparator)this.comparator, (Object)link);
            if (out.size() != oldSize) continue;
            System.err.println("Sizes are the same when adding " + link);
        }
        return out;
    }

    protected Set getReplacements(ObsoletableObject oo) {
        HashSet<OBORestrictionImpl> out = new HashSet<OBORestrictionImpl>();
        Iterator it = oo.getReplacedBy().iterator();
        while (it.hasNext()) {
            ObsoletableObject replacedBy = (ObsoletableObject)it.next();
            out.add(new OBORestrictionImpl((LinkedObject)((Object)replacedBy), OBOProperty.REPLACES, (LinkedObject)((Object)oo)));
        }
        it = oo.getConsiderReplacements().iterator();
        while (it.hasNext()) {
            ObsoletableObject consider = (ObsoletableObject)it.next();
            if (!(oo instanceof LinkedObject) || !(consider instanceof LinkedObject)) continue;
            out.add(new OBORestrictionImpl((LinkedObject)((Object)consider), OBOProperty.CONSIDER, (LinkedObject)((Object)oo)));
        }
        return out;
    }

    public List getChildren(Object parent) {
        if (parent.equals(OBOSession.ROOT)) {
            return this.topLevel;
        }
        if (parent.equals(OBOSession.CLASSES)) {
            return this.classRoots;
        }
        if (parent.equals(OBOSession.TYPES)) {
            return this.typeRoots;
        }
        if (parent.equals(OBOSession.OBSOLETE)) {
            return this.obsoleteRoots;
        }
        if (parent instanceof Relationship) {
            LinkedObject lo = ((Relationship)parent).getChild();
            List out = (List)this.childCache.get(lo);
            if (out == null) {
                out = TermUtil.isObsolete(lo) ? this.wrapSet(this.getReplacements((ObsoletableObject)((Object)lo))) : this.wrapSet(this.linkDatabase.getChildren(lo));
                this.childCache.put(lo, out);
                this.leafCache.remove(lo);
            }
            return out;
        }
        System.err.println("requested children of unknown object " + parent);
        return null;
    }

    protected static class TermSorter
    implements Comparator {
        protected boolean ignoreCase = true;

        public TermSorter(boolean ignoreCase) {
            this.setIgnoreCase(ignoreCase);
        }

        public void setIgnoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
        }

        public int compare(Object a, Object b) {
            int rankinga = TermSorter.getObjectRanking(a);
            int rankingb = TermSorter.getObjectRanking(b);
            if (rankinga == 0 && rankingb == 0) {
                Link la = (Link)a;
                Link lb = (Link)b;
                LinkedObject terma = la.getChild();
                LinkedObject termb = lb.getChild();
                int compval = this.ignoreCase ? terma.getName().compareToIgnoreCase(termb.getName()) : terma.getName().compareTo(termb.getName());
                if (compval == 0 && la.getType() != lb.getType()) {
                    compval = la.getType() == null ? -1 : (lb.getType() == null ? 1 : (this.ignoreCase ? la.getType().getID().compareToIgnoreCase(lb.getType().getID()) : la.getType().getID().compareTo(lb.getType().getID())));
                }
                return compval;
            }
            if (rankinga < rankingb) {
                return -1;
            }
            if (rankinga > rankingb) {
                return 1;
            }
            return 0;
        }

        protected static int getObjectRanking(Object a) {
            if (a instanceof Link) {
                return 0;
            }
            if (a.equals(OBOSession.ROOT)) {
                return 1;
            }
            if (a.equals(OBOSession.TYPES)) {
                return 2;
            }
            if (a.equals(OBOSession.OBSOLETE)) {
                return 3;
            }
            if (a.equals(OBOSession.INSTANCES)) {
                return 4;
            }
            return -1;
        }
    }
}

