/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.Collection;
import java.util.LinkedList;
import org.geneontology.oboedit.datamodel.Explanation;
import org.geneontology.oboedit.datamodel.ExplanationType;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;

public class ExplanationImpl
implements Explanation {
    private static final long serialVersionUID = 6051247092173393248L;
    protected ExplanationType type;
    protected Collection evidence;
    protected String desc;
    protected Collection supportingLinks = new LinkedList();
    protected Collection supportingObjects = new LinkedList();

    public ExplanationImpl(ExplanationType type) {
        this.type = type;
        this.evidence = new LinkedList();
    }

    public void addSupportingLink(Link link) {
        this.supportingLinks.add(link);
    }

    public void addSupportingObject(IdentifiedObject io) {
        this.supportingObjects.add(io);
    }

    public Collection getSupportingLinks() {
        return this.supportingLinks;
    }

    public Collection getSupportingObjects() {
        return this.supportingObjects;
    }

    public ExplanationType getExplanationType() {
        return this.type;
    }

    public Collection getEvidence() {
        return this.evidence;
    }

    public void addEvidence(Explanation exp) {
        this.evidence.add(exp);
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public int hashCode() {
        return this.type.hashCode() + ((Object)this.evidence).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Explanation) {
            Explanation e = (Explanation)o;
            return this.getExplanationType().equals(e.getExplanationType()) && ((Object)this.getEvidence()).equals(e.getEvidence());
        }
        return false;
    }
}

