/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Instance;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.OperationModel;
import org.geneontology.oboedit.datamodel.OperationWarning;
import org.geneontology.oboedit.datamodel.ReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.CompletesHistoryItem;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.util.FastSuperset;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;
import org.geneontology.util.ReusableProgressEvent;

public class FilteredReasonedLinkDatabase
implements ReasonedLinkDatabase,
OperationModel {
    private static final long serialVersionUID = -6966195219860702332L;
    protected ReasonedLinkDatabase linkDatabase;
    protected long lastReasoningTime = 0L;
    protected int newLinkCount = 0;
    protected Collection redundantLinks = new LinkedList();
    protected Collection newLinks = new LinkedList();
    protected Map parentMap = new LinkedHashMap();
    protected Map childMap = new LinkedHashMap();
    protected Collection progressListeners = new LinkedList();
    protected Collection actionListeners = new LinkedList();
    protected ReusableProgressEvent event = new ReusableProgressEvent((Object)this);
    protected ActionRunnable actionRunnable = new ActionRunnable();
    protected ProgressRunnable progressRunnable = new ProgressRunnable();

    public void addProgressListener(ProgressListener progressListener) {
        this.progressListeners.add(progressListener);
        if (this.linkDatabase != null) {
            this.linkDatabase.addProgressListener(progressListener);
        }
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListeners.remove(progressListener);
        if (this.linkDatabase != null) {
            this.linkDatabase.removeProgressListener(progressListener);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public void fireActionEvent(ActionEvent e) {
        Iterator it = this.actionListeners.iterator();
        while (it.hasNext()) {
            ActionListener listener = (ActionListener)it.next();
            this.actionRunnable.set(listener, e);
            SwingUtilities.invokeLater(this.actionRunnable);
        }
    }

    protected void fireProgressEvent(ProgressEvent event) {
        Iterator it = this.progressListeners.iterator();
        while (it.hasNext()) {
            ProgressListener progressListener = (ProgressListener)it.next();
            this.progressRunnable.set(progressListener, event);
            SwingUtilities.invokeLater(this.progressRunnable);
        }
    }

    public void setLinkDatabase(LinkDatabase linkDatabase) {
        if (!(linkDatabase instanceof ReasonedLinkDatabase)) {
            throw new IllegalArgumentException("FilteredReasonedLinkDatabase must operate on a ReasonedLinkDatabase");
        }
        this.linkDatabase = (ReasonedLinkDatabase)linkDatabase;
        Iterator it = this.progressListeners.iterator();
        while (it.hasNext()) {
            ProgressListener pl = (ProgressListener)it.next();
            this.linkDatabase.addProgressListener(pl);
        }
    }

    public LinkDatabase getOriginalLinkDatabase() {
        if (this.linkDatabase == null) {
            return null;
        }
        return this.linkDatabase.getLinkDatabase();
    }

    public LinkDatabase getLinkDatabase() {
        return this.linkDatabase;
    }

    public ReasonedLinkDatabase getFullDatabase() {
        return this.linkDatabase;
    }

    public Collection getObjects() {
        if (this.linkDatabase == null) {
            return Collections.EMPTY_SET;
        }
        return this.linkDatabase.getObjects();
    }

    public void setHistory(OBOSession history) {
    }

    public Collection getChildren(LinkedObject lo) {
        if (this.getOriginalLinkDatabase() == null) {
            return Collections.EMPTY_SET;
        }
        Set s = (Set)this.childMap.get(lo);
        if (s != null) {
            FastSuperset out = new FastSuperset();
            out.addSubset((Collection)s);
            out.addSubset(this.getOriginalLinkDatabase().getChildren(lo));
            return out;
        }
        return this.getOriginalLinkDatabase().getChildren(lo);
    }

    public Collection getParents(LinkedObject lo) {
        if (this.getOriginalLinkDatabase() == null) {
            return Collections.EMPTY_SET;
        }
        Set s = (Set)this.parentMap.get(lo);
        if (s != null) {
            FastSuperset out = new FastSuperset();
            out.addSubset((Collection)s);
            out.addSubset(this.getOriginalLinkDatabase().getParents(lo));
            return out;
        }
        return this.getOriginalLinkDatabase().getParents(lo);
    }

    public OperationWarning reverse(HistoryItem item) {
        this.recache(true);
        return null;
    }

    public OperationWarning apply(HistoryItem item) {
        return this.apply(item, true);
    }

    public OperationWarning reverse(HistoryItem item, boolean first) {
        if (item instanceof TermCopyHistoryItem) {
            TermCopyHistoryItem tchi = (TermCopyHistoryItem)item;
            HistoryItem.StringRelationship sr = tchi.getTerm();
            OBOSession history = Controller.getController().getSession();
            Link link = TermUtil.createRealRel(history, sr);
            this.removeLink(link);
        } else if (item instanceof DeleteLinkHistoryItem) {
            DeleteLinkHistoryItem dlhi = (DeleteLinkHistoryItem)item;
            HistoryItem.StringRelationship sr = dlhi.getRel();
            OBOSession history = Controller.getController().getSession();
            Link link = TermUtil.createRealRel(history, sr);
            this.addLink(link);
        } else if (item instanceof CompletesHistoryItem) {
            OBOSession history = Controller.getController().getSession();
            CompletesHistoryItem chi = (CompletesHistoryItem)item;
            Link link = TermUtil.getRealRel(history, chi.getRel());
            this.setCompleteness(link, chi.getOldCompletes());
        } else if (item instanceof TermMacroHistoryItem) {
            TermMacroHistoryItem tmhi = (TermMacroHistoryItem)item;
            for (int i = tmhi.getHistoryItemCount() - 1; i >= 0; --i) {
                this.reverse(tmhi.getHistoryItemAt(i));
            }
        }
        if (first) {
            this.recache(false);
        }
        return null;
    }

    public OperationWarning apply(HistoryItem item, boolean first) {
        if (item instanceof TermCopyHistoryItem) {
            TermCopyHistoryItem tchi = (TermCopyHistoryItem)item;
            HistoryItem.StringRelationship sr = tchi.getTerm();
            OBOSession history = Controller.getController().getSession();
            LinkedObject target = (LinkedObject)history.getObject(tchi.getTarget());
            Link tr = TermUtil.createRealRel(history, sr);
            OBORestrictionImpl link = new OBORestrictionImpl(tr.getChild(), target, tr.getType());
            this.addLink(link);
        } else if (item instanceof DeleteLinkHistoryItem) {
            DeleteLinkHistoryItem dlhi = (DeleteLinkHistoryItem)item;
            HistoryItem.StringRelationship sr = dlhi.getRel();
            OBOSession history = Controller.getController().getSession();
            Link link = TermUtil.createRealRel(history, sr);
            this.removeLink(link);
        } else if (item instanceof CompletesHistoryItem) {
            OBOSession history = Controller.getController().getSession();
            CompletesHistoryItem chi = (CompletesHistoryItem)item;
            Link link = TermUtil.getRealRel(history, chi.getRel());
            this.setCompleteness(link, !chi.getOldCompletes());
        } else if (item instanceof TermMacroHistoryItem) {
            TermMacroHistoryItem tmhi = (TermMacroHistoryItem)item;
            for (int i = 0; i < tmhi.getHistoryItemCount(); ++i) {
                this.apply(tmhi.getHistoryItemAt(i));
            }
        }
        if (first) {
            this.recache(false);
        }
        return null;
    }

    protected void setCompleteness(Link link, boolean completes) {
        this.removeLink(new OBORestrictionImpl(link, !completes));
        this.addLink(new OBORestrictionImpl(link, completes));
        this.recache(false);
    }

    protected void recacheObject(LinkedObject obj) {
        Link link;
        Collection lastCachedParents = (Collection)this.parentMap.get(obj);
        if (lastCachedParents != null) {
            Iterator it2 = lastCachedParents.iterator();
            while (it2.hasNext()) {
                link = (Link)it2.next();
                Collection cachedChildren = (Collection)this.childMap.get(link.getParent());
                cachedChildren.remove(link);
                if (cachedChildren.size() != 0) continue;
                this.childMap.remove(link.getParent());
            }
        }
        this.parentMap.remove(obj);
        this.newLinkCount += TermUtil.getParentCount(this.linkDatabase, obj) - TermUtil.getParentCount(this.getOriginalLinkDatabase(), obj);
        Iterator it = this.linkDatabase.getParents(obj).iterator();
        while (it.hasNext()) {
            boolean shouldBeTrimmed;
            link = (Link)it.next();
            if (this.isRedundant(link)) {
                this.redundantLinks.add(link);
            }
            if (this.getOriginalLinkDatabase().getParents(obj).contains(link) || (shouldBeTrimmed = this.shouldBeTrimmed(link))) continue;
            LinkedHashSet<Link> parents = (LinkedHashSet<Link>)this.parentMap.get(link.getChild());
            if (parents == null) {
                parents = new LinkedHashSet<Link>();
                this.parentMap.put(link.getChild(), parents);
            }
            parents.add(link);
            LinkedHashSet<Link> children = (LinkedHashSet<Link>)this.childMap.get(link.getParent());
            if (children == null) {
                children = new LinkedHashSet<Link>();
                this.childMap.put(link.getParent(), children);
            }
            children.add(link);
        }
    }

    public Collection getExplanations(Link link) {
        return this.linkDatabase.getExplanations(link);
    }

    protected static boolean hasTransitiveRedundancy(Link link, LinkDatabase linkDatabase) {
        return false;
    }

    protected boolean shouldBeTrimmed(Link link) {
        return FilteredReasonedLinkDatabase.shouldBeTrimmed(link, this.linkDatabase, this.linkDatabase);
    }

    public static boolean shouldBeTrimmed(Link link, LinkDatabase linkDatabase, ReasonedLinkDatabase reasoner) {
        return TermUtil.shouldBeTrimmed(linkDatabase, link);
    }

    public void addObject(Object o) {
        throw new UnsupportedOperationException();
    }

    public void removeObject(Object o) {
        throw new UnsupportedOperationException();
    }

    public long recache() {
        long time = this.recache(true);
        this.fireActionEvent(new ActionEvent(this, 0, "reasoned"));
        return time;
    }

    public long getLastReasoningTime() {
        return this.lastReasoningTime;
    }

    public int getNewLinkCount() {
        return this.newLinkCount;
    }

    public Collection getNewLinks() {
        return this.newLinks;
    }

    public Collection getRedundantLinks() {
        return this.redundantLinks;
    }

    public long recache(boolean recacheReasoner) {
        long time = System.currentTimeMillis();
        if (recacheReasoner) {
            this.linkDatabase.recache();
        }
        this.childMap.clear();
        this.parentMap.clear();
        this.newLinks.clear();
        this.redundantLinks.clear();
        this.newLinkCount = 0;
        Iterator<Object> it = this.linkDatabase.getObjects().iterator();
        int addedLinks = 0;
        int objCount = TermUtil.getObjectCount(this.linkDatabase);
        int i = 0;
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (io instanceof LinkedObject) {
                LinkedObject lo = (LinkedObject)io;
                this.event.setDescription("Trimming reasoner links...");
                this.event.setFastVal(100 * i / objCount);
                this.fireProgressEvent((ProgressEvent)this.event);
                this.recacheObject(lo);
            }
            ++i;
        }
        it = this.parentMap.values().iterator();
        while (it.hasNext()) {
            Collection parents = (Collection)it.next();
            this.newLinks.addAll(parents);
            addedLinks += parents.size();
        }
        this.event.setDescription("Finished reasoning; " + addedLinks + " new links created by reasoner.");
        this.event.setFastVal(100);
        this.fireProgressEvent((ProgressEvent)this.event);
        this.lastReasoningTime = System.currentTimeMillis() - time;
        return this.lastReasoningTime;
    }

    public boolean isRedundant(Link link) {
        return this.linkDatabase.isRedundant(link);
    }

    public boolean isSubclass(OBOClass a, OBOClass b) {
        return this.linkDatabase.isSubclass(a, b);
    }

    public boolean isSubProperty(OBOProperty a, OBOProperty b) {
        return this.linkDatabase.isSubProperty(a, b);
    }

    public boolean isInstance(Instance a, OBOClass b) {
        return this.linkDatabase.isInstance(a, b);
    }

    public boolean hasTransitiveRelationship(LinkedObject a, OBOProperty b, LinkedObject c) {
        return this.linkDatabase.hasTransitiveRelationship(a, b, c);
    }

    public Set getParentsOfType(LinkedObject a, OBOProperty b) {
        return this.linkDatabase.getParentsOfType(a, b);
    }

    public void addLink(Link link) {
        this.recache();
    }

    public void removeLink(Link link) {
        this.recache();
    }

    public IdentifiedObject getObject(String id) {
        return this.linkDatabase.getObject(id);
    }

    protected class ProgressRunnable
    implements Runnable {
        protected ProgressEvent e;
        protected ProgressListener listener;

        protected ProgressRunnable() {
        }

        public void set(ProgressListener listener, ProgressEvent e) {
            this.e = e;
            this.listener = listener;
        }

        public void run() {
            this.listener.progressMade(this.e);
        }
    }

    protected class ActionRunnable
    implements Runnable {
        protected ActionEvent e;
        protected ActionListener listener;

        protected ActionRunnable() {
        }

        public void set(ActionListener listener, ActionEvent e) {
            this.e = e;
            this.listener = listener;
        }

        public void run() {
            this.listener.actionPerformed(this.e);
        }
    }
}

