/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.Relationship;
import org.geneontology.oboedit.datamodel.impl.AnnotatedObjectImpl;
import org.geneontology.util.TinySet;

public abstract class LinkedAnnotatedObjectImpl
extends AnnotatedObjectImpl
implements LinkedObject {
    protected Set parents = new TinySet();
    protected Set children = new TinySet();
    protected boolean isRoot = false;
    protected boolean rootHint = false;

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public boolean rootHint() {
        return this.rootHint;
    }

    public Set getChildren() {
        return this.children;
    }

    public void addChild(Relationship tr) {
        this.atomicAddChild(tr);
        if (tr instanceof Link) {
            ((Link)tr).getChild().atomicAddParent(tr);
        }
    }

    public void removeChild(Relationship tr) {
        this.atomicRemoveChild(tr);
        if (tr instanceof Link) {
            ((Link)tr).getChild().atomicRemoveParent(tr);
        }
    }

    public void addParent(Relationship tr) {
        this.atomicAddParent(tr);
        if (tr instanceof Link) {
            ((Link)tr).getParent().atomicAddChild(tr);
        }
    }

    public void removeParent(Relationship tr) {
        this.atomicRemoveParent(tr);
        if (tr instanceof Link) {
            ((Link)tr).getParent().atomicRemoveChild(tr);
        }
    }

    public void atomicAddChild(Relationship tr) {
        this.children.add(tr);
    }

    public void atomicRemoveChild(Relationship tr) {
        this.children.remove(tr);
    }

    public void atomicAddParent(Relationship tr) {
        this.parents.add(tr);
    }

    public void atomicRemoveParent(Relationship tr) {
        this.parents.remove(tr);
    }

    public Set getParents() {
        return this.parents;
    }

    public Object clone() {
        try {
            Link tr;
            LinkedAnnotatedObjectImpl out = (LinkedAnnotatedObjectImpl)super.clone();
            out.children = new LinkedHashSet();
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                tr = (Link)it.next();
                out.atomicAddChild((Link)tr.clone());
            }
            out.parents = new LinkedHashSet();
            it = this.parents.iterator();
            while (it.hasNext()) {
                tr = (Link)it.next();
                out.atomicAddParent((Link)tr.clone());
            }
            return out;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

