/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.geneontology.oboedit.datamodel.AnnotatedObject;
import org.geneontology.oboedit.datamodel.DataAdapterMetaData;
import org.geneontology.oboedit.datamodel.Datatype;
import org.geneontology.oboedit.datamodel.DefaultHistoryList;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.IDProfile;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Instance;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.ObjectFactory;
import org.geneontology.oboedit.datamodel.ObsoletableObject;
import org.geneontology.oboedit.datamodel.PropertyValue;
import org.geneontology.oboedit.datamodel.SynonymCategory;
import org.geneontology.oboedit.datamodel.TermCategory;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.Type;
import org.geneontology.oboedit.datamodel.UnknownStanza;
import org.geneontology.oboedit.datamodel.impl.AnnotatedObjectImpl;
import org.geneontology.oboedit.datamodel.impl.DefaultLinkDatabase;
import org.geneontology.oboedit.datamodel.impl.DefaultObjectFactory;
import org.geneontology.oboedit.datamodel.impl.MergedLinkDatabase;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.util.BooleanFilter;
import org.geneontology.util.HashSubsetable;
import org.geneontology.util.Subsetable;
import org.geneontology.util.VectorFilter;

public class OBOSessionImpl
implements OBOSession {
    private static final long serialVersionUID = 6487885507983696952L;
    public static final Object ROOT = "ROOT";
    public static final Object OBSOLETE = "OBSOLETE";
    public static final Object TYPES = "TYPES";
    public static final Object INSTANCES = "INSTANCES";
    protected HistoryList currentHistory;
    protected List archivedHistories;
    protected List redoHistoryItems = new Vector();
    protected ObjectFactory objectFactory;
    protected MergedLinkDatabase linkDatabase = new MergedLinkDatabase();
    protected List idRules = new LinkedList();
    protected Map impliedRels = null;
    protected Subsetable objects;
    protected Set categories;
    protected Set synonymCategories;
    protected transient Set relationshipTypes;
    protected transient Set terms;
    protected transient Set instances;
    protected Set namespaces;
    protected transient Set roots;
    protected transient Set typeRoots;
    protected Map idHash;
    protected transient Set obsoleteObjects;
    protected boolean needsSave = false;
    protected Set propertyValues;
    protected Set unknownStanzas;
    protected boolean isActive = false;
    protected String title = null;
    protected Namespace defaultNamespace;
    protected IDProfile profile;
    protected boolean diskCacheHistory = false;
    protected String loadRemark;
    private Set obsoleteTerms;
    protected DataAdapterMetaData metaData;
    protected static TermUtil.DescendantThread descendantThread = new TermUtil.DescendantThread();

    public void setIDProfile(IDProfile profile) {
        this.profile = profile;
    }

    public IDProfile getIDProfile() {
        return this.profile;
    }

    public Map getImpliedRels() {
        return this.impliedRels;
    }

    public List getArchivedHistories() {
        return this.archivedHistories;
    }

    public String getLoadRemark() {
        return this.loadRemark;
    }

    public void setLoadRemark(String loadRemark) {
        this.loadRemark = loadRemark;
    }

    public void setDefaultNamespace(Namespace ns) {
        this.defaultNamespace = ns;
    }

    public Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setNeedsSave(boolean needsSave) {
        this.needsSave = needsSave;
    }

    public List getRedoHistoryItems() {
        return this.redoHistoryItems;
    }

    public boolean needsSave() {
        return this.needsSave;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void addNamespace(Namespace ns) {
        if (ns == null) {
            new Exception("Null namespace added").printStackTrace();
        }
        this.namespaces.add(ns);
    }

    public Namespace getNamespace(String id) {
        if (id == null) {
            return null;
        }
        Iterator it = this.namespaces.iterator();
        while (it.hasNext()) {
            Namespace ns = (Namespace)it.next();
            if (!ns.getID().equals(id)) continue;
            return ns;
        }
        return null;
    }

    public void setHistoryList(HistoryList hl) {
        this.currentHistory = hl;
    }

    public void removeNamespace(Namespace ns) {
        this.namespaces.remove(ns);
    }

    public Set getNamespaces() {
        return this.namespaces;
    }

    public LinkDatabase getLinkDatabase() {
        return this.linkDatabase;
    }

    public OBOSessionImpl() {
        this(new DefaultObjectFactory());
    }

    public OBOSessionImpl(ObjectFactory factory) {
        this(new HashSet());
        this.objectFactory = factory;
    }

    public OBOSessionImpl(OBOClass root) {
        this(TermUtil.getDescendants(root, true));
    }

    public static OBOSession createHistoryFromRoots(Set roots) {
        HashSet<OBOClass> terms = new HashSet<OBOClass>();
        Iterator it = roots.iterator();
        while (it.hasNext()) {
            OBOClass root = (OBOClass)it.next();
            terms.add(root);
            Iterator it2 = TermUtil.getDescendants(root).iterator();
            while (it2.hasNext()) {
                terms.add((OBOClass)it2.next());
            }
        }
        return new OBOSessionImpl(terms);
    }

    protected void populateSubsets() {
        TypeFilter termFilter = new TypeFilter(OBOClass.OBO_CLASS);
        TypeFilter unknownFilter = new TypeFilter(OBOClass.OBO_UNKNOWN);
        BooleanFilter termOrUnknownFilter = new BooleanFilter(2);
        termOrUnknownFilter.addFilter((VectorFilter)termFilter);
        termOrUnknownFilter.addFilter((VectorFilter)unknownFilter);
        TypeFilter propertyFilter = new TypeFilter(OBOClass.OBO_PROPERTY);
        RootFilter rootFilter = new RootFilter();
        BooleanFilter termRootFilter = new BooleanFilter(1);
        termRootFilter.addFilter((VectorFilter)rootFilter);
        termRootFilter.addFilter((VectorFilter)termOrUnknownFilter);
        BooleanFilter typeRootFilter = new BooleanFilter(1);
        typeRootFilter.addFilter((VectorFilter)rootFilter);
        typeRootFilter.addFilter((VectorFilter)propertyFilter);
        this.roots = this.objects.getUncachedSubset((VectorFilter)termRootFilter);
        this.typeRoots = this.objects.getSubset((VectorFilter)typeRootFilter);
        this.instances = this.objects.getSubset((VectorFilter)new InstanceFilter());
        this.terms = this.objects.getSubset((VectorFilter)termFilter);
        this.obsoleteObjects = this.objects.getSubset((VectorFilter)new ObsoleteFilter(true));
        this.obsoleteTerms = this.objects.getSubset((VectorFilter)new ObsoleteFilter(false));
        this.relationshipTypes = this.objects.getSubset((VectorFilter)propertyFilter);
    }

    public OBOSessionImpl(Set terms) {
        int i;
        this.currentHistory = new DefaultHistoryList();
        this.objects = new HashSubsetable();
        this.populateSubsets();
        this.objects.addAll((Collection)terms);
        this.categories = new HashSet();
        this.synonymCategories = new HashSet();
        this.namespaces = new HashSet();
        this.propertyValues = new HashSet();
        this.unknownStanzas = new HashSet();
        this.idHash = new HashMap();
        this.archivedHistories = new Vector();
        for (i = 0; i < OBOClass.BUILTIN_CLASSES.length; ++i) {
            this.addObject((OBOClass)OBOClass.BUILTIN_CLASSES[i].clone());
        }
        for (i = 0; i < OBOProperty.BUILTIN_TYPES.length; ++i) {
            this.addObject((OBOProperty)OBOProperty.BUILTIN_TYPES[i].clone());
        }
        for (i = 0; i < Datatype.DATATYPES.length; ++i) {
            this.addObject(Datatype.DATATYPES[i]);
        }
        this.linkDatabase.addDatabase(new DefaultLinkDatabase(this));
    }

    public void changeID(AnnotatedObjectImpl object, String newID) {
        Link link;
        Iterator it;
        LinkedObject lobj;
        this.removeObject(object);
        LinkedList parents = null;
        LinkedList children = null;
        if (object instanceof LinkedObject) {
            lobj = (LinkedObject)((Object)object);
            parents = new LinkedList();
            children = new LinkedList();
            parents.addAll(lobj.getParents());
            children.addAll(lobj.getChildren());
            it = parents.iterator();
            while (it.hasNext()) {
                link = (Link)it.next();
                lobj.removeParent(link);
            }
            it = children.iterator();
            while (it.hasNext()) {
                link = (Link)it.next();
                lobj.removeChild(link);
            }
        }
        object.id = newID;
        this.addObject(object);
        if (object instanceof LinkedObject) {
            lobj = (LinkedObject)((Object)object);
            it = parents.iterator();
            while (it.hasNext()) {
                link = (Link)it.next();
                lobj.addParent(link);
            }
            it = children.iterator();
            while (it.hasNext()) {
                link = (Link)it.next();
                lobj.addChild(link);
            }
        }
    }

    public void addInstance(Instance instance) {
        this.addObject(instance);
    }

    public void removeInstance(Instance instance) {
        this.removeObject(instance);
    }

    public Set getInstances() {
        return this.instances;
    }

    public HistoryList getCurrentHistory() {
        return this.currentHistory;
    }

    public void addPropertyValue(PropertyValue pv) {
        this.propertyValues.add(pv);
    }

    public Set getPropertyValues() {
        return this.propertyValues;
    }

    public void addUnknownStanza(UnknownStanza us) {
        this.unknownStanzas.add(us);
    }

    public Set getUnknownStanzas() {
        return this.unknownStanzas;
    }

    public OBOProperty getISA() {
        Iterator it = this.relationshipTypes.iterator();
        while (it.hasNext()) {
            OBOProperty trt = (OBOProperty)it.next();
            if (!trt.equals(OBOProperty.IS_A)) continue;
            return trt;
        }
        return null;
    }

    public AnnotatedObject getAnnotatedObject(String id) {
        return (AnnotatedObject)this.idHash.get(id);
    }

    public IdentifiedObject getObject(String id) {
        return (IdentifiedObject)this.idHash.get(id);
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public Type getType(String id) {
        Object o = this.idHash.get(id);
        if (!(o instanceof Type)) {
            return null;
        }
        return (Type)o;
    }

    public OBOClass getTerm(String id) {
        Object o = this.idHash.get(id);
        if (!(o instanceof Type)) {
            return null;
        }
        return (OBOClass)o;
    }

    public boolean containsObject(String id) {
        return this.idHash.containsKey(id);
    }

    public void destroy(IdentifiedObject term) {
        int size = this.objects.size();
        this.objects.remove((Object)term);
        System.err.println("removed " + term + "(" + term.getID() + ") from objects; " + (size == this.objects.size() ? "failed" : "succeeded"));
        this.idHash.remove(term.getID());
    }

    public void undestroy(IdentifiedObject term) {
        this.objects.add((Object)term);
        this.idHash.put(term.getID(), term);
    }

    public void addObsoleteObject(ObsoletableObject term) {
        this.objects.markForRecategorize((Object)term);
        term.setObsolete(true);
        this.objects.recategorize((Object)term);
    }

    public void removeObsoleteObject(ObsoletableObject term) {
        this.objects.markForRecategorize((Object)term);
        term.setObsolete(false);
        this.objects.recategorize((Object)term);
    }

    public void removeObsoleteTerm(ObsoletableObject term) {
        this.removeObsoleteObject(term);
    }

    public void addObsoleteTerm(ObsoletableObject term) {
        this.addObsoleteObject(term);
    }

    public Set getObsoleteTerms() {
        return this.obsoleteTerms;
    }

    public Set getObsoleteObjects() {
        return this.obsoleteObjects;
    }

    public void addObject(IdentifiedObject obj) {
        this.objects.add((Object)obj);
        this.idHash.put(obj.getID(), obj);
    }

    public void removeObject(IdentifiedObject obj) {
        this.objects.remove((Object)obj);
        this.idHash.remove(obj.getID());
    }

    public void addTerm(OBOClass root) {
        this.addObject(root);
    }

    public void removeTerm(OBOClass root) {
        this.removeObject(root);
    }

    public Set getCategories() {
        return this.categories;
    }

    public void addCategory(TermCategory cat) {
        this.categories.add(cat);
    }

    public void removeCategory(TermCategory cat) {
        this.categories.remove(cat);
    }

    public TermCategory getCategory(String name) {
        Iterator it = this.categories.iterator();
        while (it.hasNext()) {
            TermCategory cat = (TermCategory)it.next();
            if (!cat.getName().equals(name)) continue;
            return cat;
        }
        return null;
    }

    public boolean hasCategory(TermCategory cat) {
        return this.categories.contains(cat);
    }

    public Set getSynonymCategories() {
        return this.synonymCategories;
    }

    public void addSynonymCategory(SynonymCategory cat) {
        this.synonymCategories.add(cat);
    }

    public void removeSynonymCategory(SynonymCategory cat) {
        this.synonymCategories.remove(cat);
    }

    public SynonymCategory getSynonymCategory(String id) {
        Iterator it = this.synonymCategories.iterator();
        while (it.hasNext()) {
            SynonymCategory cat = (SynonymCategory)it.next();
            if (!cat.getID().equals(id)) continue;
            return cat;
        }
        return null;
    }

    public boolean hasSynonymCategory(SynonymCategory cat) {
        return this.synonymCategories.contains(cat);
    }

    public Set getRoots() {
        return this.roots;
    }

    public void markRoots() {
    }

    public Set getRelationshipTypeRoots() {
        return this.typeRoots;
    }

    public Set getRelationshipTypes() {
        return this.relationshipTypes;
    }

    protected void indexObject(IdentifiedObject o) {
        this.idHash.put(o.getID(), o);
    }

    public void addRelationshipType(OBOProperty trt) {
        this.addObject(trt);
    }

    public void removeRelationshipType(OBOProperty trt) {
        this.addObject(trt);
    }

    public boolean isModified() {
        return this.currentHistory.size() != 0;
    }

    public void applyItem(HistoryItem item) {
        this.currentHistory.addItem(item);
    }

    public Set getTerms() {
        return this.terms;
    }

    public Map getAllTermsHash() {
        HashMap<String, OBOClass> out = new HashMap<String, OBOClass>();
        Iterator it = this.terms.iterator();
        while (it.hasNext()) {
            OBOClass term = (OBOClass)it.next();
            if (term.getID() == null) continue;
            out.put(term.getID(), term);
        }
        return out;
    }

    public Set getObjects() {
        return this.objects;
    }

    public Collection getAnnotatedObjects() {
        return this.objects;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        LinkedList tempList = new LinkedList();
        Iterator it = this.getObjects().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)o;
            tempList.addAll(lo.getParents());
            Iterator it2 = lo.getParents().iterator();
            while (it2.hasNext()) {
                Object o2 = it2.next();
                if (!(o2 instanceof OBORestrictionImpl)) continue;
                OBORestrictionImpl or = (OBORestrictionImpl)o2;
                or.parent = (LinkedObject)this.getObject(or.parent_id);
                or.child = (LinkedObject)this.getObject(or.child_id);
                or.type = (OBOProperty)this.getObject(or.type_id);
            }
            lo.getChildren().clear();
            lo.getParents().clear();
        }
        it = tempList.iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            link.getChild().getParents().add(link);
            link.getParent().getChildren().add(link);
        }
        this.populateSubsets();
    }

    public DataAdapterMetaData getAdapterMetaData() {
        return this.metaData;
    }

    public void setAdapterMetaData(DataAdapterMetaData metaData) {
        this.metaData = metaData;
    }

    protected class ObsoleteFilter
    implements VectorFilter {
        private static final long serialVersionUID = 8492125751822771783L;
        protected boolean allowNonTerms = true;

        public ObsoleteFilter(boolean allowNonTerms) {
            this.allowNonTerms = allowNonTerms;
        }

        public boolean satisfies(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ObsoletableObject)) {
                return false;
            }
            if (!this.allowNonTerms && !(o instanceof OBOClass)) {
                return false;
            }
            return ((ObsoletableObject)o).isObsolete();
        }

        public String toString() {
            return "Obsolete filter";
        }
    }

    protected class RootFilter
    implements VectorFilter {
        private static final long serialVersionUID = 296023685847159173L;

        protected RootFilter() {
        }

        public boolean satisfies(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof LinkedObject)) {
                return false;
            }
            return ((LinkedObject)o).isRoot();
        }
    }

    protected class InstanceFilter
    implements VectorFilter {
        private static final long serialVersionUID = -6033560581609475894L;

        protected InstanceFilter() {
        }

        public boolean satisfies(Object o) {
            if (o == null) {
                return false;
            }
            return o instanceof Instance && !TermUtil.isObsolete((Instance)o);
        }
    }

    protected class TypeFilter
    implements VectorFilter {
        private static final long serialVersionUID = 5049863144508164164L;
        Type type;

        public TypeFilter(Type type) {
            this.type = type;
        }

        public boolean satisfies(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof IdentifiedObject)) {
                return false;
            }
            IdentifiedObject io = (IdentifiedObject)o;
            if (o instanceof ObsoletableObject && ((ObsoletableObject)o).isObsolete()) {
                return false;
            }
            if (io.getType() == null) {
                return false;
            }
            return io.getType().equals(this.type);
        }

        public String toString() {
            return this.type + " filter";
        }
    }
}

