/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JViewport;

public class BorderedViewport
extends JViewport {
    private static final long serialVersionUID = -7531342876951601627L;
    protected int borderSize = 5;
    protected Color borderColor = Color.blue;
    protected boolean paintBorder = false;

    public void setPaintBorder(boolean paintBorder) {
        this.paintBorder = paintBorder;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.paintBorder) {
            for (int i = this.borderSize; i >= 0; --i) {
                Color c = new Color(this.borderColor.getRed(), this.borderColor.getGreen(), this.borderColor.getBlue(), (this.borderSize + 1 - i) * 128 / (this.borderSize + 1));
                this.paintBorder(g, c, i);
            }
        }
    }

    protected void paintBorder(Graphics g, Color c, int size) {
        g.setColor(c);
        int H = (int)g.getClipBounds().getHeight();
        int W = (int)g.getClipBounds().getWidth();
        g.fillRect(0, 0, size, H);
        g.fillRect(size, 0, W - 2 * size, size);
        g.fillRect(W - size, 0, size, H);
        g.fillRect(size, H - size, W - 2 * size, size);
    }
}

