/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.geneontology.oboedit.datamodel.CategorizedObject;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.TermCategory;
import org.geneontology.oboedit.datamodel.history.CategoryChangeHistoryItem;
import org.geneontology.oboedit.gui.AbstractTextEditComponent;
import org.geneontology.oboedit.gui.Controller;

public class CategoryEditorComponent
extends AbstractTextEditComponent {
    private static final long serialVersionUID = 1L;
    protected Comparator catComparator = new Comparator(){

        public int compare(Object a, Object b) {
            TermCategory tca = (TermCategory)a;
            TermCategory tcb = (TermCategory)b;
            return tca.toString().compareTo(tcb.toString());
        }
    };
    protected JTable categoryTable = new JTable();
    protected JPanel tablePanel = new JPanel();
    protected CategoryTableModel categoryTableModel = new CategoryTableModel();
    protected JScrollPane categoryScroller;
    static /* synthetic */ Class class$java$lang$Boolean;

    public Component resolveName(String id, Properties props, String xml) {
        if (id.equals("table")) {
            return this.categoryScroller;
        }
        return new JButton(id);
    }

    public CategoryEditorComponent() {
        this.categoryTable.setModel(this.categoryTableModel);
        this.categoryTable.setDefaultRenderer(TermCategory.class, new DefaultTableCellRenderer());
        this.categoryTable.setTableHeader(null);
        this.categoryTable.setColumnSelectionAllowed(false);
        this.categoryTable.setRowSelectionAllowed(false);
        this.categoryTable.setOpaque(false);
        this.tablePanel.setLayout(new GridLayout(1, 1));
        this.tablePanel.add(this.categoryTable);
        this.categoryScroller = new JScrollPane(this.tablePanel, 20, 31);
    }

    protected boolean useSubLayout() {
        return true;
    }

    protected String getDefaultLayout() {
        return "<component id='table' titleborder='Categories'/>";
    }

    protected void loadGUI() {
        this.categoryTableModel.reload();
    }

    protected String getWarningLabel() {
        return "";
    }

    protected void initializeGUI() {
        Font font = Controller.getController().getDefaultFont();
        this.categoryTable.setFont(font);
        this.categoryScroller.setOpaque(true);
        this.categoryScroller.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        this.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        this.tablePanel.setBackground(Controller.getController().getPreferences().getBackgroundColor());
    }

    public List getWarnings() {
        return Collections.EMPTY_LIST;
    }

    public String getID() {
        return "CATEGORY_EDITOR";
    }

    public void populateFields(IdentifiedObject io) {
        IdentifiedObject term = io;
        if (term instanceof CategorizedObject) {
            for (int i = 0; i < this.categoryTableModel.getRowCount(); ++i) {
                TermCategory cat = (TermCategory)this.categoryTableModel.getValueAt(i, 0);
                boolean selected = (Boolean)this.categoryTableModel.getValueAt(i, 1);
                if (selected) {
                    ((CategorizedObject)term).addCategory(cat);
                    continue;
                }
                ((CategorizedObject)term).removeCategory(cat);
            }
        }
    }

    public List getChanges() {
        if (this.currentObject != null) {
            LinkedList<CategoryChangeHistoryItem> out = new LinkedList<CategoryChangeHistoryItem>();
            if (this.currentObject instanceof CategorizedObject) {
                for (int i = 0; i < this.categoryTableModel.getRowCount(); ++i) {
                    TermCategory cat = (TermCategory)this.categoryTableModel.getValueAt(i, 0);
                    boolean selected = (Boolean)this.categoryTableModel.getValueAt(i, 1);
                    if (selected == ((CategorizedObject)this.currentObject).getCategories().contains(cat)) continue;
                    CategoryChangeHistoryItem item = new CategoryChangeHistoryItem(cat.getName(), !selected, this.currentObject.getID());
                    out.add(item);
                }
            }
            return out;
        }
        return Collections.EMPTY_LIST;
    }

    protected class CategoryTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        protected Vector catList = new Vector();
        protected Vector valList = new Vector();

        public void reload() {
            this.catList.clear();
            this.valList.clear();
            this.catList.addAll(Controller.getController().getSession().getCategories());
            Collections.sort(this.catList, CategoryEditorComponent.this.catComparator);
            Iterator it = this.catList.iterator();
            while (it.hasNext()) {
                TermCategory cat = (TermCategory)it.next();
                if (CategoryEditorComponent.this.currentObject == null || !(CategoryEditorComponent.this.currentObject instanceof CategorizedObject)) continue;
                this.valList.add(new Boolean(((CategorizedObject)CategoryEditorComponent.this.currentObject).getCategories().contains(cat)));
            }
            this.fireTableStructureChanged();
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return class$org$geneontology$oboedit$datamodel$TermCategory == null ? (class$org$geneontology$oboedit$datamodel$TermCategory = CategoryEditorComponent.class$("org.geneontology.oboedit.datamodel.TermCategory")) : class$org$geneontology$oboedit$datamodel$TermCategory;
            }
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = CategoryEditorComponent.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Category";
            }
            return "Active?";
        }

        public int getRowCount() {
            return this.valList.size();
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.catList.get(row);
            }
            return this.valList.get(row);
        }

        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        public void setValueAt(Object val, int row, int col) {
            if (col == 0) {
                return;
            }
            this.valList.set(row, val);
        }
    }
}

