/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.verify.Check;
import org.geneontology.oboedit.verify.CheckWarning;
import org.geneontology.oboedit.verify.VerificationEngine;
import org.geneontology.swing.SwingUtil;

public class CheckWarningComponent
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    protected List warnings = new LinkedList();
    protected boolean showFatal = true;
    protected boolean showWarnings = true;
    protected boolean separateWarningErrorSections = true;
    protected boolean showTermNames = true;
    protected String header;
    protected String footer;
    protected boolean allowRerun = false;
    protected OBOSession session;
    protected IdentifiedObject currentObject;
    protected byte condition;
    protected boolean hyperlinksEnabled = false;
    protected static URL errorIconURL = Preferences.getLibraryIconURL("error.gif");
    protected static URL warningIconURL = Preferences.getLibraryIconURL("warning.gif");
    protected static URL quickFixIconURL = Preferences.getLibraryIconURL("quickfix.gif");
    protected HyperlinkListener hyperlinkListener = new HyperlinkListener(){

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                if (e.getURL().getPath().startsWith("__warningindex")) {
                    String path = e.getURL().getPath();
                    int index = Integer.parseInt(path.substring(14, path.length()));
                    CheckWarning warning = (CheckWarning)CheckWarningComponent.this.warnings.get(index);
                    JPopupMenu menu = new JPopupMenu();
                    Iterator it = warning.getFixes().iterator();
                    while (it.hasNext()) {
                        JMenuItem item = menu.add(new ActionWrapper((Action)it.next()));
                        item.setFont(Preferences.getPreferences().getFont());
                    }
                    try {
                        Rectangle pos = CheckWarningComponent.this.modelToView(e.getSourceElement().getStartOffset());
                        menu.show(CheckWarningComponent.this, (int)pos.getX(), (int)pos.getY());
                    }
                    catch (BadLocationException e1) {}
                } else {
                    CheckWarningComponent.this.selectTerm(e.getURL(), Controller.getController().getSession());
                }
            }
        }
    };
    protected boolean locked = false;
    public static final int YES_NO_OPTION = 1;
    public static final int OK_OPTION = 2;
    public static final int NO_VALUE = 0;
    public static final int YES_VALUE = 1;
    protected Comparator warningSorter = new Comparator(){

        public int compare(Object a, Object b) {
            CheckWarning ca = (CheckWarning)a;
            CheckWarning cb = (CheckWarning)b;
            if (ca.isFatal() && cb.isFatal()) {
                return 0;
            }
            if (ca.isFatal()) {
                return -1;
            }
            return 1;
        }
    };
    protected Comparator termSorter = new Comparator(){

        public int compare(Object a, Object b) {
            IdentifiedObject ioa = (IdentifiedObject)a;
            IdentifiedObject iob = (IdentifiedObject)b;
            if (ioa == null && iob == null) {
                return 0;
            }
            if (ioa == null) {
                return -1;
            }
            if (iob == null) {
                return 1;
            }
            return ioa.getName().compareToIgnoreCase(iob.getName());
        }
    };

    public CheckWarningComponent() {
        super("text/html", "<html></html>");
        this.setFont(Controller.getController().getPreferences().getFont());
        this.setOpaque(false);
        this.setEditable(false);
        this.setBackground(Controller.getController().getPreferences().getBackgroundColor());
    }

    public void setRerunInfo(OBOSession session, IdentifiedObject currentObject, byte condition) {
        if (this.locked) {
            return;
        }
        this.allowRerun = true;
        this.session = session;
        this.currentObject = currentObject;
        this.condition = condition;
    }

    public void redoCheck() {
        Thread thread = new Thread(){

            public void run() {
                Controller.getController().getVerificationEngine().runChecks(CheckWarningComponent.this.session, CheckWarningComponent.this.currentObject, CheckWarningComponent.this.condition);
            }
        };
        thread.start();
    }

    public void redoCheck(final Check source) {
        Thread thread = new Thread(){

            public void run() {
                CheckWarningComponent.this.locked = true;
                LinkedList oldWarnings = new LinkedList(CheckWarningComponent.this.warnings);
                Iterator it = CheckWarningComponent.this.warnings.iterator();
                while (it.hasNext()) {
                    CheckWarning warning = (CheckWarning)it.next();
                    if (!warning.getSource().equals(source)) continue;
                    it.remove();
                }
                Collection newWarnings = Controller.getController().getVerificationEngine().runCheck(source, CheckWarningComponent.this.session, CheckWarningComponent.this.currentObject, CheckWarningComponent.this.condition);
                CheckWarningComponent.this.warnings.addAll(newWarnings);
                System.err.println("oldWarnings = " + oldWarnings.size());
                System.err.println("warnings = " + CheckWarningComponent.this.warnings.size());
                System.err.println("newWarnings = " + newWarnings.size());
                Runnable r = new Runnable(){

                    public void run() {
                        CheckWarningComponent.this.updateGUI();
                        (this).CheckWarningComponent.this.locked = false;
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        };
        thread.start();
    }

    public void setHyperlinksEnabled(boolean enabled) {
        if (this.hyperlinksEnabled != enabled) {
            this.hyperlinksEnabled = enabled;
            if (enabled) {
                this.addHyperlinkListener(this.hyperlinkListener);
            } else {
                this.removeHyperlinkListener(this.hyperlinkListener);
            }
        }
    }

    public void setWarnings(Collection warnings) {
        this.setWarnings(warnings, null, null, true, true, true);
    }

    public void setWarnings(Collection warnings, String header, String footer, boolean showFatal, boolean showWarnings, boolean showTermNames) {
        if (this.locked) {
            return;
        }
        this.warnings = new ArrayList(warnings);
        this.header = header;
        this.footer = footer;
        this.showFatal = showFatal;
        this.showWarnings = showWarnings;
        this.showTermNames = showTermNames;
        this.updateGUI();
    }

    protected int showDialog(JFrame parent, String title, int type) {
        final JDialog dialog = new JDialog(parent, title, true);
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        mainPanel.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        mainPanel.add((Component)new JScrollPane(this, 20, 31), "Center");
        mainPanel.add((Component)buttonPanel, "South");
        dialog.setContentPane(mainPanel);
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        final int[] output = new int[1];
        if (type == 1) {
            output[0] = 0;
        } else if (type == 2) {
            output[0] = 1;
        }
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                output[0] = 1;
                dialog.dispose();
            }
        };
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                output[0] = 0;
                dialog.dispose();
            }
        };
        JButton yesButton = new JButton(type == 2 ? "Ok" : "Proceed");
        JButton noButton = new JButton("Cancel");
        Font font = Controller.getController().getPreferences().getFont();
        Color buttonColor = Controller.getController().getPreferences().getButtonColor();
        yesButton.setBackground(buttonColor);
        noButton.setBackground(buttonColor);
        yesButton.setFont(font);
        noButton.setFont(font);
        yesButton.addActionListener(okListener);
        noButton.addActionListener(cancelListener);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(yesButton);
        if (type == 1) {
            buttonPanel.add(Box.createHorizontalStrut(10));
            buttonPanel.add(noButton);
        }
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        dialog.pack();
        SwingUtil.center((Window)dialog);
        dialog.show();
        return output[0];
    }

    public void setShowFatal(boolean showFatal) {
        this.showFatal = showFatal;
        this.updateGUI();
    }

    public void setShowWarnings(boolean showWarnings) {
        this.showWarnings = showWarnings;
        this.updateGUI();
    }

    public void setShowTermNames(boolean showTermNames) {
        this.showTermNames = showTermNames;
        this.updateGUI();
    }

    protected void generateHTMLList(StringBuffer html, Collection c, IdentifiedObject io, boolean showTermNames, boolean showWarnings, boolean showErrors, boolean deleteShownWarnings) {
        int errorCount = 0;
        int warningCount = 0;
        if (showWarnings && showErrors) {
            errorCount = VerificationEngine.countFatal(c);
            warningCount = c.size() - errorCount;
        } else if (showErrors) {
            errorCount = VerificationEngine.countFatal(c);
        } else if (showWarnings) {
            warningCount = c.size() - VerificationEngine.countFatal(c);
        }
        if (errorCount == 0 && warningCount == 0) {
            return;
        }
        if (showTermNames) {
            StringBuffer warningMessage = new StringBuffer();
            if (io == null) {
                warningMessage.append("The entire ontology generated ");
            } else {
                warningMessage.append("<a href='file:" + io.getID() + "'>" + io.getName() + " (" + io.getID() + ")</a> generated ");
            }
            if (errorCount > 0) {
                warningMessage.append(errorCount + " error" + (errorCount != 1 ? "s" : ""));
            }
            if (errorCount > 0 && warningCount > 0) {
                warningMessage.append(" and ");
            }
            if (warningCount > 0) {
                warningMessage.append(warningCount + " warning" + (warningCount != 1 ? "s" : ""));
            }
            warningMessage.append(".");
            html.append("<li>\n" + warningMessage);
            html.append("<ul style='list-style-type:none;'>\n");
        }
        Iterator it2 = c.iterator();
        while (it2.hasNext()) {
            CheckWarning warning = (CheckWarning)it2.next();
            if (!showWarnings && !warning.isFatal() || !showErrors && warning.isFatal()) continue;
            if (deleteShownWarnings) {
                it2.remove();
            }
            URL iconURL = warning.isFatal() ? errorIconURL : warningIconURL;
            html.append("<li>\n");
            html.append("<img src=\"" + iconURL + "\"> ");
            html.append("&nbsp;");
            html.append(warning.getMessage());
            if (warning.getFixes().size() <= 0 || !this.allowRerun) continue;
            html.append(" <a href='file:__warningindex" + this.warnings.indexOf(warning) + "'><img src=\"" + quickFixIconURL + "\" border=\"0\" alt=\"Quick fix\"></a>\n");
        }
        if (showTermNames) {
            html.append("</ul>\n");
        }
    }

    public static String removeHyperlinks(String s) {
        Pattern p = Pattern.compile("<a .*>(.*)</a>");
        Matcher m = p.matcher(s);
        return m.replaceAll("$1");
    }

    public void selectTerm(URL url, OBOSession session) {
        String id = url.getPath();
        IdentifiedObject t = session.getObject(id);
        Vector<IdentifiedObject> terms = new Vector<IdentifiedObject>();
        terms.add(t);
        Controller.getController().select(terms);
    }

    protected void initComponent(Map warningMap, int globalWarningCount, int globalErrorCount) {
        StringBuffer html = new StringBuffer();
        if (globalWarningCount > 0 || globalErrorCount > 0) {
            Collection c;
            IdentifiedObject io;
            Iterator it;
            if (this.header != null) {
                html.append(this.header);
            }
            ArrayList termList = new ArrayList(warningMap.keySet());
            Collections.sort(termList, this.termSorter);
            if (this.separateWarningErrorSections) {
                if (globalErrorCount > 0) {
                    html.append("<p style='color: red;'>" + globalErrorCount + " fatal error" + (globalErrorCount != 1 ? "s" : "") + ":</p>\n");
                    html.append("<ul style='list-style-type:none;'>");
                    it = termList.iterator();
                    while (it.hasNext()) {
                        io = (IdentifiedObject)it.next();
                        c = (Collection)warningMap.get(io);
                        this.generateHTMLList(html, c, io, this.showTermNames || warningMap.size() > 1, false, true, true);
                    }
                    html.append("</ul>");
                    if (globalWarningCount > 0) {
                        html.append("<hr>");
                    }
                }
                if (globalWarningCount > 0) {
                    html.append("<p>" + globalWarningCount + " non-critical warning" + (globalWarningCount != 1 ? "s" : "") + ":</p>\n");
                }
            }
            html.append("<ul style='list-style-type:none;'>");
            it = termList.iterator();
            while (it.hasNext()) {
                io = (IdentifiedObject)it.next();
                c = (Collection)warningMap.get(io);
                this.generateHTMLList(html, c, io, this.showTermNames || warningMap.size() > 1, true, true, false);
            }
            html.append("</ul>");
            if (this.footer != null) {
                html.append(this.footer);
            }
        } else {
            html.append("No problems found.");
        }
        String fontStyle = SwingUtil.getHTMLFontStyle((Font)Controller.getController().getPreferences().getFont());
        String out = "<html><head><style type='text/css'>\nli {" + fontStyle + "}\np {font-weight: bold;\n" + fontStyle + "}</style></head><body bgcolor='#" + SwingUtil.getHTMLCode((Color)Controller.getController().getPreferences().getBackgroundColor()) + "'>" + html.toString() + "</body></html>";
        if (!this.hyperlinksEnabled) {
            out = CheckWarningComponent.removeHyperlinks(out);
        }
        System.out.println(out);
        this.setText(out);
        this.setCaretPosition(0);
    }

    protected void updateGUI() {
        LinkedHashMap warningMap = new LinkedHashMap();
        int warningCount = 0;
        int fatalCount = 0;
        Iterator it = this.warnings.iterator();
        System.err.println("updategui warnings = " + this.warnings.size());
        while (it.hasNext()) {
            int pos;
            ArrayList<CheckWarning> c;
            CheckWarning warning = (CheckWarning)it.next();
            if (warning.isFatal()) {
                if (!this.showFatal) continue;
                ++fatalCount;
            }
            if (!warning.isFatal()) {
                if (!this.showWarnings) continue;
                ++warningCount;
            }
            if ((c = (ArrayList<CheckWarning>)warningMap.get(warning.getObject())) == null) {
                c = new ArrayList<CheckWarning>();
                warningMap.put(warning.getObject(), c);
            }
            if ((pos = Collections.binarySearch(c, warning, this.warningSorter)) >= 0) continue;
            c.add(-(pos + 1), warning);
        }
        this.initComponent(warningMap, warningCount, fatalCount);
    }

    protected class ActionWrapper
    implements Action {
        protected Action action;

        public ActionWrapper(Action action) {
            this.action = action;
        }

        public void actionPerformed(ActionEvent e) {
            boolean globalReload;
            this.action.actionPerformed(e);
            CheckWarning warning = (CheckWarning)this.action.getValue("WARNING");
            Boolean b = (Boolean)this.action.getValue("GLOBAL");
            boolean bl = globalReload = b == null ? false : b;
            if (globalReload) {
                CheckWarningComponent.this.redoCheck();
            } else {
                CheckWarningComponent.this.redoCheck(warning.getSource());
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.action.addPropertyChangeListener(listener);
        }

        public Object getValue(String key) {
            return this.action.getValue(key);
        }

        public boolean isEnabled() {
            return this.action.isEnabled();
        }

        public void putValue(String key, Object value) {
            this.action.putValue(key, value);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.action.removePropertyChangeListener(listener);
        }

        public void setEnabled(boolean b) {
            this.action.setEnabled(b);
        }
    }
}

