/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.geneontology.expression.ExpressionException;
import org.geneontology.oboedit.datamodel.CommentedObject;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.history.CommentChangeHistoryItem;
import org.geneontology.oboedit.gui.AbstractTextEditComponent;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.util.ObjectUtil;

public class CommentEditorComponent
extends AbstractTextEditComponent {
    private static final long serialVersionUID = 9103011155475223156L;
    protected JTextPane textField = new JTextPane();
    protected JScrollPane scroller = new JScrollPane(this.textField, 20, 31);

    public Component resolveName(String id, Properties props, String xml) {
        if (id.equals("field")) {
            return this.scroller;
        }
        return new JButton("id");
    }

    public void guiupdate() throws ExpressionException {
        super.guiupdate();
    }

    protected boolean useSubLayout() {
        return true;
    }

    protected String getDefaultLayout() {
        return "<component id='field' bordertitle='Comment'/>";
    }

    protected void loadGUI() {
        if (this.currentObject != null) {
            this.textField.setEnabled(true);
            if (this.currentObject instanceof CommentedObject) {
                this.textField.setText(((CommentedObject)this.currentObject).getComment());
            }
        } else {
            this.textField.setEnabled(false);
            this.textField.setText("<no selection>");
        }
    }

    protected void initializeGUI() {
        this.textField.setFont(Controller.getController().getDefaultFont());
    }

    protected String getText() {
        return this.textField.getText().trim();
    }

    public String getID() {
        return "COMMENT_EDITOR";
    }

    public void populateFields(IdentifiedObject io) {
        if (io instanceof CommentedObject) {
            ((CommentedObject)io).setComment(this.getText());
        }
    }

    protected String getWarningLabel() {
        return "Comment";
    }

    public List getChanges() {
        if (this.currentObject != null && this.currentObject instanceof CommentedObject) {
            CommentedObject co = (CommentedObject)this.currentObject;
            if (!ObjectUtil.equals((Object)this.getText(), (Object)co.getComment())) {
                CommentChangeHistoryItem item = new CommentChangeHistoryItem(co, this.getText());
                return Collections.singletonList(item);
            }
            return Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }
}

