/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;

public class DbxrefListEditor
extends JPanel
implements GenericEditorComponent {
    private static final long serialVersionUID = 1L;
    JTextField dbnameField;
    JTextField idField;
    JTextField descField;
    int defaultType;
    Dbxref ref;
    Controller controller;
    ListEditor editor;

    public DbxrefListEditor(Controller controller) {
        this(controller, -1);
    }

    public DbxrefListEditor(Controller controller, int defaultType) {
        this.defaultType = defaultType;
        this.controller = controller;
        this.dbnameField = new JTextField();
        this.idField = new JTextField();
        this.descField = new JTextField();
        this.buildGUI();
        this.attachListeners();
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.dbnameField.setEnabled(enable);
        this.idField.setEnabled(enable);
        this.descField.setEnabled(enable);
    }

    public void setMasterComponent(Component c) {
        if (c instanceof ListEditor) {
            this.editor = (ListEditor)c;
        }
    }

    public void buildGUI() {
        JPanel viewable = new JPanel();
        viewable.setOpaque(false);
        viewable.setLayout(new BoxLayout(viewable, 1));
        Font font = this.controller.getDefaultFont();
        this.setMinimumSize(new Dimension(0, 0));
        JLabel dbnameLabel = new JLabel("Database name");
        JLabel idLabel = new JLabel("Database id");
        JLabel descLabel = new JLabel("Database desc");
        JLabel typeLabel = new JLabel("Dbxref type");
        this.dbnameField.setFont(font);
        this.idField.setFont(font);
        this.descField.setFont(font);
        dbnameLabel.setFont(font);
        idLabel.setFont(font);
        descLabel.setFont(font);
        typeLabel.setFont(font);
        idLabel.setAlignmentX(0.0f);
        dbnameLabel.setAlignmentX(0.0f);
        descLabel.setAlignmentX(0.0f);
        typeLabel.setAlignmentX(0.0f);
        this.dbnameField.setAlignmentX(0.0f);
        this.descField.setAlignmentX(0.0f);
        this.idField.setAlignmentX(0.0f);
        JPanel dbnamePanel = new JPanel();
        dbnamePanel.setLayout(new BoxLayout(dbnamePanel, 1));
        dbnamePanel.setOpaque(false);
        dbnamePanel.add(dbnameLabel);
        dbnamePanel.add(this.dbnameField);
        JPanel idPanel = new JPanel();
        idPanel.setOpaque(false);
        idPanel.setLayout(new BoxLayout(idPanel, 1));
        idPanel.add(idLabel);
        idPanel.add(this.idField);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.setOpaque(false);
        topPanel.add(dbnamePanel);
        topPanel.add(Box.createHorizontalStrut(10));
        topPanel.add(idPanel);
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel, 1));
        descPanel.setOpaque(false);
        descPanel.add(descLabel);
        descPanel.add(this.descField);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.setOpaque(false);
        bottomPanel.add(descPanel);
        viewable.add(topPanel);
        viewable.add(Box.createHorizontalStrut(20));
        viewable.add(bottomPanel);
        this.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        this.setLayout(new BorderLayout());
        this.add((Component)viewable, "North");
        this.setOpaque(false);
        this.validate();
    }

    public void attachListeners() {
        try {
            ActionListener commitListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DbxrefListEditor.this.commit();
                }
            };
            FocusListener focusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    DbxrefListEditor.this.commit();
                }
            };
            this.dbnameField.addActionListener(commitListener);
            this.idField.addActionListener(commitListener);
            this.descField.addActionListener(commitListener);
            this.dbnameField.addFocusListener(focusListener);
            this.idField.addFocusListener(focusListener);
            this.descField.addFocusListener(focusListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void commit() {
        if (this.editor != null) {
            this.editor.doStore((Object)this.ref);
            this.editor.refresh();
        }
    }

    public void load(Object o) {
        this.ref = (Dbxref)o;
        this.dbnameField.setText(this.ref.getDatabase());
        this.idField.setText(this.ref.getID());
        this.descField.setText(this.ref.getDesc());
    }

    public void store(Object saveme) {
        Dbxref ref = (Dbxref)saveme;
        ref.setDatabase(this.dbnameField.getText());
        ref.setID(this.idField.getText());
        if (this.descField.getText().length() == 0) {
            ref.setDesc(null);
        } else {
            ref.setDesc(this.descField.getText());
        }
        if (this.defaultType == -1) {
            ref.setType(3);
        } else {
            ref.setType(this.defaultType);
        }
    }

    public Object createNewValue() {
        return this.controller.getSession().getObjectFactory().createDbxref("XX", "<new dbxref>", null, 3, null);
    }
}

