/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DefaultFilterEditorFactory;
import org.geneontology.oboedit.gui.filters.AbstractFilterEditor;
import org.geneontology.oboedit.gui.filters.CompoundEditable;
import org.geneontology.oboedit.gui.filters.CompoundFilter;
import org.geneontology.oboedit.gui.filters.CompoundFilterFactory;
import org.geneontology.oboedit.gui.filters.CompoundFilterImpl;
import org.geneontology.oboedit.gui.filters.Filter;
import org.geneontology.oboedit.gui.filters.FilterEditUpdateListener;
import org.geneontology.oboedit.gui.filters.FilterEditor;
import org.geneontology.oboedit.gui.filters.FilterEditorFactory;
import org.geneontology.oboedit.gui.filters.FilterFactory;
import org.geneontology.oboedit.gui.filters.ObjectFilterFactory;

public class FilterBuilder
extends AbstractFilterEditor
implements CompoundEditable {
    private static final long serialVersionUID = 5242327828890927731L;
    protected CompoundFilter filter = new CompoundFilterImpl();
    protected FilterEditor currentEditor = null;
    protected JTree filterTree = new JTree();
    protected JPanel editorPanel = new JPanel();
    protected JScrollPane treeScroller = new JScrollPane(this.filterTree, 20, 30);
    JSplitPane splitPane = new JSplitPane(1, true, this.treeScroller, this.editorPanel);
    protected FilterFactory compoundFilterFactory = new CompoundFilterFactory();
    protected FilterFactory filterFactory = new ObjectFilterFactory();
    protected FilterEditorFactory filterEditorFactory = new DefaultFilterEditorFactory();
    protected FilterTreeModel filterTreeModel = new FilterTreeModel();
    protected JLabel filterLabel = new JLabel("<just some label!>");
    protected Color buttonColor;
    protected JPopupMenu rightClickMenu = new JPopupMenu();
    protected boolean showCompoundFilter = false;
    protected JMenuItem addItem = new JMenuItem("Add Filter");
    protected JMenuItem addCompoundItem = new JMenuItem("Add Boolean Filter");
    protected JMenuItem delItem = new JMenuItem("Delete");
    protected static int idgen = 0;
    protected int id = idgen++;
    protected TreeSelectionListener treeListener = new TreeSelectionListener(){

        public void valueChanged(TreeSelectionEvent e) {
            FilterBuilder.this.updateTreeSelection();
        }
    };
    protected TreeCellRenderer compoundRenderer = new DefaultTreeCellRenderer(){
        private static final long serialVersionUID = -4246196502391764806L;

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof FilterWrapper) {
                value = ((FilterWrapper)value).getFilter();
            }
            String label = value.toString();
            if (value instanceof CompoundFilter) {
                int op = ((CompoundFilter)value).getBooleanOperation();
                label = op == 0 ? "AND" : (op == 1 ? "OR" : "??");
            }
            return super.getTreeCellRendererComponent(tree, label, sel, expanded, leaf, row, hasFocus);
        }
    };
    protected FilterEditUpdateListener updateListener = new FilterEditUpdateListener(){

        public void update() {
            FilterBuilder.this.filterTree.repaint();
        }
    };

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.filterTree.setEnabled(enabled);
        if (this.currentEditor != null) {
            ((JComponent)((Object)this.currentEditor)).setEnabled(enabled);
        }
    }

    public void setCompoundFilterFactory(FilterFactory compoundFilterFactory) {
        this.compoundFilterFactory = compoundFilterFactory;
        this.createNewFilter();
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
        this.createNewFilter();
    }

    public void createNewFilter() {
        CompoundFilterImpl cfilter = new CompoundFilterImpl();
        Filter filter = this.filterFactory.createNewFilter();
        Object[] os = new Object[]{new FilterWrapper(cfilter), new FilterWrapper(filter)};
        TreePath path = new TreePath(os);
        cfilter.addFilter(filter);
        this.filter = cfilter;
        this.filterTreeModel.reload();
        this.filterTree.setSelectionPath(path);
        this.refresh();
    }

    public void setFilterEditorFactory(FilterEditorFactory filterEditorFactory) {
        this.filterEditorFactory = filterEditorFactory;
    }

    public void setFilter(Filter filter) {
        if (filter != null) {
            this.filter = (CompoundFilter)filter;
            this.updateGUI();
        } else {
            this.createNewFilter();
        }
        this.refresh();
        this.doPathSelect();
    }

    protected void updateGUI() {
        this.filterTree.removeTreeSelectionListener(this.treeListener);
        this.filterTreeModel.reload();
        this.filterTree.setSelectionRow(0);
        this.filterTree.addTreeSelectionListener(this.treeListener);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void acceptEdits() {
        if (this.currentEditor != null) {
            this.currentEditor.acceptEdits();
        }
    }

    protected void updateTreeSelection() {
        if (this.currentEditor != null) {
            this.currentEditor.acceptEdits();
        }
        this.editorPanel.removeAll();
        Filter filter = this.getSelectedFilter();
        if (filter != null) {
            if (this.currentEditor != null) {
                this.currentEditor.removeFilterEditUpdateListener(this.updateListener);
            }
            this.currentEditor = this.filterEditorFactory.getFilterEditor(filter);
            this.currentEditor.addFilterEditUpdateListener(this.updateListener);
            ((Component)((Object)this.currentEditor)).setFont(this.getFont());
            this.currentEditor.setButtonColor(this.buttonColor);
        } else {
            this.currentEditor = null;
        }
        if (this.currentEditor != null) {
            this.currentEditor.setFilter(filter);
            this.editorPanel.add((JComponent)((Object)this.currentEditor));
        }
        this.editorPanel.validate();
        this.editorPanel.repaint();
        this.updateLabel();
    }

    public void addActionListener(ActionListener listener) {
        this.currentEditor.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.currentEditor.removeActionListener(listener);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.rightClickMenu != null) {
            this.rightClickMenu.setFont(font);
        }
        if (this.addItem != null) {
            this.addItem.setFont(font);
        }
        if (this.delItem != null) {
            this.delItem.setFont(font);
        }
        if (this.addCompoundItem != null) {
            this.addCompoundItem.setFont(font);
        }
        if (this.filterTree != null) {
            this.filterTree.setFont(font);
        }
        if (this.rightClickMenu != null) {
            this.rightClickMenu.setFont(font);
        }
        if (this.filterLabel != null) {
            this.filterLabel.setFont(font);
        }
    }

    public void setButtonColor(Color buttonColor) {
        this.buttonColor = buttonColor;
        if (this.currentEditor != null) {
            this.currentEditor.setButtonColor(buttonColor);
        }
    }

    public void addItem() {
        Filter filter = this.getSelectedFilter();
        CompoundFilter cf = this.getSelectedFilterParent();
        if (filter instanceof CompoundFilter) {
            cf = (CompoundFilter)filter;
        }
        System.err.println("Adding filter to cf = " + cf);
        if (cf != null) {
            cf.addFilter(this.filterFactory.createNewFilter());
            this.refresh();
        }
    }

    public void addBooleanItem() {
        Filter filter = this.getSelectedFilter();
        CompoundFilter cf = this.getSelectedFilterParent();
        if (filter instanceof CompoundFilter) {
            cf = (CompoundFilter)filter;
        }
        if (cf != null) {
            cf.addFilter(this.compoundFilterFactory.createNewFilter());
            this.refresh();
        }
    }

    public void delItem() {
        Filter filter = this.getSelectedFilter();
        CompoundFilter parentFilter = this.getSelectedFilterParent();
        if (parentFilter != null && filter != null) {
            parentFilter.removeFilter(filter);
            this.refresh();
        }
    }

    protected void refresh() {
        this.filterTree.removeTreeSelectionListener(this.treeListener);
        this.filterTreeModel.reload();
        this.updateLabel();
        this.filterTree.addTreeSelectionListener(this.treeListener);
    }

    protected Filter getSelectedFilter() {
        TreePath path = this.filterTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        if (!(path.getLastPathComponent() instanceof FilterWrapper)) {
            System.err.println("!! BAD NEWS, path is " + path + " of class " + path.getLastPathComponent().getClass());
        }
        FilterWrapper fw = (FilterWrapper)path.getLastPathComponent();
        return fw.getFilter();
    }

    protected CompoundFilter getSelectedFilterParent() {
        TreePath path = this.filterTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            return null;
        }
        CompoundFilter parentFilter = null;
        FilterWrapper fw = (FilterWrapper)parentPath.getLastPathComponent();
        if (fw.getFilter() instanceof CompoundFilter) {
            parentFilter = (CompoundFilter)fw.getFilter();
        }
        return parentFilter;
    }

    protected void updateLabel() {
        this.filterLabel.setText(this.filterTree.getModel().getRoot().toString());
    }

    protected void formatPopup() {
        this.addItem.setEnabled(this.getSelectedFilter() instanceof CompoundFilter);
        this.addCompoundItem.setEnabled(this.getSelectedFilter() instanceof CompoundFilter);
        this.delItem.setEnabled(this.getSelectedFilterParent() != null);
    }

    protected TreePath getFirstValidPath(Filter filter) {
        if (filter instanceof CompoundFilter) {
            CompoundFilter cf = (CompoundFilter)filter;
            if (cf.getFilters().size() == 0) {
                return new TreePath(new FilterWrapper(cf));
            }
            Filter child = (Filter)cf.getFilters().iterator().next();
            TreePath childPath = this.getFirstValidPath(child);
            Object[] os = childPath.getPath();
            TreePath out = new TreePath(new FilterWrapper(cf));
            for (int i = 0; i < os.length; ++i) {
                out = out.pathByAddingChild(os[i]);
            }
            return out;
        }
        return new TreePath(new FilterWrapper(filter));
    }

    protected void doPathSelect() {
        TreePath selectPath = this.getFirstValidPath(this.filter);
        Object[] os = selectPath.getPath();
        this.filterTree.setSelectionPath(selectPath);
    }

    public void setShowCompoundFilter(boolean showCompoundFilter) {
        if (this.showCompoundFilter != showCompoundFilter) {
            this.removeAll();
            if (this.showCompoundFilter) {
                this.splitPane.remove(this.editorPanel);
                this.add((Component)this.editorPanel, "Center");
                this.remove(this.filterLabel);
                CompoundFilter cfilter = this.filter;
                if (cfilter.getFilters().size() > 0) {
                    Filter keeper = null;
                    Iterator it = cfilter.getFilters().iterator();
                    while (it.hasNext()) {
                        Filter filter = (Filter)it.next();
                        if (filter instanceof CompoundFilter) continue;
                        keeper = filter;
                        break;
                    }
                    if (keeper != null) {
                        cfilter.getFilters().clear();
                        cfilter.addFilter(keeper);
                    } else {
                        this.createNewFilter();
                    }
                }
            } else {
                this.splitPane.setRightComponent(this.editorPanel);
                this.add((Component)this.splitPane, "Center");
                this.add((Component)this.filterLabel, "South");
            }
            this.refresh();
            this.doPathSelect();
            this.validate();
            this.repaint();
        }
        this.showCompoundFilter = showCompoundFilter;
    }

    public FilterBuilder() {
        this.setLayout(new BorderLayout());
        this.filterTree.setMinimumSize(new Dimension(150, 150));
        this.treeScroller.setMinimumSize(new Dimension(150, 150));
        this.setOpaque(false);
        this.splitPane.setOpaque(false);
        this.splitPane.setDividerSize(5);
        this.editorPanel.setOpaque(false);
        this.editorPanel.setLayout(new BorderLayout());
        this.rightClickMenu.add(this.addItem);
        this.rightClickMenu.add(this.addCompoundItem);
        this.rightClickMenu.addSeparator();
        this.rightClickMenu.add(this.delItem);
        this.filterTree.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (Controller.isPopupTrigger(e)) {
                    FilterBuilder.this.formatPopup();
                    FilterBuilder.this.rightClickMenu.show(FilterBuilder.this.filterTree, e.getX(), e.getY());
                }
            }
        });
        this.addItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterBuilder.this.addItem();
            }
        });
        this.addCompoundItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterBuilder.this.addBooleanItem();
            }
        });
        this.delItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterBuilder.this.delItem();
            }
        });
        this.filterTree.setModel(this.filterTreeModel);
        this.filterTree.setCellRenderer(this.compoundRenderer);
        this.filterTree.getSelectionModel().setSelectionMode(1);
        this.filterTree.addTreeSelectionListener(this.treeListener);
        this.add((Component)this.editorPanel, "Center");
        this.createNewFilter();
    }

    public String toString() {
        return "FilterBuilder " + this.id;
    }

    protected class FilterTreeModel
    implements TreeModel {
        protected List listeners = new ArrayList();

        protected FilterTreeModel() {
        }

        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        public void reload() {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath(new FilterWrapper(FilterBuilder.this.filter))));
        }

        protected void fireTreeStructureChanged(TreeModelEvent e) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                TreeModelListener tml = (TreeModelListener)this.listeners.get(i);
                tml.treeStructureChanged(e);
            }
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public Object getChild(Object parentWrapper, int index) {
            Filter parent = ((FilterWrapper)parentWrapper).getFilter();
            if (parent instanceof CompoundFilter) {
                return new FilterWrapper((Filter)((CompoundFilter)parent).getFilters().get(index));
            }
            return null;
        }

        public int getChildCount(Object parentWrapper) {
            Filter parent = ((FilterWrapper)parentWrapper).getFilter();
            if (parent instanceof CompoundFilter) {
                CompoundFilter cf = (CompoundFilter)parent;
                return cf.getFilters().size();
            }
            return 0;
        }

        public int getIndexOfChild(Object parentWrapper, Object child) {
            Filter parent = ((FilterWrapper)parentWrapper).getFilter();
            if (parent instanceof CompoundFilter) {
                return ((CompoundFilter)parent).getFilters().indexOf(child);
            }
            return -1;
        }

        public Object getRoot() {
            return new FilterWrapper(FilterBuilder.this.filter);
        }

        public boolean isLeaf(Object node) {
            return !(((FilterWrapper)node).getFilter() instanceof CompoundFilter);
        }
    }

    protected static class FilterWrapper {
        protected Filter filter;

        public FilterWrapper(Filter filter) {
            this.filter = filter;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public String toString() {
            return this.filter.toString();
        }
    }
}

