/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.SearchEngine;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.ComponentConfiguration;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.FilterPairEditor;
import org.geneontology.oboedit.gui.Filterable;
import org.geneontology.oboedit.gui.FilteredRenderable;
import org.geneontology.oboedit.gui.OBOEditComponent;
import org.geneontology.oboedit.gui.ObjectSelector;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.filters.CompoundFilterImpl;
import org.geneontology.oboedit.gui.filters.Filter;
import org.geneontology.oboedit.gui.filters.FilterPair;
import org.geneontology.oboedit.gui.filters.RenderStatusEvent;
import org.geneontology.oboedit.gui.filters.RenderStatusListener;
import org.geneontology.swing.DragSource;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DragListener;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;
import org.geneontology.util.ReusableProgressEvent;

public class FindPanel
extends JPanel
implements OBOEditComponent {
    private static final long serialVersionUID = 1L;
    protected static Icon deleteIcon = Preferences.loadLibraryIcon("delete.gif");
    protected static Icon findIcon = Preferences.loadLibraryIcon("find.gif");
    protected static Icon filterIcon = Preferences.loadLibraryIcon("filter.gif");
    protected static Icon renderIcon = Preferences.loadLibraryIcon("colorwheel.gif");
    protected static Icon windowIcon = Preferences.loadLibraryIcon("window.gif");
    protected static Icon tabIcon = Preferences.loadLibraryIcon("tab.gif");
    protected static Icon trashcanIcon = Preferences.loadLibraryIcon("trashcan.gif");
    protected JPanel buttonPanel = new JPanel();
    protected JPanel smallButtonPanel = new JPanel();
    protected JPanel filterManipulationPanel = new JPanel();
    protected JButton searchButton = new JButton("Search", findIcon);
    protected JButton filterButton = new JButton("Filter", filterIcon);
    protected JButton renderButton = new JButton("Render", renderIcon);
    protected JButton clearButton = new JButton("Clear results", renderIcon);
    protected FilterPairEditor filterEditor = new FilterPairEditor();
    protected JPanel progressPanel = new JPanel();
    protected JButton haltButton = new JButton("Halt");
    protected JProgressBar progressBar = new JProgressBar();
    protected Thread searchThread;
    protected Controller controller;
    protected boolean halt = false;
    protected DragSource renderButtonDragSource = new DragSource((Component)this.renderButton, (DragListener)new RenderButtonDragListener());
    protected DragSource filterButtonDragSource = new DragSource((Component)this.filterButton, (DragListener)new FilterButtonDragListener());
    protected DragSource searchButtonDragSource = new DragSource((Component)this.searchButton, (DragListener)new SearchButtonDragListener());
    protected Runnable abortRunnable = new Runnable(){

        public void run() {
            FindPanel.this.halt();
        }
    };

    public void halt() {
        this.halt = true;
        try {
            this.searchThread.join();
        }
        catch (InterruptedException ex) {
            System.err.println("This should never happen");
        }
        this.setProgressPanelVisible(false);
    }

    protected void setDefaultColumnSizes(JTable table) {
        JTableHeader header = table.getTableHeader();
        TableColumnModel columnModel = header.getColumnModel();
        AbstractSearchModel model = (AbstractSearchModel)table.getModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn tc = columnModel.getColumn(i);
            int width = 0;
            for (int j = 0; j < table.getRowCount(); ++j) {
                Object o = model.getValueAt(j, i);
                TableCellRenderer renderer = table.getCellRenderer(j, i);
                Component c = renderer.getTableCellRendererComponent(table, o, true, true, j, i);
                if ((int)c.getPreferredSize().getWidth() <= width) continue;
                width = (int)c.getPreferredSize().getWidth();
            }
            if (model.columnHasMaxWidth(i)) {
                tc.setMinWidth(width + 10);
                tc.setMaxWidth(width + 10);
            }
            tc.setPreferredWidth(width + 10);
        }
    }

    public void showProgress(String message, int val) {
        ProgressRunnable progressRunnable = new ProgressRunnable();
        progressRunnable.setString(message);
        progressRunnable.setVal(val);
        SwingUtilities.invokeLater(progressRunnable);
    }

    protected void processResult(Collection results, ObjectSelector selector) {
        ResultComponent c = this.buildResultComponent(results, selector);
        c.anchorTab();
    }

    protected void selectTableRows(JTable table, ObjectSelector selector) {
        int[] rows = table.getSelectedRows();
        HashSet<Object> selectThese = new HashSet<Object>();
        RowSelector resultModel = (RowSelector)((Object)table.getModel());
        for (int i = 0; i < rows.length; ++i) {
            Object o = resultModel.getValueAt(rows[i]);
            Object paths = null;
            if (o instanceof LinkedObject || o instanceof Link) {
                selectThese.add(o);
                continue;
            }
            System.err.println("found weird things in the search set");
        }
        if (selector == null) {
            selector = this.controller.getPrimarySelector();
        }
        if (selector == null) {
            return;
        }
        TreePath[] bestpaths = TermUtil.getBestPaths(selectThese, selector.getRootAlgorithm(), selector.getLinkDatabase());
        System.err.println("selectThese = " + selectThese + ", bestpaths...");
        for (int i = 0; i < bestpaths.length; ++i) {
            System.err.println("   " + i + ") " + bestpaths[i]);
        }
        selector.select(bestpaths);
    }

    protected ResultComponent buildResultComponent(Collection results, final ObjectSelector selector) {
        JComponent centerComponent;
        JTableHeader header;
        int resultCount = results.size();
        final IdentifiedObjectModel objectModel = new IdentifiedObjectModel(results);
        final LinkModel linkModel = new LinkModel(results);
        JTable oTable = null;
        JTable lTable = null;
        final JCheckBox autoselectBox = new JCheckBox("Autoselect", true);
        autoselectBox.setOpaque(false);
        autoselectBox.setFont(this.getFont());
        if (objectModel.getRowCount() > 0) {
            oTable = new JTable(objectModel);
            this.setDefaultColumnSizes(oTable);
            header = oTable.getTableHeader();
            header.setBackground(Preferences.defaultButtonColor());
            header.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    TableColumnModel columnModel = header.getColumnModel();
                    int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                    int column = columnModel.getColumn(viewColumn).getModelIndex();
                    objectModel.setSortColumn(column);
                }
            });
        }
        if (linkModel.getRowCount() > 0) {
            lTable = new JTable(linkModel);
            this.setDefaultColumnSizes(lTable);
            header = lTable.getTableHeader();
            header.setBackground(Preferences.defaultButtonColor());
            header.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    TableColumnModel columnModel = header.getColumnModel();
                    int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                    int column = columnModel.getColumn(viewColumn).getModelIndex();
                    linkModel.setSortColumn(column);
                }
            });
        }
        final JTable objectTable = oTable;
        final JTable linkTable = lTable;
        if (objectTable != null) {
            objectTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!autoselectBox.isSelected()) {
                        return;
                    }
                    FindPanel.this.selectTableRows(objectTable, selector);
                }
            });
        }
        if (linkTable != null) {
            linkTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!autoselectBox.isSelected()) {
                        return;
                    }
                    FindPanel.this.selectTableRows(linkTable, selector);
                }
            });
        }
        final ResultComponent out = new ResultComponent(this.filterEditor);
        out.setBackground(Preferences.defaultBackgroundColor());
        out.setLayout(new BorderLayout());
        final JTextField nameField = new JTextField();
        nameField.setFont(this.getFont());
        nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                out.setName(nameField.getText());
            }
        });
        final JButton anchorButton = new JButton(windowIcon);
        anchorButton.setToolTipText("Display results in a separate window");
        anchorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                out.toggleWindowMode();
                if (out.isWindowMode()) {
                    anchorButton.setIcon(tabIcon);
                    anchorButton.setToolTipText("Hide window and display results as a search tab");
                } else {
                    anchorButton.setIcon(windowIcon);
                    anchorButton.setToolTipText("Display results in a separate window");
                }
            }
        });
        anchorButton.setFont(this.getFont());
        JButton closeButton = new JButton(deleteIcon);
        closeButton.setToolTipText("Discard search results");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                out.dispose();
            }
        });
        anchorButton.setBackground(Preferences.defaultButtonColor());
        closeButton.setBackground(Preferences.defaultButtonColor());
        JTabbedPane tabbed = null;
        if (objectTable != null && linkTable != null) {
            tabbed = new JTabbedPane();
            tabbed.add((Component)new JScrollPane(objectTable), "Term results");
            tabbed.add((Component)new JScrollPane(linkTable), "Link results");
            tabbed.setFont(this.getFont());
            centerComponent = tabbed;
        } else {
            centerComponent = linkTable != null ? new JScrollPane(linkTable) : new JScrollPane(objectTable);
        }
        final JTabbedPane tabbedPane = tabbed;
        JButton selectButton = new JButton("Select terms");
        selectButton.setFont(this.getFont());
        selectButton.setBackground(Preferences.defaultButtonColor());
        selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (tabbedPane != null) {
                    if (tabbedPane.getSelectedIndex() == 0) {
                        FindPanel.this.selectTableRows(objectTable, selector);
                    } else {
                        FindPanel.this.selectTableRows(linkTable, selector);
                    }
                } else if (objectTable != null) {
                    FindPanel.this.selectTableRows(objectTable, selector);
                } else if (linkTable != null) {
                    FindPanel.this.selectTableRows(linkTable, selector);
                }
            }
        });
        JLabel nameLabel = new JLabel("Results label");
        nameLabel.setFont(this.getFont());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(autoselectBox);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(selectButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(nameLabel);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(nameField);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(anchorButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(closeButton);
        buttonPanel.add(Box.createHorizontalGlue());
        out.add((Component)centerComponent, "Center");
        out.add((Component)buttonPanel, "South");
        nameField.setText(resultCount + " results");
        out.setName(resultCount + " results");
        return out;
    }

    public void doThreadedSearch() {
        this.doThreadedSearch(null);
    }

    public void doThreadedSearch(ObjectSelector selector) {
        this.search(selector);
    }

    public FindPanel() {
        this.buttonPanel.setOpaque(false);
        this.progressPanel.setOpaque(false);
        this.filterManipulationPanel.setOpaque(false);
        this.progressPanel.setLayout(new BorderLayout());
        this.progressPanel.add((Component)this.progressBar, "North");
        this.progressPanel.add((Component)this.haltButton, "Center");
        this.progressPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.progressBar.setStringPainted(true);
        JPanel filterIOPanel = new JPanel();
        filterIOPanel.setLayout(new GridLayout(1, 3));
        filterIOPanel.setOpaque(false);
        JButton newButton = new JButton(Preferences.loadLibraryIcon("file.gif"));
        JButton loadButton = new JButton(Preferences.loadLibraryIcon("folder.gif"));
        JButton saveButton = new JButton(Preferences.loadLibraryIcon("floppy.gif"));
        JButton reloadButton = new JButton(Preferences.loadLibraryIcon("reload.gif"));
        newButton.setToolTipText("Create new filter");
        loadButton.setToolTipText("Load a filter from disk");
        saveButton.setToolTipText("Save a filter to disk");
        reloadButton.setToolTipText("Close search results and reset filter");
        newButton.setPreferredSize(new Dimension(20, 20));
        loadButton.setPreferredSize(new Dimension(20, 20));
        saveButton.setPreferredSize(new Dimension(20, 20));
        reloadButton.setPreferredSize(new Dimension(20, 20));
        newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindPanel.this.filterEditor.newFilter();
            }
        });
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindPanel.this.filterEditor.load();
            }
        });
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindPanel.this.filterEditor.save();
            }
        });
        this.haltButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(FindPanel.this.abortRunnable);
            }
        });
        reloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindPanel.this.filterEditor.reset();
            }
        });
        newButton.setBackground(Preferences.defaultButtonColor());
        loadButton.setBackground(Preferences.defaultButtonColor());
        saveButton.setBackground(Preferences.defaultButtonColor());
        this.haltButton.setBackground(Preferences.defaultButtonColor());
        reloadButton.setBackground(Preferences.defaultButtonColor());
        filterIOPanel.add(newButton);
        filterIOPanel.add(loadButton);
        filterIOPanel.add(saveButton);
        filterIOPanel.add(reloadButton);
        this.filterManipulationPanel.setLayout(new BorderLayout());
        this.filterManipulationPanel.add((Component)this.renderButton, "North");
        this.filterManipulationPanel.add((Component)filterIOPanel, "South");
        this.smallButtonPanel.setLayout(new BorderLayout());
        this.smallButtonPanel.setOpaque(false);
        this.smallButtonPanel.add((Component)this.filterButton, "North");
        this.smallButtonPanel.add((Component)this.filterManipulationPanel, "South");
        this.buttonPanel.setLayout(new BorderLayout());
        this.buttonPanel.add((Component)this.searchButton, "Center");
        this.buttonPanel.add((Component)this.smallButtonPanel, "South");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindPanel.this.doThreadedSearch();
            }
        });
        this.filterEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindPanel.this.doThreadedSearch();
            }
        });
        this.renderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindPanel.this.doRender();
            }
        });
        this.filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindPanel.this.doFilter();
            }
        });
        this.setPreferredSize(new Dimension(200, 150));
        this.setLayout(new BorderLayout());
        this.add((Component)this.filterEditor, "Center");
        this.add((Component)this.buttonPanel, "East");
        this.setBackground(Preferences.defaultBackgroundColor());
        this.setButtonColor(Preferences.defaultButtonColor());
        this.filterEditor.setBackground(Preferences.defaultBackgroundColor());
        this.setRenderButtonVisible(this.filterEditor.getSpecEditorVisible());
        this.filterEditor.addRenderStatusListener(new RenderStatusListener(){

            public void statusChanged(RenderStatusEvent event) {
                FindPanel.this.setRenderButtonVisible(event.isRendererVisible());
            }
        });
    }

    protected void doFilter() {
        ObjectSelector primarySelector = this.controller.getPrimarySelector();
        if (primarySelector instanceof Filterable) {
            ((Filterable)((Object)primarySelector)).setFilter(this.filterEditor.getFilterPair());
        }
    }

    protected void doRender() {
        ObjectSelector primarySelector = this.controller.getPrimarySelector();
        if (primarySelector instanceof FilteredRenderable) {
            ((FilteredRenderable)((Object)primarySelector)).addRenderer(this.filterEditor.getFilterPair());
        }
    }

    protected void setRenderButtonVisible(boolean visible) {
        this.filterManipulationPanel.remove(this.renderButton);
        if (visible) {
            this.filterManipulationPanel.add((Component)this.renderButton, "North");
        }
        this.buttonPanel.validate();
        this.buttonPanel.repaint();
    }

    public void setButtonColor(Color buttonColor) {
        this.filterEditor.setButtonColor(buttonColor);
        this.searchButton.setBackground(buttonColor);
        this.filterButton.setBackground(buttonColor);
        this.renderButton.setBackground(buttonColor);
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.setFont(controller.getDefaultFont());
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.filterButton != null) {
            this.filterButton.setFont(font);
        }
        if (this.renderButton != null) {
            this.renderButton.setFont(font);
        }
        if (this.buttonPanel != null) {
            this.buttonPanel.setFont(font);
        }
        if (this.filterEditor != null) {
            this.filterEditor.setFont(font);
        }
        if (this.searchButton != null) {
            this.searchButton.setFont(font);
        }
        if (this.progressBar != null) {
            this.progressBar.setFont(font);
        }
        if (this.haltButton != null) {
            this.haltButton.setFont(font);
        }
    }

    protected boolean searchSelected() {
        return false;
    }

    protected boolean searchChildren() {
        return false;
    }

    protected boolean searchAll() {
        return true;
    }

    protected boolean searchObsoletes() {
        return false;
    }

    public void setProgressPanelVisible(boolean visible) {
        if (visible) {
            this.remove(this.filterEditor);
            this.add((Component)this.progressPanel, "Center");
        } else {
            this.remove(this.progressPanel);
            this.add((Component)this.filterEditor, "Center");
        }
        this.validate();
        this.repaint();
    }

    public Filter getWrappedFilter(Filter filter, Collection defaultFilters, boolean linkFilter) {
        if (filter == null) {
            return null;
        }
        if (defaultFilters.size() == 0) {
            return filter;
        }
        CompoundFilterImpl cf = new CompoundFilterImpl();
        cf.setBooleanOperation(0);
        cf.addFilter(filter);
        Iterator it = defaultFilters.iterator();
        while (it.hasNext()) {
            FilterPair filterPair = (FilterPair)it.next();
            if (linkFilter) {
                if (filterPair.getLinkFilter() == null) continue;
                cf.addFilter(filterPair.getLinkFilter());
                continue;
            }
            if (filterPair.getObjectFilter() == null) continue;
            cf.addFilter(filterPair.getObjectFilter());
        }
        return cf;
    }

    public void filter() {
        this.doFilter();
    }

    public void search() {
        this.search(null);
    }

    public void search(final ObjectSelector selector) {
        Filter filter = this.getWrappedFilter(this.filterEditor.getFilterPair().getObjectFilter(), this.controller.getModifyFilters(), false);
        Filter linkFilter = this.getWrappedFilter(this.filterEditor.getFilterPair().getLinkFilter(), this.controller.getModifyFilters(), true);
        final SearchEngine.SearchThread thread = SearchEngine.getSearchThread(Controller.getController().getCurrentLinkDatabase(), filter, linkFilter, Controller.getController().getExpressionManager().getContext());
        thread.setStartRunnable(new Runnable(){

            public void run() {
                FindPanel.this.setProgressPanelVisible(true);
            }
        });
        thread.setHaltRunnable(this.abortRunnable);
        thread.setEndRunnable(new Runnable(){

            public void run() {
                FindPanel.this.processResult(thread.getResults(), selector);
                FindPanel.this.setProgressPanelVisible(false);
            }
        });
        thread.addProgressListener(new ProgressListener(){

            public void progressMade(ProgressEvent e) {
                int val = 0;
                val = e instanceof ReusableProgressEvent ? ((ReusableProgressEvent)e).getFastVal() : e.getValue().intValue();
                FindPanel.this.showProgress("Searching", val);
            }
        });
        thread.start();
    }

    public Object createNewValue() {
        return null;
    }

    public JComponent getComponent() {
        return this;
    }

    public void setFilterPair(FilterPair pair) {
        this.filterEditor.setFilterPair(pair);
    }

    public ComponentConfiguration getConfiguration() {
        return this.filterEditor.getConfig();
    }

    public void setConfiguration(ComponentConfiguration config) {
        this.filterEditor.setConfig(config);
    }

    public void cleanup() {
        this.controller.getDragController().unregisterDragSource(this.renderButtonDragSource);
        this.controller.getDragController().unregisterDragSource(this.filterButtonDragSource);
        this.controller.getDragController().unregisterDragSource(this.searchButtonDragSource);
    }

    public void init() {
        this.controller.getDragController().registerDragSource(this.renderButtonDragSource);
        this.controller.getDragController().registerDragSource(this.filterButtonDragSource);
        this.controller.getDragController().registerDragSource(this.searchButtonDragSource);
    }

    public boolean isSingleton() {
        return true;
    }

    public String getID() {
        return "FIND";
    }

    public void setXML(String xml) {
    }

    protected static class ResultComponent
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected boolean windowMode = false;
        protected FilterPairEditor pairEditor;
        protected JDialog dialog = new JDialog();
        protected String name;

        public void setName(String name) {
            this.pairEditor.setTabName(this, name);
            this.dialog.setTitle(name);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ResultComponent(FilterPairEditor pairEditor) {
            this.pairEditor = pairEditor;
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e) {
                    ResultComponent.this.dispose();
                }
            });
        }

        public boolean isWindowMode() {
            return this.windowMode;
        }

        public void showDialog() {
            this.pairEditor.removeExtendedTab(this);
            this.pairEditor.validate();
            this.pairEditor.repaint();
            this.dialog.setContentPane(this);
            this.dialog.setSize(400, 400);
            this.dialog.show();
            this.windowMode = true;
        }

        public void anchorTab() {
            this.dialog.setContentPane(new JPanel());
            this.dialog.hide();
            this.pairEditor.addExtendedTab(this, this.getName(), findIcon);
            this.windowMode = false;
        }

        public void dispose() {
            this.windowMode = false;
            this.pairEditor.removeExtendedTab(this);
            this.pairEditor.validate();
            this.pairEditor.repaint();
            this.dialog.setContentPane(new JPanel());
            if (this.dialog.isDisplayable()) {
                this.dialog.dispose();
            }
            this.dialog.hide();
        }

        public void toggleWindowMode() {
            if (this.windowMode) {
                this.anchorTab();
            } else {
                this.showDialog();
            }
        }
    }

    protected class ProgressRunnable
    implements Runnable {
        protected String message;
        protected int val;

        public void setString(String message) {
            this.message = message;
        }

        public void setVal(int val) {
            this.val = val;
        }

        public String getString() {
            return this.message;
        }

        public int getVal() {
            return this.val;
        }

        public void run() {
            if (this.message != null) {
                FindPanel.this.progressBar.setString(this.message + " " + this.val + "%");
            } else {
                FindPanel.this.progressBar.setString(this.val + "%");
            }
            FindPanel.this.progressBar.setValue(this.val);
        }
    }

    protected class LinkModel
    extends AbstractSearchModel {
        private static final long serialVersionUID = 1L;

        public LinkModel(Collection results) {
            Iterator it = results.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof Link)) continue;
                it.remove();
                this.itemList.add(o);
            }
            this.setSortColumn(0);
        }

        public int getColumnCount() {
            return 5;
        }

        public Object getColumnVal(Object row, int column) {
            Link link = (Link)row;
            if (column == 0) {
                return link.getChild().getName();
            }
            if (column == 1) {
                return link.getChild().getID();
            }
            if (column == 2) {
                return link.getType().getID();
            }
            if (column == 3) {
                return link.getParent().getName();
            }
            if (column == 4) {
                return link.getParent().getID();
            }
            throw new IllegalArgumentException("column out of range");
        }

        public boolean columnHasMaxWidth(int column) {
            return column == 1 || column == 2 || column == 4;
        }

        public String getColumnName(int index) {
            if (index == 0) {
                return "Child name";
            }
            if (index == 1) {
                return "Child id";
            }
            if (index == 2) {
                return "Type id";
            }
            if (index == 3) {
                return "Parent name";
            }
            if (index == 4) {
                return "Parent id";
            }
            return "?!";
        }
    }

    protected class IdentifiedObjectModel
    extends AbstractSearchModel {
        private static final long serialVersionUID = 1L;

        public IdentifiedObjectModel(Collection results) {
            Iterator it = results.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof IdentifiedObject)) continue;
                it.remove();
                this.itemList.add(o);
            }
            this.setSortColumn(1);
        }

        public boolean columnHasMaxWidth(int column) {
            return column == 0;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getColumnVal(Object row, int column) {
            IdentifiedObject obj = (IdentifiedObject)row;
            if (column == 0) {
                return obj.getID();
            }
            if (column == 1) {
                return obj.getName();
            }
            throw new IllegalArgumentException("column out of range");
        }

        public String getColumnName(int index) {
            if (index == 0) {
                return "ID";
            }
            if (index == 1) {
                return "Name";
            }
            return "?!";
        }
    }

    protected abstract class AbstractSearchModel
    extends AbstractTableModel
    implements RowSelector {
        protected List itemList = new ArrayList();
        protected boolean reverse = false;
        protected int sortColumn = 0;
        protected Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                String compVal1 = AbstractSearchModel.this.getColumnVal(o1, AbstractSearchModel.this.sortColumn).toString();
                String compVal2 = AbstractSearchModel.this.getColumnVal(o2, AbstractSearchModel.this.sortColumn).toString();
                int compVal = compVal1.compareToIgnoreCase(compVal2);
                if (AbstractSearchModel.this.reverse) {
                    return -compVal;
                }
                return compVal;
            }
        };

        protected AbstractSearchModel() {
        }

        public abstract boolean columnHasMaxWidth(int var1);

        public Object getValueAt(int row) {
            return this.itemList.get(row);
        }

        public void setSortColumn(int sortColumn) {
            this.reverse = sortColumn == this.sortColumn ? !this.reverse : false;
            this.sortColumn = sortColumn;
            this.doSort();
        }

        public abstract Object getColumnVal(Object var1, int var2);

        public Object getValueAt(int row, int column) {
            return this.getColumnVal(this.getValueAt(row), column);
        }

        protected void doSort() {
            Collections.sort(this.itemList, this.comparator);
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.itemList.size();
        }
    }

    protected static interface RowSelector {
        public Object getValueAt(int var1);
    }

    protected class FilterButtonDragListener
    extends ButtonDragListener {
        public FilterButtonDragListener() {
            this.createImages(filterIcon);
        }

        public Object getDragData(MouseEvent e) {
            return new FilterPairDropper(FindPanel.this.filterEditor.getFilterPair(), "FILTER");
        }
    }

    protected class SearchButtonDragListener
    extends ButtonDragListener {
        public SearchButtonDragListener() {
            this.createImages(findIcon);
        }

        public void dropped(DragEvent e) {
            if (e.getDropTarget() instanceof ObjectSelector) {
                FindPanel.this.doThreadedSearch((ObjectSelector)((Object)e.getDropTarget()));
            }
        }

        public Object getDragData(MouseEvent e) {
            return new FilterPairDropper(FindPanel.this.filterEditor.getFilterPair(), "SELECT");
        }
    }

    protected class RenderButtonDragListener
    extends ButtonDragListener {
        public RenderButtonDragListener() {
            this.createImages(renderIcon);
        }

        public Object getDragData(MouseEvent e) {
            return new FilterPairDropper(FindPanel.this.filterEditor.getFilterPair(), "RENDER");
        }
    }

    protected abstract class ButtonDragListener
    implements DragListener {
        protected Image dragImage;
        protected Image disabledImage;

        protected ButtonDragListener() {
        }

        protected void createImages(Icon icon) {
            BufferedImage iconImage = new BufferedImage(16, 16, 2);
            icon.paintIcon(FindPanel.this, ((Image)iconImage).getGraphics(), 1, 1);
            this.dragImage = new BufferedImage(15, 15, 2);
            Graphics g = this.dragImage.getGraphics();
            g.setColor(Preferences.defaultButtonColor());
            g.fillRoundRect(0, 0, 15, 15, 3, 3);
            g.drawImage(iconImage, 0, 0, null);
            this.disabledImage = new BufferedImage(15, 15, 2);
            g = this.disabledImage.getGraphics();
            g.drawImage(this.dragImage, 0, 0, null);
            g.setColor(new Color(0, 0, 0, 100));
            g.fillRoundRect(0, 0, 15, 15, 3, 3);
        }

        public boolean allowDrag(MouseEvent e) {
            return true;
        }

        public Image getDragImage(DragEvent e, boolean dropAllowed) {
            if (dropAllowed) {
                return this.dragImage;
            }
            return this.disabledImage;
        }

        public void dragging(DragEvent e) {
        }

        public void dragEnd(DragEvent e) {
        }

        public void dropped(DragEvent e) {
        }

        public Point getDragOffset(DragEvent e, boolean dropAllowed) {
            return new Point(16, 16);
        }

        public Object getDragData(MouseEvent e) {
            return FindPanel.this.filterEditor.getFilterPair();
        }

        public Cursor getDragCursor(DragEvent e, boolean dropAllowed) {
            return null;
        }
    }

    public static class FilterPairDropper {
        public static final String RENDER_OP = "RENDER";
        public static final String FILTER_OP = "FILTER";
        public static final String SELECT_OP = "SELECT";
        protected FilterPair filterPair;
        protected String operation;

        public FilterPairDropper(FilterPair filterPair, String operation) {
            this.filterPair = filterPair;
            this.operation = operation;
        }

        public FilterPair getFilterPair() {
            return this.filterPair;
        }

        public String getOperation() {
            return this.operation;
        }
    }
}

