/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.geneontology.oboedit.datamodel.impl.DefaultTermModel;
import org.geneontology.oboedit.gui.ComponentConfiguration;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.OBOEditComponent;
import org.geneontology.oboedit.gui.OBOTermPanel;
import org.geneontology.swing.SwingUtil;

public class OBOPanelHolder
extends JPanel
implements OBOEditComponent {
    private static final long serialVersionUID = -2513933375590599368L;
    protected OBOTermPanel dag;
    protected JSplitPane pane;
    protected int splitOrientation = -1;

    public OBOPanelHolder() {
        this((OBOTermPanel)null);
    }

    public OBOPanelHolder(OBOTermPanel dag) {
        Controller controller = Controller.getController();
        if (dag == null) {
            dag = this.createDAG();
        }
        this.dag = dag;
        this.setLayout(new GridLayout(1, 1));
        this.add(dag.getComponent());
    }

    public int getSplitOrientation() {
        if (this.pane == null) {
            return -1;
        }
        return this.pane.getOrientation();
    }

    public OBOTermPanel getDAG() {
        return this.dag;
    }

    public Collection getDAGs() {
        LinkedList<OBOTermPanel> out = new LinkedList<OBOTermPanel>();
        if (this.dag != null) {
            out.add(this.dag);
        } else {
            out.addAll(this.getLeftHolder().getDAGs());
            out.addAll(this.getRightHolder().getDAGs());
        }
        return out;
    }

    protected OBOTermPanel createDAG() {
        Controller controller = Controller.getController();
        OBOTermPanel d = new OBOTermPanel();
        DefaultTermModel model = new DefaultTermModel(controller);
        d.setModel(model);
        d.init();
        if (controller.getPrimarySelector() == null) {
            controller.setPrimarySelector(d);
        }
        return d;
    }

    public void split(int orientation) {
        Controller controller = Controller.getController();
        this.splitOrientation = orientation;
        this.remove(this.dag.getComponent());
        this.pane = new JSplitPane(orientation);
        this.pane.setUI(new RemovableSplitpaneUI());
        OBOPanelHolder leftHolder = new OBOPanelHolder(this.dag);
        OBOPanelHolder rightHolder = new OBOPanelHolder();
        rightHolder.getDAG().synchronize(this.dag);
        leftHolder.setController(controller);
        rightHolder.setController(controller);
        leftHolder.init();
        rightHolder.init();
        this.pane.setLeftComponent(leftHolder);
        this.pane.setRightComponent(rightHolder);
        this.pane.setDividerSize(5);
        if (this.pane != null) {
            if (this.getSplitOrientation() == 0) {
                this.pane.setDividerLocation((int)(this.pane.getPreferredSize().getHeight() / 2.0));
            } else {
                this.pane.setDividerLocation((int)(this.pane.getPreferredSize().getWidth() / 2.0));
            }
        }
        this.add(this.pane);
        this.dag = null;
        this.validate();
        this.repaint();
    }

    public void merge(OBOPanelHolder primaryHolder, OBOPanelHolder trashHolder) {
        Controller controller = Controller.getController();
        trashHolder.cleanup();
        if (primaryHolder.getDAG() != null) {
            this.remove(this.pane);
            this.dag = primaryHolder.getDAG();
            this.add(this.dag.getComponent());
            this.pane = null;
            this.splitOrientation = -1;
            if (controller.getPrimarySelector() == trashHolder.getDAG()) {
                controller.setPrimarySelector(primaryHolder.getDAG());
            }
        } else {
            OBOTermPanel panel;
            this.pane.setLeftComponent(primaryHolder.getLeftHolder());
            this.pane.setRightComponent(primaryHolder.getRightHolder());
            this.pane.validate();
            this.pane.repaint();
            this.pane.setOrientation(primaryHolder.getSplitOrientation());
            Collection c = SwingUtil.getAllDescendants((Container)trashHolder, (Class)OBOTermPanel.class);
            boolean removedPrimary = false;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                panel = (OBOTermPanel)it.next();
                if (controller.getPrimarySelector() != panel) continue;
                removedPrimary = true;
                break;
            }
            if (removedPrimary && (it = (c = SwingUtil.getAllDescendants((Container)trashHolder, (Class)OBOTermPanel.class)).iterator()).hasNext()) {
                panel = (OBOTermPanel)it.next();
                controller.setPrimarySelector(panel);
            }
        }
        this.validate();
        this.repaint();
    }

    public OBOPanelHolder getLeftHolder() {
        if (this.pane == null) {
            return null;
        }
        return (OBOPanelHolder)this.pane.getLeftComponent();
    }

    public OBOPanelHolder getRightHolder() {
        if (this.pane == null) {
            return null;
        }
        return (OBOPanelHolder)this.pane.getRightComponent();
    }

    public void merge(OBOPanelHolder primaryHolder) {
        if (this.pane == null) {
            OBOPanelHolder holder = (OBOPanelHolder)SwingUtilities.getAncestorOfClass(OBOPanelHolder.class, this);
            holder.merge(primaryHolder);
            return;
        }
        OBOPanelHolder leftHolder = (OBOPanelHolder)this.pane.getLeftComponent();
        OBOPanelHolder rightHolder = (OBOPanelHolder)this.pane.getRightComponent();
        OBOPanelHolder trashHolder = null;
        if (primaryHolder == leftHolder) {
            trashHolder = rightHolder;
        } else if (primaryHolder == rightHolder) {
            trashHolder = leftHolder;
        }
        this.merge(primaryHolder, trashHolder);
    }

    public void merge(OBOTermPanel primary) {
        if (this.pane == null) {
            OBOPanelHolder holder = (OBOPanelHolder)SwingUtilities.getAncestorOfClass(OBOPanelHolder.class, this);
            holder.merge(primary);
            return;
        }
        OBOPanelHolder leftHolder = (OBOPanelHolder)this.pane.getLeftComponent();
        OBOPanelHolder rightHolder = (OBOPanelHolder)this.pane.getRightComponent();
        OBOPanelHolder primaryHolder = null;
        OBOPanelHolder trashHolder = null;
        if (leftHolder.getDAG() == primary) {
            primaryHolder = leftHolder;
            trashHolder = rightHolder;
        } else if (rightHolder.getDAG() == primary) {
            primaryHolder = rightHolder;
            trashHolder = leftHolder;
        }
        this.merge(primaryHolder, trashHolder);
    }

    public boolean canMerge() {
        if (this.pane == null) {
            OBOPanelHolder holder = (OBOPanelHolder)SwingUtilities.getAncestorOfClass(OBOPanelHolder.class, this);
            if (holder == null) {
                return false;
            }
            return holder.canMerge();
        }
        return true;
    }

    public void init() {
        this.setBackground(Controller.getController().getPreferences().getBackgroundColor());
    }

    public void cleanup() {
        if (this.dag != null) {
            this.dag.cleanup();
        } else if (this.pane != null) {
            OBOPanelHolder leftHolder = (OBOPanelHolder)this.pane.getLeftComponent();
            OBOPanelHolder rightHolder = (OBOPanelHolder)this.pane.getRightComponent();
            leftHolder.cleanup();
            rightHolder.cleanup();
        }
    }

    public boolean isSingleton() {
        return false;
    }

    public ComponentConfiguration getConfiguration() {
        HolderConfiguration config = new HolderConfiguration();
        config.setSplitOrientation(this.splitOrientation);
        if (this.pane == null) {
            config.setDagConfiguration(this.dag.getConfiguration());
        } else {
            OBOPanelHolder leftHolder = (OBOPanelHolder)this.pane.getLeftComponent();
            OBOPanelHolder rightHolder = (OBOPanelHolder)this.pane.getRightComponent();
            config.setHolder1(leftHolder.getConfiguration());
            config.setHolder2(rightHolder.getConfiguration());
        }
        return config;
    }

    public void setConfiguration(ComponentConfiguration c) {
        if (c instanceof HolderConfiguration) {
            HolderConfiguration config = (HolderConfiguration)c;
            if (config.getSplitOrientation() != -1) {
                this.split(config.getSplitOrientation());
                OBOPanelHolder leftHolder = (OBOPanelHolder)this.pane.getLeftComponent();
                OBOPanelHolder rightHolder = (OBOPanelHolder)this.pane.getRightComponent();
                leftHolder.setConfiguration(config.getHolder1());
                rightHolder.setConfiguration(config.getHolder2());
            } else {
                this.dag.setConfiguration(config.getDagConfiguration());
            }
        }
    }

    public String getID() {
        return "DAG_HOLDER";
    }

    public void setController(Controller controller) {
        this.dag.setController(controller);
    }

    public JComponent getComponent() {
        return this;
    }

    public void setXML(String xml) {
    }

    public static class HolderConfiguration
    implements ComponentConfiguration {
        protected ComponentConfiguration dagConfiguration;
        protected ComponentConfiguration holder1;
        protected ComponentConfiguration holder2;
        protected int splitOrientation = -1;

        public void setSplitOrientation(int splitOrientation) {
            this.splitOrientation = splitOrientation;
        }

        public int getSplitOrientation() {
            return this.splitOrientation;
        }

        public void setDagConfiguration(ComponentConfiguration dagConfiguration) {
            this.dagConfiguration = dagConfiguration;
        }

        public void setHolder1(ComponentConfiguration holder1) {
            this.holder1 = holder1;
        }

        public void setHolder2(ComponentConfiguration holder2) {
            this.holder2 = holder2;
        }

        public ComponentConfiguration getDagConfiguration() {
            return this.dagConfiguration;
        }

        public ComponentConfiguration getHolder1() {
            return this.holder1;
        }

        public ComponentConfiguration getHolder2() {
            return this.holder2;
        }
    }

    protected class RemovableSplitpaneUI
    extends BasicSplitPaneUI {
        protected RemovableSplitpaneUI() {
        }

        public BasicSplitPaneDivider createDefaultDivider() {
            BasicSplitPaneDivider divider = new BasicSplitPaneDivider(this);
            divider.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        OBOPanelHolder primary = (OBOPanelHolder)((RemovableSplitpaneUI)RemovableSplitpaneUI.this).OBOPanelHolder.this.pane.getLeftComponent();
                        OBOPanelHolder.this.merge(primary);
                    }
                }
            });
            return divider;
        }
    }
}

