/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.geneontology.oboedit.gui.filters.ObjectRenderSpec;
import org.geneontology.oboedit.gui.filters.RenderSpec;
import org.geneontology.oboedit.gui.filters.SpecEditor;

public class ObjectSpecEditor
extends JPanel
implements SpecEditor {
    private static final long serialVersionUID = 1L;
    protected JCheckBox colorBox = new JCheckBox();
    protected JCheckBox underlineBox = new JCheckBox();
    protected JCheckBox fontBox = new JCheckBox();
    protected JCheckBox sizeBox = new JCheckBox();
    protected JCheckBox boldBox = new JCheckBox();
    protected JCheckBox italicBox = new JCheckBox();
    protected JLabel colorLabel = new JLabel("Change color", 11);
    protected JLabel fontLabel = new JLabel("Change font", 11);
    protected JLabel sizeLabel = new JLabel("Change size", 11);
    protected JLabel boldLabel = new JLabel("Make bold", 11);
    protected JLabel italicLabel = new JLabel("Make italic", 11);
    protected JLabel underlineLabel = new JLabel("Make underlined", 11);
    protected JPanel colorPanel = new JPanel();
    protected JPanel fontPanel = new JPanel();
    protected JPanel sizePanel = new JPanel();
    protected JPanel boldPanel = new JPanel();
    protected JPanel italicPanel = new JPanel();
    protected JPanel underlinePanel = new JPanel();
    protected JButton colorButton = new JButton();
    protected JComboBox fontListBox = new JComboBox();
    protected JTextField sizeField = new JTextField(3);
    protected ObjectRenderSpec spec = new ObjectRenderSpec();

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.colorBox.setEnabled(enabled);
        this.underlineBox.setEnabled(enabled);
        this.fontBox.setEnabled(enabled);
        this.sizeBox.setEnabled(enabled);
        this.boldBox.setEnabled(enabled);
        this.italicBox.setEnabled(enabled);
        this.colorLabel.setEnabled(enabled);
        this.fontLabel.setEnabled(enabled);
        this.sizeLabel.setEnabled(enabled);
        this.boldLabel.setEnabled(enabled);
        this.italicLabel.setEnabled(enabled);
        this.underlineLabel.setEnabled(enabled);
        this.colorButton.setEnabled(enabled);
        this.fontListBox.setEnabled(enabled);
        this.sizeField.setEnabled(enabled);
    }

    public ObjectSpecEditor() {
        this.buildGUI();
        this.attachListeners();
        this.loadFontList();
    }

    public RenderSpec createNewSpec() {
        return new ObjectRenderSpec();
    }

    protected void loadFontList() {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = gEnv.getAvailableFontFamilyNames();
        for (int i = 0; i < fontNames.length; ++i) {
            this.fontListBox.addItem(fontNames[i]);
        }
    }

    protected void attachListeners() {
        this.fontListBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjectSpecEditor.this.fontListBox.setFont(new Font((String)ObjectSpecEditor.this.fontListBox.getSelectedItem(), 0, ObjectSpecEditor.this.getFont().getSize()));
            }
        });
        this.colorBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjectSpecEditor.this.refreshGUI();
            }
        });
        this.fontBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjectSpecEditor.this.refreshGUI();
            }
        });
        this.sizeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjectSpecEditor.this.refreshGUI();
            }
        });
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(ObjectSpecEditor.this, "Choose a color", ObjectSpecEditor.this.colorButton.getBackground());
                ObjectSpecEditor.this.colorButton.setBackground(color);
            }
        });
    }

    public void setButtonColor(Color buttonColor) {
        this.fontListBox.setBackground(buttonColor);
        this.colorBox.setBackground(buttonColor);
        this.underlineBox.setBackground(buttonColor);
        this.fontBox.setBackground(buttonColor);
        this.sizeBox.setBackground(buttonColor);
        this.boldBox.setBackground(buttonColor);
        this.italicBox.setBackground(buttonColor);
    }

    protected void refreshGUI() {
        if (this.colorBox.isSelected()) {
            this.colorPanel.add(this.colorButton);
            this.colorPanel.revalidate();
        } else {
            this.colorPanel.remove(this.colorButton);
            this.colorPanel.revalidate();
        }
        if (this.fontBox.isSelected()) {
            this.fontPanel.add(this.fontListBox);
            this.fontPanel.validate();
        } else {
            this.fontPanel.remove(this.fontListBox);
            this.fontPanel.validate();
        }
        if (this.sizeBox.isSelected()) {
            this.sizePanel.add(this.sizeField);
            this.sizePanel.validate();
        } else {
            this.sizePanel.remove(this.sizeField);
            this.sizePanel.validate();
        }
        this.revalidate();
        this.repaint();
    }

    public void setSpec(RenderSpec s) {
        this.spec = s != null ? (ObjectRenderSpec)s : new ObjectRenderSpec();
        if (this.spec.getForegroundColor() != null) {
            this.colorButton.setBackground(this.spec.getForegroundColor());
            this.colorBox.setSelected(true);
        } else {
            this.colorButton.setBackground(Color.red);
            this.colorBox.setSelected(false);
        }
        if (this.spec.getFontName() != null) {
            this.fontListBox.setSelectedItem(this.spec.getFontName());
            this.fontBox.setSelected(true);
        } else {
            this.fontListBox.setSelectedIndex(0);
            this.fontBox.setSelected(false);
        }
        if (this.spec.getFontSize() != -1) {
            this.sizeField.setText(this.spec.getFontSize() + "");
            this.sizeBox.setSelected(true);
        } else {
            this.sizeField.setText(this.getFont().getSize() + "");
            this.sizeBox.setSelected(false);
        }
        this.boldBox.setSelected(this.spec.getBold());
        this.italicBox.setSelected(this.spec.getItalic());
        this.underlineBox.setSelected(this.spec.getUnderlined());
        this.refreshGUI();
    }

    protected void acceptEdits() {
        this.spec.setUnderlined(this.underlineBox.isSelected());
        this.spec.setBold(this.boldBox.isSelected());
        this.spec.setItalic(this.italicBox.isSelected());
        if (this.fontBox.isSelected()) {
            this.spec.setFontName((String)this.fontListBox.getSelectedItem());
        } else {
            this.spec.setFontName(null);
        }
        if (this.colorBox.isSelected()) {
            this.spec.setForegroundColor(this.colorButton.getBackground());
        } else {
            this.spec.setForegroundColor(null);
        }
        if (this.sizeBox.isSelected()) {
            try {
                this.spec.setFontSize(Integer.parseInt(this.sizeField.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.spec.setFontSize(-1);
        }
    }

    public RenderSpec getSpec() {
        this.acceptEdits();
        return this.spec;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fontListBox != null) {
            this.colorLabel.setFont(font);
            this.fontLabel.setFont(font);
            this.sizeLabel.setFont(font);
            this.boldLabel.setFont(font);
            this.italicLabel.setFont(font);
            this.fontListBox.setFont(font);
            this.sizeField.setFont(font);
            this.underlineLabel.setFont(font);
        }
    }

    protected int getLineHeight() {
        return this.getFont().getSize() * 2;
    }

    protected void buildGUI() {
        this.setOpaque(false);
        this.fontListBox.setRenderer(new FontListCellRenderer());
        this.colorButton.setBackground(Color.red);
        this.colorBox.setOpaque(false);
        this.fontBox.setOpaque(false);
        this.sizeBox.setOpaque(false);
        this.boldBox.setOpaque(false);
        this.italicBox.setOpaque(false);
        this.underlineBox.setOpaque(false);
        this.colorPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getLineHeight()));
        this.fontPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getLineHeight()));
        this.sizePanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getLineHeight()));
        this.boldPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getLineHeight()));
        this.italicPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getLineHeight()));
        this.underlinePanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getLineHeight()));
        this.colorPanel.setOpaque(false);
        this.fontPanel.setOpaque(false);
        this.sizePanel.setOpaque(false);
        this.boldPanel.setOpaque(false);
        this.italicPanel.setOpaque(false);
        this.underlinePanel.setOpaque(false);
        this.colorPanel.setLayout(new BoxLayout(this.colorPanel, 0));
        this.fontPanel.setLayout(new BoxLayout(this.fontPanel, 0));
        this.sizePanel.setLayout(new BoxLayout(this.sizePanel, 0));
        this.boldPanel.setLayout(new BoxLayout(this.boldPanel, 0));
        this.italicPanel.setLayout(new BoxLayout(this.italicPanel, 0));
        this.underlinePanel.setLayout(new BoxLayout(this.underlinePanel, 0));
        this.colorPanel.add(this.colorLabel);
        this.colorPanel.add(Box.createHorizontalStrut(10));
        this.colorPanel.add(this.colorBox);
        this.colorPanel.add(Box.createHorizontalStrut(10));
        this.colorPanel.add(Box.createHorizontalGlue());
        this.fontPanel.add(this.fontLabel);
        this.fontPanel.add(Box.createHorizontalStrut(10));
        this.fontPanel.add(this.fontBox);
        this.fontPanel.add(Box.createHorizontalStrut(10));
        this.fontPanel.add(Box.createHorizontalGlue());
        this.sizePanel.add(this.sizeLabel);
        this.sizePanel.add(Box.createHorizontalStrut(10));
        this.sizePanel.add(this.sizeBox);
        this.sizePanel.add(Box.createHorizontalStrut(10));
        this.sizePanel.add(Box.createHorizontalGlue());
        this.boldPanel.add(this.boldLabel);
        this.boldPanel.add(Box.createHorizontalStrut(10));
        this.boldPanel.add(this.boldBox);
        this.boldPanel.add(Box.createHorizontalStrut(10));
        this.boldPanel.add(Box.createHorizontalGlue());
        this.italicPanel.add(this.italicLabel);
        this.italicPanel.add(Box.createHorizontalStrut(10));
        this.italicPanel.add(this.italicBox);
        this.italicPanel.add(Box.createHorizontalStrut(10));
        this.italicPanel.add(Box.createHorizontalGlue());
        this.underlinePanel.add(this.underlineLabel);
        this.underlinePanel.add(Box.createHorizontalStrut(10));
        this.underlinePanel.add(this.underlineBox);
        this.underlinePanel.add(Box.createHorizontalStrut(10));
        this.underlinePanel.add(Box.createHorizontalGlue());
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.colorPanel);
        this.add(this.fontPanel);
        this.add(this.sizePanel);
        this.add(this.boldPanel);
        this.add(this.italicPanel);
        this.add(this.underlinePanel);
        this.add(Box.createVerticalGlue());
    }

    protected class FontListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        protected FontListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Font newFont = new Font((String)value, 0, this.getFont().getSize());
            this.setFont(newFont);
            return this;
        }
    }
}

