/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Color;
import java.awt.Font;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.impl.DbxrefImpl;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.util.MultiProperties;

public class Preferences {
    public static final String DEFAULT_XML_STRING = "<xmllayout>\n   <divider orientation=\"HORZ\">\n      <first>\n         <component id=\"DAG\" width=\"300\"/>\n      </first>\n      <second>\n         <divider orientation=\"VERT\">\n            <first>\n               <tabs>\n                  <tab name=\"Search &amp; Filter\">\n                     <panel>\n                        <center>\n                           <component id=\"FIND\"/>\n                        </center>\n                        <south>\n                           <box orientation=\"HORZ\">\n                              <component id=\"SEARCH_BUTTON\" label=\"Ignore obsoletes\" method=\"MODIFY\" filter=\"resource:noobsoletes.filter.xml\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search all\" method=\"MODIFY\" buttonGroup=\"SearchScope\" selected=\"true\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search children of selection\" method=\"MODIFY\" buttonGroup=\"SearchScope\" filter=\"resource:selection_children.filter.xml\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search ontology of selection\" method=\"MODIFY\" buttonGroup=\"SearchScope\" filter=\"resource:selection_root.filter.xml\"/>\n                           </box>\n                        </south>\n                     </panel>\n                  </tab>\n                  <tab name=\"Parent Plugin\">\n                     <component id=\"plugin:org.geneontology.oboedit.plugin.ParentPlugin\"/>\n                  </tab>\n               </tabs>\n            </first>\n            <second>\n               <component id=\"TEXTEDIT\" width=\"320\"/>\n            </second>\n         </divider>\n      </second>\n   </divider>\n</xmllayout>";
    protected Font font = new Font("Courier", 0, 16);
    protected Color backgroundColor = new Color(216, 223, 230);
    protected Color buttonColor = new Color(100, 149, 237);
    protected Color selectionColor = new Color(204, 204, 255);
    protected Color lightSelectionColor = new Color(230, 230, 255);
    protected boolean confirmOnExit = true;
    protected boolean useReasoner = false;
    protected boolean showComplete = false;
    protected boolean useBasicRootDetection = true;
    protected boolean autosaveEnabled = false;
    protected boolean caseSensitiveSort = false;
    protected boolean showToolTips = true;
    protected boolean allowCycles = false;
    protected boolean warnBeforeDelete = true;
    protected boolean warnBeforeDefinitionLoss = true;
    protected boolean allowExtendedCharacters = false;
    protected String mem = "128M";
    protected String filterMethod = "LOOSE";
    protected String browserCommand = "";
    protected String userName = System.getProperty("user.name");
    protected String fullName = "";
    protected String email = "";
    protected String layout = "<xmllayout>\n   <divider orientation=\"HORZ\">\n      <first>\n         <component id=\"DAG\" width=\"300\"/>\n      </first>\n      <second>\n         <divider orientation=\"VERT\">\n            <first>\n               <tabs>\n                  <tab name=\"Search &amp; Filter\">\n                     <panel>\n                        <center>\n                           <component id=\"FIND\"/>\n                        </center>\n                        <south>\n                           <box orientation=\"HORZ\">\n                              <component id=\"SEARCH_BUTTON\" label=\"Ignore obsoletes\" method=\"MODIFY\" filter=\"resource:noobsoletes.filter.xml\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search all\" method=\"MODIFY\" buttonGroup=\"SearchScope\" selected=\"true\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search children of selection\" method=\"MODIFY\" buttonGroup=\"SearchScope\" filter=\"resource:selection_children.filter.xml\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search ontology of selection\" method=\"MODIFY\" buttonGroup=\"SearchScope\" filter=\"resource:selection_root.filter.xml\"/>\n                           </box>\n                        </south>\n                     </panel>\n                  </tab>\n                  <tab name=\"Parent Plugin\">\n                     <component id=\"plugin:org.geneontology.oboedit.plugin.ParentPlugin\"/>\n                  </tab>\n               </tabs>\n            </first>\n            <second>\n               <component id=\"TEXTEDIT\" width=\"320\"/>\n            </second>\n         </divider>\n      </second>\n   </divider>\n</xmllayout>";
    protected String historyFilePath = System.getProperty("user.home") + "/.oboedit/history.xml";
    protected int autosaveWaitTime = 30;
    protected int autosaveExpirationDays = 1;
    protected int selectionBatchSize = 100;
    protected boolean autoCommitTextEdits = true;
    protected boolean warnBeforeDiscardingEdits = true;
    protected boolean warnOnDuplicateNames = true;
    protected Dbxref personalDbxref;
    protected File autosavePath = new File(System.getProperty("user.home") + "/.oboedit.autosave");
    protected List personalDbxrefs = null;
    protected String defaultDef;
    protected boolean usePersonalDefinition = false;
    protected Properties iconProperties = new Properties();
    protected MultiProperties adapterChooserProperties = new MultiProperties();
    protected Map iconHash = new HashMap();
    protected static Preferences preferences;

    public Preferences() {
        if (preferences == null) {
            Preferences.setGlobalPreferences(this);
        }
    }

    public static void setGlobalPreferences(Preferences preferences) {
        Preferences.preferences = preferences;
    }

    public static Preferences getPreferences() {
        if (preferences == null) {
            try {
                XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(Controller.getPrefsXMLFile())));
                preferences = (Preferences)d.readObject();
                d.close();
            }
            catch (FileNotFoundException e) {
                preferences = new Preferences();
            }
        }
        return preferences;
    }

    public void setWarnOnDuplicateNames(boolean warnOnDuplicateNames) {
        this.warnOnDuplicateNames = warnOnDuplicateNames;
    }

    public boolean getWarnOnDuplicateNames() {
        return this.warnOnDuplicateNames;
    }

    public boolean getAutoCommitTextEdits() {
        return this.autoCommitTextEdits;
    }

    public void setAutoCommitTextEdits(boolean autoCommitTextEdits) {
        this.autoCommitTextEdits = autoCommitTextEdits;
    }

    public boolean getWarnBeforeDiscardingEdits() {
        return this.warnBeforeDiscardingEdits;
    }

    public void setWarnBeforeDiscardingEdits(boolean warnBeforeDiscardingEdits) {
        this.warnBeforeDiscardingEdits = warnBeforeDiscardingEdits;
    }

    public void setAllowExtendedCharacters(boolean allowExtendedCharacters) {
        this.allowExtendedCharacters = allowExtendedCharacters;
    }

    public boolean getAllowExtendedCharacters() {
        return this.allowExtendedCharacters;
    }

    public void setHistoryFilePath(String historyFilePath) {
        this.historyFilePath = historyFilePath;
    }

    public String getHistoryFilePath() {
        return this.historyFilePath;
    }

    public void setSelectionBatchSize(int selectionBatchSize) {
        this.selectionBatchSize = selectionBatchSize;
    }

    public int getSelectionBatchSize() {
        return this.selectionBatchSize;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setAdapterChooserProperties(MultiProperties adapterChooserProperties) {
        this.adapterChooserProperties = adapterChooserProperties;
    }

    public MultiProperties getAdapterChooserProperties() {
        return this.adapterChooserProperties;
    }

    public void setIconProperties(Properties iconProperties) {
        this.iconProperties = iconProperties;
    }

    public Properties getIconProperties() {
        return this.iconProperties;
    }

    public void setWarnBeforeDefinitionLoss(boolean warnBeforeDefinitionLoss) {
        this.warnBeforeDefinitionLoss = warnBeforeDefinitionLoss;
    }

    public boolean getWarnBeforeDefinitionLoss() {
        return this.warnBeforeDefinitionLoss;
    }

    public void setWarnBeforeDelete(boolean warnBeforeDelete) {
        this.warnBeforeDelete = warnBeforeDelete;
    }

    public boolean getWarnBeforeDelete() {
        return this.warnBeforeDelete;
    }

    public void setAllowCycles(boolean allowCycles) {
        this.allowCycles = allowCycles;
    }

    public boolean getAllowCycles() {
        return this.allowCycles;
    }

    public void setShowToolTips(boolean showToolTips) {
        this.showToolTips = showToolTips;
    }

    public boolean getShowToolTips() {
        return this.showToolTips;
    }

    public void setCaseSensitiveSort(boolean caseSensitiveSort) {
        this.caseSensitiveSort = caseSensitiveSort;
    }

    public boolean getCaseSensitiveSort() {
        return this.caseSensitiveSort;
    }

    public void setAutosaveExpirationDays(int autosaveExpirationDays) {
        this.autosaveExpirationDays = autosaveExpirationDays;
    }

    public int getAutosaveExpirationDays() {
        return this.autosaveExpirationDays;
    }

    public void setAutosaveWaitTime(int autosaveWaitTime) {
        this.autosaveWaitTime = autosaveWaitTime;
    }

    public int getAutosaveWaitTime() {
        return this.autosaveWaitTime;
    }

    public void setAutosaveEnabled(boolean autosaveEnabled) {
        this.autosaveEnabled = autosaveEnabled;
    }

    public boolean getAutosaveEnabled() {
        return this.autosaveEnabled;
    }

    public File getAutosavePath() {
        return this.autosavePath;
    }

    public void setAutosavePath(File autosavePath) {
        this.autosavePath = autosavePath;
    }

    public Dbxref getPersonalDbxref() {
        if (this.personalDbxref != null) {
            return this.personalDbxref;
        }
        return new DbxrefImpl("", this.getUserName(), -1);
    }

    public void setPersonalDbxref(Dbxref personalDbxref) {
        this.personalDbxref = personalDbxref;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setBrowserCommand(String browserCommand) {
        this.browserCommand = browserCommand;
    }

    public String getBrowserCommand() {
        return this.browserCommand;
    }

    public void setUseBasicRootDetection(boolean useBasicRootDetection) {
        this.useBasicRootDetection = useBasicRootDetection;
    }

    public boolean getUseBasicRootDetection() {
        return this.useBasicRootDetection;
    }

    public String getFilterMethod() {
        return this.filterMethod;
    }

    public void setFilterMethod(String filterMethod) {
        this.filterMethod = filterMethod;
    }

    protected Icon loadLibraryIconLocal(String name) {
        Icon out = (Icon)this.iconHash.get(name);
        if (out == null) {
            URL url = Controller.getController().getExtensionLoader().getResource("org/geneontology/oboedit/gui/resources/icons/" + name);
            out = new ImageIcon(url);
            this.iconHash.put(name, out);
        }
        return out;
    }

    public String getMemString() {
        return this.mem;
    }

    public void setMemString(String mem) {
        this.mem = mem;
    }

    public boolean getUseReasoner() {
        return this.useReasoner;
    }

    public void setUseReasoner(boolean useReasoner) {
        this.useReasoner = useReasoner;
    }

    public boolean getConfirmOnExit() {
        return this.confirmOnExit;
    }

    public void setConfirmOnExit(boolean confirmOnExit) {
        this.confirmOnExit = confirmOnExit;
    }

    public Color getLightSelectionColor() {
        return this.lightSelectionColor;
    }

    public void setLightSelectionColor(Color lightSelectionColor) {
        this.lightSelectionColor = lightSelectionColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
    }

    public Color getButtonColor() {
        if (Controller.isMacOS()) {
            return null;
        }
        return this.buttonColor;
    }

    public void setButtonColor(Color buttonColor) {
        this.buttonColor = buttonColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public List getPersonalDbxrefs() {
        return this.personalDbxrefs;
    }

    public void setPersonalDbxrefs(List personalDbxrefs) {
        this.personalDbxrefs = personalDbxrefs;
    }

    public String getPersonalDefinition() {
        return this.defaultDef;
    }

    public void setPersonalDefinition(String defaultDef) {
        this.defaultDef = defaultDef;
    }

    public boolean getUsePersonalDefinition() {
        return this.usePersonalDefinition;
    }

    public void setUsePersonalDefinition(boolean usePersonalDefinition) {
        this.usePersonalDefinition = usePersonalDefinition;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public static Icon loadLibraryIcon(String name) {
        return preferences.loadLibraryIconLocal(name);
    }

    public static URL getLibraryIconURL(String name) {
        URL url = Controller.getController().getExtensionLoader().getResource("org/geneontology/oboedit/gui/resources/icons/" + name);
        return url;
    }

    public static Font defaultFont() {
        return preferences.getFont();
    }

    public static Color lightSelectionColor() {
        return preferences.getLightSelectionColor();
    }

    public static Color defaultSelectionColor() {
        return preferences.getSelectionColor();
    }

    public static Color defaultBackgroundColor() {
        return preferences.getBackgroundColor();
    }

    public static Color defaultButtonColor() {
        if (Controller.isMacOS()) {
            return Preferences.defaultBackgroundColor();
        }
        return preferences.getButtonColor();
    }

    public static Font decodeFont(String fontName, String fontSize, String fontType) {
        if (fontName == null || fontSize == null || fontType == null) {
            return null;
        }
        try {
            int style = 0;
            if (fontType.equalsIgnoreCase("bold")) {
                style = 1;
            } else if (fontType.equalsIgnoreCase("italic")) {
                style = 2;
            } else if (fontType.equalsIgnoreCase("bolditalic")) {
                style = 3;
            }
            Font out = new Font(fontName, style, Integer.parseInt(fontSize));
            return out;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

