/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Component;
import java.awt.Font;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.history.CyclicHistoryItem;
import org.geneontology.oboedit.datamodel.history.SymmetricHistoryItem;
import org.geneontology.oboedit.datamodel.history.TransitiveHistoryItem;
import org.geneontology.oboedit.gui.AbstractTextEditComponent;
import org.geneontology.oboedit.gui.Controller;

public class PropertyBoxesEditorComponent
extends AbstractTextEditComponent {
    private static final long serialVersionUID = -7582537527616617731L;
    protected JCheckBox transitivityCheckbox = new JCheckBox("Is transitive?");
    protected JCheckBox symmetricalCheckbox = new JCheckBox("Is symmetric?");
    protected JCheckBox cyclicalCheckbox = new JCheckBox("Is cyclic?");

    public PropertyBoxesEditorComponent() {
        this.transitivityCheckbox.setOpaque(false);
        this.symmetricalCheckbox.setOpaque(false);
        this.cyclicalCheckbox.setOpaque(false);
    }

    protected void loadGUI() {
        if (this.currentObject != null && this.currentObject instanceof OBOProperty) {
            OBOProperty prop = (OBOProperty)this.currentObject;
            this.transitivityCheckbox.setSelected(prop.isTransitive());
            this.symmetricalCheckbox.setSelected(prop.isSymmetric());
            this.cyclicalCheckbox.setSelected(prop.isCyclic());
        } else {
            this.transitivityCheckbox.setSelected(false);
            this.symmetricalCheckbox.setSelected(false);
            this.cyclicalCheckbox.setSelected(false);
        }
    }

    public void populateFields(IdentifiedObject io) {
        if (io instanceof OBOProperty) {
            OBOProperty prop = (OBOProperty)io;
            prop.setTransitive(this.transitivityCheckbox.isSelected());
            prop.setSymmetric(this.symmetricalCheckbox.isSelected());
            prop.setCyclic(this.cyclicalCheckbox.isSelected());
        }
    }

    public List getChanges() {
        if (this.currentObject != null && this.currentObject instanceof OBOProperty) {
            OBOProperty prop = (OBOProperty)this.currentObject;
            LinkedList<HistoryItem> out = new LinkedList<HistoryItem>();
            if (prop.isTransitive() != this.transitivityCheckbox.isSelected()) {
                out.add(new TransitiveHistoryItem(prop));
            }
            if (prop.isSymmetric() != this.symmetricalCheckbox.isSelected()) {
                out.add(new SymmetricHistoryItem(prop));
            }
            if (prop.isCyclic() != this.cyclicalCheckbox.isSelected()) {
                out.add(new CyclicHistoryItem(prop));
            }
            return out;
        }
        return Collections.EMPTY_LIST;
    }

    public Component resolveName(String id, Properties props, String xml) {
        if (id.equals("transitivity_checkbox")) {
            return this.transitivityCheckbox;
        }
        if (id.equals("symmetrical_checkbox")) {
            return this.symmetricalCheckbox;
        }
        if (id.equals("cyclical_checkbox")) {
            return this.cyclicalCheckbox;
        }
        return new JButton(id);
    }

    protected void initializeGUI() {
        Font font = Controller.getController().getDefaultFont();
        this.transitivityCheckbox.setFont(font);
        this.symmetricalCheckbox.setFont(font);
        this.cyclicalCheckbox.setFont(font);
    }

    protected boolean useSubLayout() {
        return true;
    }

    protected String getDefaultLayout() {
        return "<box orientation='HORZ'><glue/><component id='transitivity_checkbox'/><spacer orientation='horz' size='20'/><component id='symmetrical_checkbox'/><spacer orientation='horz' size='20'/><component id='cyclical_checkbox'/><glue/></box>";
    }

    protected String getWarningLabel() {
        return "";
    }

    public String getID() {
        return "PROPERTY_BOXES_EDITOR";
    }
}

