/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JTextArea;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymedObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.AddDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.AddSynonymHistoryItem;
import org.geneontology.oboedit.datamodel.history.ChangeSynCategoryHistoryItem;
import org.geneontology.oboedit.datamodel.history.ChangeSynScopeHistoryItem;
import org.geneontology.oboedit.datamodel.history.DelDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.DelSynonymHistoryItem;
import org.geneontology.oboedit.gui.AbstractTextEditComponent;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.SynonymListEditor;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;

public class SynonymEditorComponent
extends AbstractTextEditComponent {
    private static final long serialVersionUID = 1L;
    protected ListEditor synonymList;
    protected SynonymListEditor synonymEditor;

    public Component resolveName(String id, Properties props, String xml) {
        return null;
    }

    public SynonymEditorComponent() {
        this.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        JTextArea noSynLabel = new JTextArea("Select a dbxref from the list to edit it, or press add to create a new dbxref");
        noSynLabel.setMinimumSize(new Dimension(0, 0));
        noSynLabel.setOpaque(false);
        noSynLabel.setFont(Controller.getController().getDefaultFont());
        noSynLabel.setLineWrap(true);
        noSynLabel.setWrapStyleWord(true);
        noSynLabel.setEditable(false);
        noSynLabel.setEnabled(false);
        this.synonymEditor = new SynonymListEditor(Controller.getController());
        this.synonymList = new ListEditor((GenericEditorComponent)this.synonymEditor, (Component)noSynLabel, new Vector(0), true, true, true, true, true);
        this.synonymList.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.synonymList);
    }

    protected boolean useSubLayout() {
        return false;
    }

    protected String getDefaultLayout() {
        return null;
    }

    protected void loadGUI() {
        if (this.currentObject != null && this.currentObject instanceof SynonymedObject) {
            boolean enable = !TermUtil.isObsolete(this.currentObject);
            Vector<Object> refs = new Vector<Object>();
            Iterator it = ((SynonymedObject)this.currentObject).getSynonyms().iterator();
            while (it.hasNext()) {
                Synonym s = (Synonym)it.next();
                refs.add(s.clone());
            }
            Collections.sort(refs);
            this.synonymList.setData(refs);
            this.synonymList.setEnabled(enable);
        } else {
            this.synonymList.setData(new Vector());
            this.synonymList.setEnabled(false);
        }
    }

    protected void initializeGUI() {
        this.synonymList.setButtonColor(Controller.getController().getPreferences().getButtonColor());
        Font font = Controller.getController().getDefaultFont();
        this.synonymList.setFont(font);
    }

    public String getID() {
        return "SYNONYM_EDITOR";
    }

    public void populateFields(IdentifiedObject io) {
        if (io instanceof SynonymedObject) {
            this.synonymList.commit();
            ((SynonymedObject)io).getSynonyms().clear();
            ((SynonymedObject)io).getSynonyms().addAll(this.synonymList.getData());
        }
    }

    public List getChanges() {
        if (this.currentObject != null && this.currentObject instanceof SynonymedObject) {
            Synonym eref;
            Iterator it2;
            boolean found;
            Synonym ref;
            this.synonymList.commit();
            SynonymedObject synonymed = (SynonymedObject)this.currentObject;
            LinkedList<HistoryItem> out = new LinkedList<HistoryItem>();
            Iterator it = synonymed.getSynonyms().iterator();
            while (it.hasNext()) {
                ref = (Synonym)it.next();
                found = false;
                it2 = this.synonymList.getData().iterator();
                while (it2.hasNext()) {
                    eref = (Synonym)it2.next();
                    if (!ref.equals(eref)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (ref.getScope() != 0) {
                    ChangeSynScopeHistoryItem sitem = new ChangeSynScopeHistoryItem(synonymed, ref, 0);
                    out.add(sitem);
                }
                if (ref.getSynonymCategory() != null) {
                    ChangeSynCategoryHistoryItem citem = new ChangeSynCategoryHistoryItem(synonymed, ref, null);
                    out.add(citem);
                }
                Iterator it3 = ref.getDbxrefs().iterator();
                while (it3.hasNext()) {
                    Dbxref xref = (Dbxref)it3.next();
                    DelDbxrefHistoryItem ritem = new DelDbxrefHistoryItem(synonymed.getID(), xref, false, ref.getText());
                    out.add(ritem);
                }
                DelSynonymHistoryItem item = new DelSynonymHistoryItem(synonymed.getID(), ref.getText());
                out.add(item);
            }
            it = this.synonymList.getData().iterator();
            while (it.hasNext()) {
                ref = (Synonym)it.next();
                found = false;
                it2 = synonymed.getSynonyms().iterator();
                while (it2.hasNext()) {
                    eref = (Synonym)it2.next();
                    if (!ref.equals(eref)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                AddSynonymHistoryItem item = new AddSynonymHistoryItem(synonymed.getID(), ref.getText());
                out.add(item);
                Iterator it3 = ref.getDbxrefs().iterator();
                while (it3.hasNext()) {
                    Dbxref xref = (Dbxref)it3.next();
                    AddDbxrefHistoryItem ritem = new AddDbxrefHistoryItem(synonymed.getID(), xref, false, ref.getText());
                    out.add(ritem);
                }
                if (ref.getSynonymCategory() != null) {
                    ChangeSynCategoryHistoryItem citem = new ChangeSynCategoryHistoryItem(synonymed, ref, ref.getSynonymCategory());
                    out.add(citem);
                }
                if (ref.getScope() == 0) continue;
                ChangeSynScopeHistoryItem sitem = new ChangeSynScopeHistoryItem(synonymed, ref, ref.getScope());
                out.add(sitem);
            }
            System.err.println("synonym edits = " + out);
            return out;
        }
        return Collections.EMPTY_LIST;
    }
}

