/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TextIcon
implements Icon {
    private static JComponent tempComponent = new JPanel();
    private String text;
    private Font font;
    private FontMetrics metrics;
    private Color foreground;
    private Color background;
    private int iconWidth;
    private int iconHeight;

    public TextIcon(String text) {
        this.setText(text, false);
        this.setFont(new Font("Arial", 0, 9), false);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.recalculateBounds();
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setFont(Font font) {
        this.setFont(font, true);
    }

    private void setFont(Font font, boolean recalculateBounds) {
        this.font = font;
        this.metrics = tempComponent.getFontMetrics(font);
        if (recalculateBounds) {
            this.recalculateBounds();
        }
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    private void setText(String text, boolean recalculateBounds) {
        this.text = text;
        if (recalculateBounds) {
            this.recalculateBounds();
        }
    }

    protected void recalculateBounds() {
        this.iconWidth = 2 + this.metrics.stringWidth(this.text);
        this.iconHeight = 2 + this.metrics.getHeight();
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color oldColor = g.getColor();
        Font oldFont = g.getFont();
        g.setFont(this.font);
        if (this.background != null) {
            g.setColor(this.background);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
        }
        g.setColor(this.foreground);
        g.drawString(this.text, x + 1, y + this.iconHeight - 2);
        g.setFont(oldFont);
        g.setColor(oldColor);
    }
}

