/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.AddDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.CreateObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.DefinitionChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.NamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;

public class AddAction
implements ClickMenuAction {
    protected LinkedObject target;
    protected TreePath dest;
    protected boolean isLegal = false;
    protected Controller controller;

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public KeyStroke getKeyStroke() {
        return null;
    }

    public String getName() {
        return "Create new child";
    }

    public String getDesc() {
        return "Create new child";
    }

    public List getSubActions() {
        return null;
    }

    public void clickInit(TreePath[] paths, TreePath destItem) {
        this.isLegal = false;
        if (paths != null && paths.length == 1 && paths[0].getLastPathComponent() instanceof Link) {
            this.target = ((Link)paths[0].getLastPathComponent()).getChild();
            this.dest = paths[0];
            if (!TermUtil.isObsolete(this.target)) {
                this.isLegal = true;
            }
        }
    }

    protected String getTypeID() {
        String id = JOptionPane.showInputDialog("Please input an id");
        if (id == null || id.length() == 0) {
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "Cannot create a new type without an id");
            return null;
        }
        if (this.controller.getSession().getTerm(id) != null) {
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "Id " + id + " already in use!");
            return null;
        }
        if (!TermUtil.isLegalID(id)) {
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "Id " + id + " contains illegal characters");
            return null;
        }
        return id;
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        String id = null;
        id = TermUtil.isProperty(this.target) ? this.getTypeID() : TermUtil.fetchID(this.controller, this.target);
        if (id == null || id.trim().length() == 0) {
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "Could not generate ID! Action cancelled.");
            return null;
        }
        TreePath[] postSelection = new TreePath[]{TermUtil.convertPathToIDs(this.dest).pathByAddingChild(new HistoryItem.StringRelationship(this.target.getID(), id, OBOProperty.IS_A.getID()))};
        TreePath[] preSelection = new TreePath[]{TermUtil.convertPathToIDs(this.dest)};
        TermMacroHistoryItem item = new TermMacroHistoryItem("Add new child to " + this.target);
        item.addHistoryItem(new CreateObjectHistoryItem(id, this.target.getType().getID()));
        item.addHistoryItem(new TermCopyHistoryItem(this.target.getID(), id, OBOProperty.IS_A.getID()));
        Namespace ns = this.target.getNamespace();
        if (ns == null) {
            ns = this.controller.getSession().getDefaultNamespace();
        }
        if (ns != null) {
            item.addHistoryItem(new NamespaceHistoryItem(null, ns, id));
        }
        if (Controller.getController().getPreferences().getUsePersonalDefinition()) {
            item.addHistoryItem(new DefinitionChangeHistoryItem(null, Controller.getController().getPreferences().getPersonalDefinition(), id));
            Iterator it = Controller.getController().getPreferences().getPersonalDbxrefs().iterator();
            while (it.hasNext()) {
                Dbxref ref = (Dbxref)it.next();
                item.addHistoryItem(new AddDbxrefHistoryItem(id, ref, true, null));
            }
        }
        item.setTarget(this.target.getID());
        item.setResult(id);
        item.setPreSelection(preSelection);
        item.setPostSelection(postSelection);
        return item;
    }
}

