/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.AnnotatedObject;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DefaultInputHandler;
import org.geneontology.oboedit.gui.DropMenuAction;
import org.geneontology.oboedit.gui.InputHandlerI;
import org.geneontology.oboedit.gui.OBOTermPanel;
import org.geneontology.oboedit.gui.actions.SpecificMoveAction;
import org.geneontology.swing.KeyRecorder;

public class MoveAction
implements ClickMenuAction,
DropMenuAction,
InputHandlerI {
    protected Controller controller;
    protected TreePath[] preSelection;
    protected TreePath destPath;
    protected LinkedObject target;
    protected List actionList = new Vector();
    protected OBOProperty type;
    protected boolean useOriginalType = false;
    protected boolean isLegal = false;
    protected JPopupMenu dragMenu = new JPopupMenu();
    protected SpecificMoveAction copyOriginalType = new SpecificMoveAction(null, true);
    protected static Comparator moveActionSorter = new Comparator(){

        public int compare(Object a, Object b) {
            SpecificMoveAction sa = (SpecificMoveAction)a;
            SpecificMoveAction sb = (SpecificMoveAction)b;
            if (sa.getUseOriginalType() && sb.getUseOriginalType()) {
                return 0;
            }
            if (sa.getUseOriginalType()) {
                return -1;
            }
            if (sb.getUseOriginalType()) {
                return 1;
            }
            return sa.getType().getID().compareToIgnoreCase(sb.getType().getID());
        }
    };

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public KeyStroke getKeyStroke() {
        return null;
    }

    public String getName() {
        return "Move";
    }

    public String getDesc() {
        return "Move";
    }

    public List getSubActions() {
        this.actionList.clear();
        this.actionList.add(new SpecificMoveAction(this.type, true));
        Iterator it = this.controller.getSession().getRelationshipTypes().iterator();
        while (it.hasNext()) {
            OBOProperty type = (OBOProperty)it.next();
            this.actionList.add(new SpecificMoveAction(type, false));
        }
        Collections.sort(this.actionList, moveActionSorter);
        return this.actionList;
    }

    public int allowDrop(OBOTermPanel sourcePanel, OBOTermPanel dropPanel, Controller controller, Object o, TreePath dest, MouseEvent e, KeyRecorder.KeyChecker keyChecker) {
        if (o instanceof TreePath[] && keyChecker.isDown(88)) {
            this.useOriginalType = keyChecker.isDown(16);
            this.dropInit((TreePath[])o, dest);
            sourcePanel.setDragTitle("Move" + (this.useOriginalType ? " (original type)" : "..."));
            if (this.isLegal()) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean drop(OBOTermPanel panel, OBOTermPanel dropPanel, Controller controller, Object o, TreePath dest, MouseEvent e, KeyRecorder.KeyChecker keyChecker) {
        if (!(o instanceof TreePath[]) || !keyChecker.isDown(88)) return false;
        this.useOriginalType = keyChecker.isDown(16);
        this.type = null;
        this.dropInit((TreePath[])o, dest);
        if (!this.isLegal()) {
            return false;
        }
        if (this.useOriginalType) {
            this.copyOriginalType.clickInit((TreePath[])o, dest);
            HistoryItem executeItem = null;
            if (this.copyOriginalType.isLegal()) {
                executeItem = this.copyOriginalType.execute();
            }
            if (executeItem == null) return false;
            controller.apply(executeItem);
            return true;
        } else {
            this.dragMenu.removeAll();
            DefaultInputHandler.buildMenu(this.dragMenu, this.getSubActions(), controller, (TreePath[])o, dest, false, true, true);
            Point p = SwingUtilities.convertPoint(panel, e.getX(), e.getY(), dropPanel);
            this.dragMenu.show(dropPanel, (int)p.getX(), (int)p.getY());
        }
        return true;
    }

    public boolean click(OBOTermPanel panel, Controller controller, TreePath dest, MouseEvent e, KeyRecorder.KeyChecker keyChecker) {
        return false;
    }

    public boolean press(OBOTermPanel panel, Controller controller, KeyEvent e, KeyRecorder.KeyChecker keyChecker) {
        return false;
    }

    public void clickInit(TreePath[] sourceItems, TreePath destItem) {
        this.init(sourceItems, destItem);
    }

    public void dropInit(TreePath[] sourceItems, TreePath destItem) {
        this.init(sourceItems, destItem);
    }

    public void init(TreePath[] sourceItems, TreePath destItem) {
        this.preSelection = sourceItems;
        this.destPath = destItem;
        if (sourceItems.length < 1 || this.destPath == null || !(this.destPath.getLastPathComponent() instanceof Link)) {
            this.isLegal = false;
            return;
        }
        this.target = ((Link)this.destPath.getLastPathComponent()).getChild();
        if (this.target instanceof AnnotatedObject && ((AnnotatedObject)((Object)this.target)).isObsolete()) {
            this.isLegal = false;
            return;
        }
        for (int i = 0; i < sourceItems.length; ++i) {
            if (!(sourceItems[i].getLastPathComponent() instanceof Link)) {
                this.isLegal = false;
                return;
            }
            Link tr = (Link)sourceItems[i].getLastPathComponent();
            if (!TermUtil.isObsolete(tr.getChild()) && TermUtil.isProperty(tr.getChild()) == TermUtil.isProperty(this.target) && !TermUtil.hasChild(this.target, tr) && (this.controller.allowCycles() || !tr.getChild().equals(this.target)) && (this.controller.allowCycles() || !TermUtil.isDescendant(tr.getChild(), this.target))) continue;
            this.isLegal = false;
            return;
        }
        this.isLegal = true;
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        return null;
    }
}

