/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.util.List;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMoveHistoryItem;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;

public class SpecificMoveAction
implements ClickMenuAction {
    protected boolean useOriginalType;
    protected OBOProperty type;
    protected TreePath[] sources;
    protected TreePath dest;
    protected boolean isLegal = false;
    protected Controller controller;

    public SpecificMoveAction(OBOProperty type, boolean useOriginalType) {
        this.type = type;
        this.useOriginalType = useOriginalType;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public KeyStroke getKeyStroke() {
        return null;
    }

    public OBOProperty getType() {
        return this.type;
    }

    public boolean getUseOriginalType() {
        return this.useOriginalType;
    }

    public String getName() {
        if (this.useOriginalType) {
            return "Use original type";
        }
        return this.type.toString();
    }

    public String getDesc() {
        return this.getName();
    }

    public List getSubActions() {
        return null;
    }

    protected Link getTR(LinkedObject target, LinkedObject copied, OBOProperty type) {
        return new OBORestrictionImpl(copied, target, type);
    }

    public void clickInit(TreePath[] paths, TreePath destItem) {
        LinkedObject target = null;
        if (destItem == null) {
            this.isLegal = false;
            return;
        }
        if (!(destItem.getLastPathComponent() instanceof Link)) {
            this.isLegal = false;
            return;
        }
        this.dest = destItem;
        target = ((Link)destItem.getLastPathComponent()).getChild();
        if (paths != null) {
            this.sources = paths;
            for (int i = 0; i < paths.length; ++i) {
                if (!(paths[i].getLastPathComponent() instanceof Link)) {
                    this.isLegal = false;
                    return;
                }
                Link tr = (Link)paths[i].getLastPathComponent();
                if (!this.useOriginalType && tr.getType() == null) {
                    this.isLegal = false;
                    return;
                }
                if (this.useOriginalType) {
                    this.type = tr.getType();
                }
                if (this.type == null) {
                    this.isLegal = false;
                    return;
                }
                Link newtr = this.getTR(target, tr.getChild(), this.type);
                if (TermUtil.isLegalRelationship(newtr.getChild(), newtr.getType(), newtr.getParent())) continue;
                this.isLegal = false;
                return;
            }
            this.isLegal = true;
        } else {
            this.isLegal = false;
        }
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        HistoryItem item;
        Vector<TermMoveHistoryItem> historyList = new Vector<TermMoveHistoryItem>();
        Vector<TreePath> pathouts = new Vector<TreePath>();
        LinkedObject target = ((Link)this.dest.getLastPathComponent()).getChild();
        for (int i = 0; i < this.sources.length; ++i) {
            Link tr = (Link)this.sources[i].getLastPathComponent();
            if (this.useOriginalType) {
                this.type = tr.getType();
            }
            Link newtr = this.getTR(target, tr.getChild(), this.type);
            historyList.add(new TermMoveHistoryItem(target, this.type, tr));
            TreePath outpath = this.dest.pathByAddingChild(newtr);
            pathouts.add(TermUtil.convertPathToIDs(outpath));
        }
        if (historyList.size() == 1) {
            item = (HistoryItem)historyList.get(0);
        } else {
            item = new TermMacroHistoryItem("Moved terms");
            for (int i = 0; i < historyList.size(); ++i) {
                ((TermMacroHistoryItem)item).addHistoryItem((HistoryItem)historyList.get(i));
            }
        }
        TreePath[] outpatharr = new TreePath[pathouts.size()];
        for (int i = 0; i < outpatharr.length; ++i) {
            outpatharr[i] = (TreePath)pathouts.get(i);
        }
        item.setPreSelection(TermUtil.convertPathsToIDs(this.sources));
        item.setPostSelection(outpatharr);
        return item;
    }
}

