/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.LinkTypeHistoryItem;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DropMenuAction;
import org.geneontology.oboedit.gui.InputHandlerI;
import org.geneontology.oboedit.gui.OBOTermPanel;
import org.geneontology.oboedit.gui.actions.SpecificTypeChangeAction;
import org.geneontology.swing.KeyRecorder;

public class TypeChangeAction
implements ClickMenuAction,
DropMenuAction,
InputHandlerI {
    protected TreePath dest;
    protected boolean fromDrop = false;
    protected boolean isLegal = false;
    protected Controller controller;
    protected OBOProperty dropType;
    protected List actionList = new Vector();
    protected Comparator typeChangeActionSorter = new Comparator(){

        public int compare(Object a, Object b) {
            SpecificTypeChangeAction sa = (SpecificTypeChangeAction)a;
            SpecificTypeChangeAction sb = (SpecificTypeChangeAction)b;
            return sa.getType().getID().compareToIgnoreCase(sb.getType().getID());
        }
    };

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public int allowDrop(OBOTermPanel sourcePanel, OBOTermPanel dropPanel, Controller controller, Object o, TreePath dest, MouseEvent e, KeyRecorder.KeyChecker keyChecker) {
        if (o instanceof TreePath[] && keyChecker.isDown(84)) {
            TreePath[] paths = (TreePath[])o;
            if (paths.length != 1 || !(paths[0].getLastPathComponent() instanceof Link) || !TermUtil.isProperty(((Link)paths[0].getLastPathComponent()).getChild()) || TermUtil.isObsolete(((Link)paths[0].getLastPathComponent()).getChild())) {
                return 0;
            }
            sourcePanel.setDragTitle("Setting type...");
            if (dest == null || !(dest.getLastPathComponent() instanceof Link)) {
                return 1;
            }
            Link tr = (Link)paths[0].getLastPathComponent();
            Link destTR = (Link)dest.getLastPathComponent();
            if (!TermUtil.isProperty(tr.getChild())) {
                return 1;
            }
            if (destTR.getType() == null) {
                return 1;
            }
            if (!destTR.getType().equals(tr.getChild())) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public boolean drop(OBOTermPanel sourcePanel, OBOTermPanel dropPanel, Controller controller, Object o, TreePath dest, MouseEvent e, KeyRecorder.KeyChecker keyChecker) {
        TreePath[] sources = (TreePath[])o;
        Link tr = (Link)dest.getLastPathComponent();
        OBOProperty type = (OBOProperty)((Link)sources[0].getLastPathComponent()).getChild();
        TreePath outpath = dest.getParentPath().pathByAddingChild(new OBORestrictionImpl(tr.getChild(), tr.getParent(), type));
        TreePath[] post = new TreePath[]{outpath};
        LinkTypeHistoryItem item = new LinkTypeHistoryItem(tr, type);
        item.setPreSelection(sources);
        item.setPostSelection(post);
        controller.apply(item);
        return true;
    }

    public boolean click(OBOTermPanel panel, Controller controller, TreePath dest, MouseEvent e, KeyRecorder.KeyChecker keyChecker) {
        return false;
    }

    public boolean press(OBOTermPanel panel, Controller controller, KeyEvent e, KeyRecorder.KeyChecker keyChecker) {
        return false;
    }

    public KeyStroke getKeyStroke() {
        return null;
    }

    public String getName() {
        return "Change relationship type";
    }

    public boolean isDropAllowed() {
        return true;
    }

    public boolean isClickAllowed() {
        return true;
    }

    public String getDesc() {
        return "Change relationship type";
    }

    public List getSubActions() {
        if (this.fromDrop) {
            return null;
        }
        this.actionList.clear();
        Iterator it = this.controller.getSession().getRelationshipTypes().iterator();
        while (it.hasNext()) {
            OBOProperty type = (OBOProperty)it.next();
            this.actionList.add(new SpecificTypeChangeAction(type));
        }
        Collections.sort(this.actionList, this.typeChangeActionSorter);
        return this.actionList;
    }

    public void clickInit(TreePath[] paths, TreePath destItem) {
        this.fromDrop = false;
        this.dest = destItem;
        if (paths == null || paths.length < 1) {
            this.isLegal = false;
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            if (!(paths[i].getLastPathComponent() instanceof Link)) {
                this.isLegal = false;
                return;
            }
            Link tr = (Link)paths[i].getLastPathComponent();
            if (!TermUtil.isFake(tr)) continue;
            this.isLegal = false;
            return;
        }
        this.isLegal = true;
    }

    public void dropInit(TreePath[] paths, TreePath destItem) {
        this.fromDrop = true;
        this.dest = destItem;
        if (paths == null || paths.length < 1) {
            this.isLegal = false;
            return;
        }
        if (destItem == null) {
            this.isLegal = false;
            return;
        }
        if (paths.length != 1 || !(paths[0].getLastPathComponent() instanceof Link)) {
            this.isLegal = false;
            return;
        }
        if (!(destItem.getLastPathComponent() instanceof Link)) {
            this.isLegal = false;
            return;
        }
        Link tr = (Link)destItem.getLastPathComponent();
        if (tr.getType() == null) {
            this.isLegal = false;
            return;
        }
        Link dropTR = (Link)paths[0].getLastPathComponent();
        if (!TermUtil.isProperty(dropTR.getChild())) {
            this.isLegal = false;
            return;
        }
        this.dropType = (OBOProperty)dropTR.getChild();
        if (tr.getType().equals(this.dropType)) {
            this.isLegal = false;
            return;
        }
        this.isLegal = true;
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        if (this.fromDrop) {
            Link tr = (Link)this.dest.getLastPathComponent();
            TreePath outpath = this.dest.getParentPath().pathByAddingChild(new OBORestrictionImpl(tr.getChild(), tr.getParent(), this.dropType));
            LinkTypeHistoryItem item = new LinkTypeHistoryItem(tr, this.dropType);
            TreePath[] pre = new TreePath[]{TermUtil.convertPathToIDs(this.dest)};
            TreePath[] post = new TreePath[]{TermUtil.convertPathToIDs(outpath)};
            item.setPreSelection(pre);
            item.setPostSelection(post);
            return item;
        }
        return null;
    }
}

