/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.event;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOProperty;

public abstract class TermHyperlinkListener
implements HyperlinkListener {
    protected LinkDatabase linkDatabase;

    public void setLinkDatabase(LinkDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            if (!e.getURL().getProtocol().equals("file")) {
                return;
            }
            String path = e.getURL().getPath();
            Pattern paramPattern = Pattern.compile("(\\S+?)\\((\\S+?)\\)-(.+)");
            String linkType = null;
            String linkParam = null;
            String linkVal = null;
            Matcher m = paramPattern.matcher(path);
            if (m.matches()) {
                linkType = m.group(1);
                linkParam = m.group(2);
                linkVal = m.group(3);
            } else {
                Pattern noParamPattern = Pattern.compile("(\\S+?)-(.+?)");
                m = noParamPattern.matcher(path);
                if (m.matches()) {
                    linkType = m.group(1);
                    linkVal = m.group(2);
                } else {
                    return;
                }
            }
            System.err.println("linkType = " + linkType);
            System.err.println("linkParam = " + linkParam);
            System.err.println("linkVal = " + linkVal);
            if (linkType.equals("term")) {
                IdentifiedObject io = this.linkDatabase.getObject(linkVal.replaceAll("%3A", ":"));
                if (io != null) {
                    this.termSelected(linkParam, io);
                }
            } else if (linkType.equals("link")) {
                String childID = null;
                String parentID = null;
                String typeID = null;
                StringBuffer temp = new StringBuffer();
                for (int i = 0; i < linkVal.length(); ++i) {
                    char c = linkVal.charAt(i);
                    if (c == '-') {
                        if (childID == null) {
                            childID = temp.toString().replaceAll("%3A", ":");
                        } else if (typeID == null) {
                            typeID = temp.toString().replaceAll("%3A", ":");
                        }
                        temp = new StringBuffer();
                        continue;
                    }
                    if (c == '\\') {
                        c = linkVal.charAt(++i);
                        temp.append(c);
                        continue;
                    }
                    temp.append(c);
                }
                parentID = temp.toString().replaceAll("%3A", ":");
                IdentifiedObject io = this.linkDatabase.getObject(childID);
                if (!(io instanceof LinkedObject)) {
                    return;
                }
                LinkedObject child = (LinkedObject)io;
                io = this.linkDatabase.getObject(parentID);
                if (!(io instanceof LinkedObject)) {
                    return;
                }
                LinkedObject parent = (LinkedObject)io;
                io = this.linkDatabase.getObject(typeID);
                if (!(io instanceof OBOProperty)) {
                    return;
                }
                LinkedObject type = (LinkedObject)io;
                Iterator it = this.linkDatabase.getParents(child).iterator();
                while (it.hasNext()) {
                    Link link = (Link)it.next();
                    if (!link.getParent().equals(parent) || !link.getType().equals(type)) continue;
                    this.linkSelected(linkParam, link);
                    return;
                }
            } else if (linkType.equals("action")) {
                this.actionSelected(linkParam, linkVal);
            }
        }
    }

    public abstract void actionSelected(String var1, String var2);

    public abstract void termSelected(String var1, IdentifiedObject var2);

    public abstract void linkSelected(String var1, Link var2);
}

