/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.filters;

import java.util.Collection;
import java.util.Iterator;
import org.geneontology.oboedit.gui.filters.AbstractComparison;

public class EqualsComparison
extends AbstractComparison {
    protected Class[] types = new Class[]{String.class, Number.class};

    public Class[] getAcceptedTypes() {
        return this.types;
    }

    public String getID() {
        return "=";
    }

    public boolean matches(Collection testVals, String value) {
        if (value == null) {
            value = "";
        }
        Double intVal = null;
        try {
            intVal = new Double(value);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        Iterator it = testVals.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            boolean returnVal = false;
            if (o instanceof Number && intVal != null) {
                returnVal = o.equals(intVal);
            } else if (o instanceof String) {
                returnVal = ((String)o).equalsIgnoreCase(value);
            }
            if (!returnVal) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "equals";
    }
}

