/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.geneontology.oboedit.datamodel.AnnotatedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermNamespaceHistoryItem;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.event.RefreshEvent;
import org.geneontology.oboedit.gui.event.RefreshListener;
import org.geneontology.oboedit.gui.event.RootChangeEvent;
import org.geneontology.oboedit.gui.event.RootChangeListener;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;

public class NamespaceManagerPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    protected ListEditor nsList;
    protected JLabel noNamespaceLabel = new JLabel("Click a namespace to edit it.");
    protected JButton commitButton = new JButton("Save Changes");
    protected JButton revertButton = new JButton("Revert");
    protected RefreshListener reloadListener = new RefreshListener(){

        public void reload(RefreshEvent e) {
            NamespaceManagerPlugin.this.loadNamespaces();
        }
    };
    protected RootChangeListener rootListener = new RootChangeListener(){

        public void changeRoot(RootChangeEvent e) {
            NamespaceManagerPlugin.this.loadNamespaces();
        }
    };

    public String getName() {
        return "Namespace Manager Plugin";
    }

    public void init() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setPreferredSize(new Dimension(400, 300));
        this.nsList = new ListEditor((GenericEditorComponent)new NamespaceEditor(), (Component)this.noNamespaceLabel, new Vector(), true, true, true, true, false);
        Box commitBox = new Box(0);
        commitBox.add(Box.createHorizontalGlue());
        commitBox.add(this.commitButton);
        commitBox.add(Box.createHorizontalStrut(10));
        commitBox.add(this.revertButton);
        commitBox.add(Box.createHorizontalGlue());
        this.commitButton.setFont(this.controller.getDefaultFont());
        this.revertButton.setFont(this.controller.getDefaultFont());
        this.noNamespaceLabel.setFont(this.controller.getDefaultFont());
        this.commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NamespaceManagerPlugin.this.saveNamespaces();
            }
        });
        this.revertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NamespaceManagerPlugin.this.loadNamespaces();
            }
        });
        this.nsList.setFont(this.controller.getDefaultFont());
        this.removeAll();
        this.add((Component)this.nsList);
        this.add(commitBox);
        this.validate();
        this.controller.addListener(this.reloadListener);
        this.controller.addListener(this.rootListener);
        this.loadNamespaces();
    }

    public void cleanup() {
        this.controller.removeListener(this.reloadListener);
        this.controller.removeListener(this.rootListener);
    }

    protected void loadNamespaces() {
        Vector<NamespaceWrapper> v = new Vector<NamespaceWrapper>();
        Iterator it = this.controller.getSession().getNamespaces().iterator();
        while (it.hasNext()) {
            Namespace ns = (Namespace)it.next();
            v.add(new NamespaceWrapper(ns));
        }
        this.nsList.setData(v);
    }

    protected boolean isInUse(Namespace ns) {
        Iterator it2 = this.controller.getSession().getAnnotatedObjects().iterator();
        boolean inUse = false;
        block0: while (it2.hasNext()) {
            AnnotatedObject term = (AnnotatedObject)it2.next();
            if (term.getNamespace() != null && term.getNamespace().equals(ns)) {
                inUse = true;
                break;
            }
            if (!(term instanceof LinkedObject)) continue;
            Iterator it = ((LinkedObject)((Object)term)).getParents().iterator();
            while (it.hasNext()) {
                Link tr = (Link)it.next();
                if (tr.getNamespace() == null || !tr.getNamespace().equals(ns)) continue;
                inUse = true;
                continue block0;
            }
        }
        if (this.controller.getSession().getDefaultNamespace().equals(ns)) {
            return true;
        }
        return inUse;
    }

    protected void saveNamespaces() {
        HashSet<NamespaceWrapper> v = new HashSet<NamespaceWrapper>();
        Vector data = this.nsList.getData();
        for (int i = 0; i < data.size(); ++i) {
            NamespaceWrapper ns = (NamespaceWrapper)data.get(i);
            if (v.contains(ns)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Could not commit changes because multiple namespaces are named " + ns);
                return;
            }
            v.add(ns);
        }
        Iterator it = this.controller.getSession().getNamespaces().iterator();
        TermMacroHistoryItem item = new TermMacroHistoryItem("Namespace edits");
        while (it.hasNext()) {
            Namespace ns = (Namespace)it.next();
            boolean removed = true;
            Iterator it2 = v.iterator();
            while (it2.hasNext()) {
                NamespaceWrapper nw = (NamespaceWrapper)it2.next();
                if (nw.getNamespace() == null || !nw.getNamespace().equals(ns)) continue;
                removed = false;
                break;
            }
            if (!removed) continue;
            if (this.isInUse(ns)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Could not commit changes because " + ns + " " + "is still in use in the " + "ontology");
                this.loadNamespaces();
                this.repaint();
                return;
            }
            item.addHistoryItem(new TermNamespaceHistoryItem(ns.getID(), null, false, true));
        }
        it = v.iterator();
        while (it.hasNext()) {
            NamespaceWrapper nw = (NamespaceWrapper)it.next();
            if (nw.getNamespace() == null) {
                item.addHistoryItem(new TermNamespaceHistoryItem(null, nw.getID(), true, false));
                continue;
            }
            item.addHistoryItem(new TermNamespaceHistoryItem(nw.getNamespace().getID(), nw.getID(), false, false));
        }
        item.setPreSelection(this.controller.getSelectedPaths());
        item.setPostSelection(this.controller.getSelectedPaths());
        this.controller.apply(item);
    }

    protected static class NamespaceWrapper {
        Namespace ns;
        String id;

        public NamespaceWrapper(String id) {
            this.ns = null;
            this.id = id;
        }

        public NamespaceWrapper(Namespace ns) {
            this.ns = ns;
            this.id = ns.getID();
        }

        public void setID(String id) {
            this.id = id;
        }

        public String getID() {
            return this.id;
        }

        public Namespace getNamespace() {
            return this.ns;
        }

        public String toString() {
            return this.id;
        }
    }

    private class NamespaceEditor
    extends JPanel
    implements GenericEditorComponent {
        private static final long serialVersionUID = 1L;
        private JTextField idField;
        protected ListEditor editor;

        public void setMasterComponent(Component c) {
            if (c instanceof ListEditor) {
                this.editor = (ListEditor)c;
            }
        }

        public NamespaceEditor() {
            JLabel idLabel = new JLabel("Namespace id");
            FocusListener listener = new FocusListener(){

                public void focusLost(FocusEvent e) {
                    ((NamespaceEditor)NamespaceEditor.this).NamespaceManagerPlugin.this.nsList.commit();
                }

                public void focusGained(FocusEvent e) {
                }
            };
            this.idField = new JTextField(10);
            this.idField.addFocusListener(listener);
            this.idField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ((NamespaceEditor)NamespaceEditor.this).NamespaceManagerPlugin.this.nsList.commit();
                }
            });
            this.idField.setFont(NamespaceManagerPlugin.this.controller.getDefaultFont());
            idLabel.setFont(NamespaceManagerPlugin.this.controller.getDefaultFont());
            this.setLayout(new BoxLayout(this, 1));
            this.add(idLabel);
            this.add(this.idField);
            this.add(Box.createVerticalGlue());
        }

        public void load(Object o) {
            NamespaceWrapper rtw = (NamespaceWrapper)o;
            this.idField.setText(rtw.getID());
        }

        public void store(Object o) {
            NamespaceWrapper rtw = (NamespaceWrapper)o;
            rtw.setID(this.idField.getText());
        }

        public Object createNewValue() {
            return new NamespaceWrapper("<new namespace id>");
        }
    }
}

