/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.geneontology.oboedit.datamodel.impl.FilteredReasonedLinkDatabase;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;
import org.geneontology.util.ReusableProgressEvent;

public class ReasonerPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    protected JProgressBar progressBar = new JProgressBar();
    protected JCheckBox useReasonerCheckbox = new JCheckBox("Use reasoner");
    protected JEditorPane summaryField = new JEditorPane();
    protected JScrollPane summaryScroller = new JScrollPane(this.summaryField, 20, 31);
    protected ActionListener reasonerActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ReasonerPlugin.this.updateProgressPanel(ReasonerPlugin.this.controller.getUseReasoner());
        }
    };
    protected ActionListener reasonerListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ReasonerPlugin.this.enableReasoner(ReasonerPlugin.this.useReasonerCheckbox.isSelected());
        }
    };
    protected BarUpdater barUpdater = new BarUpdater();
    protected ProgressListener progressListener = new ProgressListener(){

        public void progressMade(ProgressEvent e) {
            if (e instanceof ReusableProgressEvent) {
                ReasonerPlugin.this.barUpdater.setEvent((ReusableProgressEvent)e);
                SwingUtilities.invokeLater(ReasonerPlugin.this.barUpdater);
            }
        }
    };

    public ReasonerPlugin() {
        this.progressBar.setStringPainted(true);
        this.setLayout(new BorderLayout());
        this.summaryField.setPreferredSize(new Dimension(300, 200));
        this.summaryField.setContentType("text/html");
        this.setBackground(Preferences.defaultBackgroundColor());
        this.setLayout(new BorderLayout());
        this.useReasonerCheckbox.setOpaque(false);
        this.add(this.useReasonerCheckbox, "South");
        this.summaryField.setEditable(false);
    }

    protected void enableReasoner(boolean enableReasoner) {
        this.controller.setUseReasoner(enableReasoner);
    }

    protected void updateProgressPanel(final boolean enableReasoner) {
        FilteredReasonedLinkDatabase reasoner = this.controller.getReasonedLinkDatabase();
        String text = "<html><body>\n";
        text = text + "Reasoning completed in " + reasoner.getLastReasoningTime() + "ms\n";
        text = text + "<ul>\n";
        text = text + "  <li>Discovered " + reasoner.getNewLinkCount() + " implied links\n";
        text = text + "  <li>Showing " + reasoner.getNewLinks().size() + " implied links\n";
        text = text + "  <li>Found " + reasoner.getRedundantLinks().size() + " redundant links\n";
        text = text + "</ul>\n";
        final String summaryText = text = text + "</body></html>";
        Runnable screenUpdate = new Runnable(){

            public void run() {
                if (enableReasoner) {
                    ReasonerPlugin.this.add(ReasonerPlugin.this.summaryScroller, "Center");
                } else {
                    ReasonerPlugin.this.remove(ReasonerPlugin.this.summaryScroller);
                }
                ReasonerPlugin.this.useReasonerCheckbox.removeActionListener(ReasonerPlugin.this.reasonerListener);
                ReasonerPlugin.this.useReasonerCheckbox.setSelected(enableReasoner);
                ReasonerPlugin.this.useReasonerCheckbox.addActionListener(ReasonerPlugin.this.reasonerListener);
                ReasonerPlugin.this.validate();
                ReasonerPlugin.this.repaint();
                ReasonerPlugin.this.summaryField.setText(summaryText);
            }
        };
        SwingUtilities.invokeLater(screenUpdate);
    }

    public void init() {
        this.progressBar.setFont(this.controller.getDefaultFont());
        this.useReasonerCheckbox.setFont(this.controller.getDefaultFont());
        this.summaryField.setFont(this.controller.getDefaultFont());
        this.controller.getReasonedLinkDatabase().addProgressListener(this.progressListener);
        this.controller.getReasonedLinkDatabase().addActionListener(this.reasonerActionListener);
        this.updateProgressPanel(this.controller.getUseReasoner());
    }

    public String getName() {
        return "Reasoner Plugin";
    }

    public void cleanup() {
        this.controller.getReasonedLinkDatabase().removeProgressListener(this.progressListener);
        this.controller.getReasonedLinkDatabase().removeActionListener(this.reasonerActionListener);
    }

    protected class BarUpdater
    implements Runnable {
        protected ReusableProgressEvent rpe;

        protected BarUpdater() {
        }

        public void run() {
            ReasonerPlugin.this.progressBar.setString(this.rpe.getDescription());
            if (this.rpe.getFastVal() < 0) {
                ReasonerPlugin.this.progressBar.setIndeterminate(true);
            } else {
                ReasonerPlugin.this.progressBar.setIndeterminate(false);
                ReasonerPlugin.this.progressBar.setValue(this.rpe.getFastVal());
            }
            Window w = SwingUtilities.getWindowAncestor((Component)((Object)ReasonerPlugin.this));
            w.repaint();
        }

        public void setEvent(ReusableProgressEvent rpe) {
            this.rpe = rpe;
        }
    }
}

