/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.test;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.tree.TreePath;
import junit.framework.TestCase;
import org.geneontology.oboedit.dataadapter.DefaultIDGenerator;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.impl.NamedIDProfile;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.actions.AddAction;
import org.geneontology.oboedit.test.TestUtil;
import org.geneontology.util.ObjectUtil;

public class AddActionTest
extends TestCase {
    protected Set expectedIDs = new HashSet();

    public AddActionTest() {
        this.expectedIDs.add("GO:0100031");
        this.expectedIDs.add("GO:0000425");
        this.expectedIDs.add("GO:0000407");
        this.expectedIDs.add("GO:0100000");
        this.expectedIDs.add("GO:0000439");
        this.expectedIDs.add("GO:0000403");
        this.expectedIDs.add("GO:0100013");
        this.expectedIDs.add("GO:0100035");
        this.expectedIDs.add("GO:0000429");
        this.expectedIDs.add("GO:0100022");
        this.expectedIDs.add("GO:0000416");
        this.expectedIDs.add("GO:0000402");
        this.expectedIDs.add("GO:0100048");
        this.expectedIDs.add("GO:0000399");
        this.expectedIDs.add("GO:0100026");
        this.expectedIDs.add("GO:0000420");
        this.expectedIDs.add("GO:0000411");
        this.expectedIDs.add("GO:0100007");
        this.expectedIDs.add("GO:0000443");
        this.expectedIDs.add("GO:0100044");
        this.expectedIDs.add("GO:0100016");
        this.expectedIDs.add("GO:0000434");
        this.expectedIDs.add("GO:0100004");
        this.expectedIDs.add("GO:0000424");
        this.expectedIDs.add("GO:0000426");
        this.expectedIDs.add("GO:0000408");
        this.expectedIDs.add("GO:0000436");
        this.expectedIDs.add("GO:0100001");
        this.expectedIDs.add("GO:0100010");
        this.expectedIDs.add("GO:0000417");
        this.expectedIDs.add("GO:0100023");
        this.expectedIDs.add("GO:0100032");
        this.expectedIDs.add("GO:0100041");
        this.expectedIDs.add("GO:0000404");
        this.expectedIDs.add("GO:0100027");
        this.expectedIDs.add("GO:0000412");
        this.expectedIDs.add("GO:0100039");
        this.expectedIDs.add("GO:0000440");
        this.expectedIDs.add("GO:0100045");
        this.expectedIDs.add("GO:0000000");
        this.expectedIDs.add("GO:0100036");
        this.expectedIDs.add("GO:0000430");
        this.expectedIDs.add("GO:0100008");
        this.expectedIDs.add("GO:0000444");
        this.expectedIDs.add("GO:0000421");
        this.expectedIDs.add("GO:0100017");
        this.expectedIDs.add("GO:0100014");
        this.expectedIDs.add("GO:0000409");
        this.expectedIDs.add("GO:0000435");
        this.expectedIDs.add("GO:0000437");
        this.expectedIDs.add("GO:0100002");
        this.expectedIDs.add("GO:0000405");
        this.expectedIDs.add("GO:0100015");
        this.expectedIDs.add("GO:0100033");
        this.expectedIDs.add("GO:0000427");
        this.expectedIDs.add("GO:0100042");
        this.expectedIDs.add("GO:0100024");
        this.expectedIDs.add("GO:0000414");
        this.expectedIDs.add("GO:0100011");
        this.expectedIDs.add("GO:0100037");
        this.expectedIDs.add("GO:0000418");
        this.expectedIDs.add("GO:0100020");
        this.expectedIDs.add("GO:0100028");
        this.expectedIDs.add("GO:0000400");
        this.expectedIDs.add("GO:0000413");
        this.expectedIDs.add("GO:0100009");
        this.expectedIDs.add("GO:0100049");
        this.expectedIDs.add("GO:0100018");
        this.expectedIDs.add("GO:0000441");
        this.expectedIDs.add("GO:0000431");
        this.expectedIDs.add("GO:0000432");
        this.expectedIDs.add("GO:0100005");
        this.expectedIDs.add("GO:0000422");
        this.expectedIDs.add("GO:0000445");
        this.expectedIDs.add("GO:0100046");
        this.expectedIDs.add("GO:0100012");
        this.expectedIDs.add("GO:0000447");
        this.expectedIDs.add("GO:0000415");
        this.expectedIDs.add("GO:0100040");
        this.expectedIDs.add("GO:0100025");
        this.expectedIDs.add("GO:0100030");
        this.expectedIDs.add("GO:0000406");
        this.expectedIDs.add("GO:0000428");
        this.expectedIDs.add("GO:0000438");
        this.expectedIDs.add("GO:0100021");
        this.expectedIDs.add("GO:0100029");
        this.expectedIDs.add("GO:0000401");
        this.expectedIDs.add("GO:0100034");
        this.expectedIDs.add("GO:0000419");
        this.expectedIDs.add("GO:0100038");
        this.expectedIDs.add("GO:0000410");
        this.expectedIDs.add("GO:0100047");
        this.expectedIDs.add("GO:0000442");
        this.expectedIDs.add("GO:0100006");
        this.expectedIDs.add("GO:0100019");
        this.expectedIDs.add("GO:0000433");
        this.expectedIDs.add("GO:0100043");
        this.expectedIDs.add("GO:0000446");
        this.expectedIDs.add("GO:0000423");
        this.expectedIDs.add("GO:0100003");
    }

    public void testAddTerms() {
        HistoryItem item;
        TestUtil testUtil = TestUtil.getInstance();
        HashSet oldTerms = new HashSet();
        oldTerms.addAll(testUtil.getSession().getTerms());
        Controller.getController().setHistory(testUtil.getSession());
        AddAction addAction = new AddAction();
        addAction.setController(Controller.getController());
        TreePath path = testUtil.getRandomTermPath();
        OBOClass parentClass = (OBOClass)((Link)path.getLastPathComponent()).getChild();
        TreePath[] pathArr = new TreePath[]{path};
        addAction.clickInit(pathArr, null);
        NamedIDProfile profile = new NamedIDProfile();
        String[] rules = new String[]{"GO:$sequence(7)$", "GO:$sequence(7,100000,200000)$"};
        ((DefaultIDGenerator)Controller.getController().getIDAdapter()).setProfile(profile);
        LinkedList<HistoryItem> historyItems = new LinkedList<HistoryItem>();
        HashSet<OBOClass> newTerms = new HashSet<OBOClass>();
        HashMap<HistoryItem, OBOClass> itemObjectMap = new HashMap<HistoryItem, OBOClass>();
        int newTermCount = 100;
        for (int i = 0; i < newTermCount; ++i) {
            profile.setDefaultRule(rules[i % rules.length]);
            item = addAction.execute();
            historyItems.add(item);
            testUtil.apply(item);
            HashSet tempSet = new HashSet();
            tempSet.addAll(testUtil.getSession().getTerms());
            tempSet.removeAll(oldTerms);
            tempSet.removeAll(newTerms);
            AddActionTest.assertTrue((String)"Exactly one new term should be created per cycle", (tempSet.size() == 1 ? 1 : 0) != 0);
            OBOClass newTerm = (OBOClass)tempSet.iterator().next();
            newTerms.add(newTerm);
            itemObjectMap.put(item, newTerm);
        }
        AddActionTest.assertTrue((String)("Should have created " + newTermCount + " terms, but actually " + "created " + newTerms.size()), (newTerms.size() == newTermCount ? 1 : 0) != 0);
        Iterator it = newTerms.iterator();
        while (it.hasNext()) {
            OBOClass oboClass = (OBOClass)it.next();
            AddActionTest.assertNotNull((String)"Null ids should not be generated", (Object)oboClass.getID());
            AddActionTest.assertTrue((String)"Unexpected id generated!", (boolean)this.expectedIDs.contains(oboClass.getID()));
            AddActionTest.assertTrue((String)"Each new term should have only one parent", (oboClass.getParents().size() == 1 ? 1 : 0) != 0);
            Link parentLink = (Link)oboClass.getParents().iterator().next();
            AddActionTest.assertTrue((String)("Parent class should be " + parentClass + ", but actually " + "is " + parentLink.getParent()), (boolean)parentClass.equals(parentLink.getParent()));
            AddActionTest.assertTrue((String)"Link type should be is_a", (boolean)parentLink.getType().equals(OBOProperty.IS_A));
            AddActionTest.assertTrue((String)("Namespace should be " + parentClass.getNamespace() + ", but actually is " + oboClass.getNamespace()), (boolean)ObjectUtil.equals((Object)oboClass.getNamespace(), (Object)parentClass.getNamespace()));
        }
        it = historyItems.iterator();
        while (it.hasNext()) {
            int termCount = testUtil.getSession().getTerms().size();
            item = (HistoryItem)it.next();
            OBOClass currentClass = (OBOClass)itemObjectMap.get(item);
            AddActionTest.assertTrue((String)("Current object collection should contain " + currentClass), (boolean)testUtil.getSession().getTerms().contains(currentClass));
            testUtil.reverse(item);
            AddActionTest.assertTrue((String)("Current object collection should not contain " + currentClass), (!testUtil.getSession().getTerms().contains(currentClass) ? 1 : 0) != 0);
        }
        AddActionTest.assertTrue((String)("Term set should be the same size as before; oldSize = " + oldTerms.size() + ", currentSize = " + testUtil.getSession().getTerms().size()), (oldTerms.size() == testUtil.getSession().getTerms().size() ? 1 : 0) != 0);
        AddActionTest.assertTrue((String)"Term set should contain all the same elements as before.", (boolean)testUtil.getSession().getTerms().containsAll(oldTerms));
    }
}

