/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.TestCase;
import org.geneontology.oboedit.datamodel.DefaultHistoryList;
import org.geneontology.oboedit.datamodel.HistoryGenerator;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.test.TestUtil;

public abstract class OperationTest
extends TestCase {
    protected TestUtil testUtil;
    protected OBOSession session;

    public void setSession(OBOSession session) {
        this.session = session;
        this.testUtil = new TestUtil(session);
    }

    protected abstract Collection getTestBundles();

    public void setUp() throws Exception {
        this.setSession(TestUtil.createSession());
    }

    public void testOperation() throws Exception {
        Iterator it = this.getTestBundles().iterator();
        while (it.hasNext()) {
            TestBundle testBundle = (TestBundle)it.next();
            this.doBundleTest(testBundle);
        }
    }

    public void doBundleTest(TestBundle testBundle) throws Exception {
        HistoryList changes;
        IdentifiedObject modifiedObject;
        ObjectPair op;
        DefaultHistoryList allChanges = new DefaultHistoryList();
        Iterator it = testBundle.getObjectPairs().iterator();
        while (it.hasNext()) {
            op = (ObjectPair)it.next();
            if (op.getOriginal() != null && op.getResult() != null) {
                HistoryGenerator.getChanges(op.getOriginal(), op.getResult(), allChanges);
                continue;
            }
            if (op.getOriginal() != null && op.getResult() != null) continue;
        }
        OperationTest.assertTrue((String)"At least some changes should be made in a test bundle", (allChanges.size() > 0 ? 1 : 0) != 0);
        this.testUtil.apply(testBundle.getHistoryItem());
        it = testBundle.getObjectPairs().iterator();
        while (it.hasNext()) {
            op = (ObjectPair)it.next();
            modifiedObject = this.session.getObject(op.getOriginal().getID());
            if (modifiedObject == null || op.getResult() == null) continue;
            changes = HistoryGenerator.getChanges(op.getResult(), modifiedObject);
            OperationTest.assertTrue((String)("Found differences between expected outcome and actual outcome " + changes.getHistoryList()), (changes.size() == 0 ? 1 : 0) != 0);
        }
        this.testUtil.reverse(testBundle.getHistoryItem());
        it = testBundle.getObjectPairs().iterator();
        while (it.hasNext()) {
            op = (ObjectPair)it.next();
            modifiedObject = this.session.getObject(op.getOriginal().getID());
            if (modifiedObject == null || op.getResult() == null) continue;
            changes = HistoryGenerator.getChanges(op.getOriginal(), modifiedObject);
            OperationTest.assertTrue((String)("Found differences between original object and object after undo: " + changes.getHistoryList()), (changes.size() == 0 ? 1 : 0) != 0);
        }
        it = allChanges.getHistoryList().iterator();
        while (it.hasNext()) {
            HistoryItem item = (HistoryItem)it.next();
            this.testUtil.apply(item);
        }
        it = testBundle.getObjectPairs().iterator();
        while (it.hasNext()) {
            op = (ObjectPair)it.next();
            modifiedObject = this.session.getObject(op.getOriginal().getID());
            if (modifiedObject == null || op.getResult() == null) continue;
            changes = HistoryGenerator.getChanges(op.getResult(), modifiedObject);
            OperationTest.assertTrue((String)("Found differences between expected outcome and actual outcome when applying history generator changes: " + changes.getHistoryList()), (changes.size() == 0 ? 1 : 0) != 0);
        }
        ArrayList allChangesList = new ArrayList();
        allChangesList.addAll(allChanges.getHistoryList());
        Collections.reverse(allChangesList);
        it = allChangesList.iterator();
        while (it.hasNext()) {
            HistoryItem item = (HistoryItem)it.next();
            this.testUtil.reverse(item);
        }
        it = testBundle.getObjectPairs().iterator();
        while (it.hasNext()) {
            ObjectPair op2 = (ObjectPair)it.next();
            IdentifiedObject modifiedObject2 = this.session.getObject(op2.getOriginal().getID());
            if (modifiedObject2 == null || op2.getResult() == null) continue;
            HistoryList changes2 = HistoryGenerator.getChanges(op2.getOriginal(), modifiedObject2);
            OperationTest.assertTrue((String)("Found differences between original object and object after undoing history generator list items: " + changes2.getHistoryList()), (changes2.size() == 0 ? 1 : 0) != 0);
        }
    }

    public static class ObjectPair
    implements Cloneable {
        protected IdentifiedObject original;
        protected IdentifiedObject result;

        public ObjectPair(IdentifiedObject original, IdentifiedObject result) {
            this.original = original;
            this.result = result;
        }

        public IdentifiedObject getOriginal() {
            return this.original;
        }

        public IdentifiedObject getResult() {
            return this.result;
        }

        public Object clone() {
            try {
                ObjectPair clone = (ObjectPair)super.clone();
                clone.original = (IdentifiedObject)this.original.clone();
                clone.result = (IdentifiedObject)this.result.clone();
                return clone;
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }
    }

    public static class TestBundle {
        protected HistoryItem item;
        protected Collection objectPairs;

        public TestBundle(HistoryItem item, Collection objectPairs) {
            this.item = item;
            this.objectPairs = objectPairs;
        }

        public HistoryItem getHistoryItem() {
            return this.item;
        }

        public Collection getObjectPairs() {
            return this.objectPairs;
        }
    }
}

