/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.test;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.DataAdapterException;
import org.geneontology.dataadapter.FileAdapterConfiguration;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.oboedit.dataadapter.OBOFileAdapter;
import org.geneontology.oboedit.dataadapter.SerialAdapter;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.test.TestUtil;

public class SimpleSerialRoundtripTest
extends TestCase {
    public String[] testFiles = new String[]{"lib/resources/testfile.1.0.obo"};

    public void testRoundtrip() throws DataAdapterException, IOException {
        for (int i = 0; i < this.testFiles.length; ++i) {
            OBOFileAdapter adapter = new OBOFileAdapter();
            OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
            config.getReadPaths().add(this.testFiles[i].toString());
            OBOSession session = (OBOSession)adapter.doOperation(IOOperation.READ, (AdapterConfiguration)config, null);
            SerialAdapter serialadapter = new SerialAdapter();
            FileAdapterConfiguration serialconfig = new FileAdapterConfiguration();
            File outFile = File.createTempFile("test", "serial");
            outFile.deleteOnExit();
            serialconfig.setWritePath(outFile.getAbsolutePath());
            serialadapter.doOperation(IOOperation.WRITE, (AdapterConfiguration)serialconfig, session);
            serialconfig = new FileAdapterConfiguration();
            serialconfig.getReadPaths().add(outFile.getAbsolutePath());
            OBOSession session2 = (OBOSession)serialadapter.doOperation(IOOperation.READ, (AdapterConfiguration)serialconfig, null);
            TestUtil.sessionCheck(this, session, session2);
            outFile.delete();
        }
    }
}

