/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MessageLevel {
    DEBUG("DEBUG"),
    INFO("INFO"),
    WARN("WARN"),
    ERROR("ERROR"),
    FATAL("FATAL");

    private final String name;

    private MessageLevel(String name) {
        this.name = name;
    }

    public static MessageLevel forName(String level) {
        if (MessageLevel.INFO.name.equalsIgnoreCase(level)) {
            return INFO;
        }
        if (MessageLevel.DEBUG.name.equalsIgnoreCase(level)) {
            return DEBUG;
        }
        if (MessageLevel.WARN.name.equalsIgnoreCase(level)) {
            return WARN;
        }
        if (MessageLevel.ERROR.name.equalsIgnoreCase(level)) {
            return ERROR;
        }
        if (MessageLevel.FATAL.name.equalsIgnoreCase(level)) {
            return FATAL;
        }
        throw new IllegalArgumentException("That log level (" + level + ") didn't match any of the supported ones.");
    }

    public boolean isHigher(MessageLevel aLevel) {
        return this.compareTo(aLevel) > 0;
    }

    public boolean isSame(MessageLevel aLevel) {
        return this.compareTo(aLevel) == 0;
    }

    public boolean isLower(MessageLevel aLevel) {
        return this.compareTo(aLevel) < 0;
    }

    public String toString() {
        return this.name;
    }
}

