/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.validator.rules;

import java.util.ArrayList;
import java.util.Collection;
import psidev.psi.tools.ontology_manager.OntologyManager;
import psidev.psi.tools.validator.rules.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRule
implements Rule {
    public static final String NEW_LINE = System.getProperty("line.separator");
    private String name;
    private String description;
    private Collection<String> howToFixTips = new ArrayList<String>(1);
    protected OntologyManager ontologyManager;

    public AbstractRule(OntologyManager ontologyManager) {
        this.ontologyManager = ontologyManager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addTip(String tip) {
        this.howToFixTips.add(tip);
    }

    @Override
    public Collection<String> getHowToFixTips() {
        return this.howToFixTips;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        if (this.name != null) {
            sb.append("Rule name: ").append(this.name).append(NEW_LINE);
        }
        if (this.description != null) {
            sb.append("Description: ").append(this.description).append(NEW_LINE);
        }
        if (this.howToFixTips != null && !this.howToFixTips.isEmpty()) {
            sb.append("Tip").append(this.howToFixTips.size() > 1 ? "s" : "").append(':').append(NEW_LINE);
            for (String tip : this.howToFixTips) {
                sb.append("\t* ").append(tip).append(NEW_LINE);
            }
        }
        return sb.toString();
    }
}

