/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.validator.rules.cvmapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.cvrReader.mapping.jaxb.CvMappingRule;
import psidev.psi.tools.cvrReader.mapping.jaxb.CvReference;
import psidev.psi.tools.cvrReader.mapping.jaxb.CvTerm;
import psidev.psi.tools.ontology_manager.OntologyManager;
import psidev.psi.tools.ontology_manager.OntologyUtils;
import psidev.psi.tools.validator.Context;
import psidev.psi.tools.validator.MessageLevel;
import psidev.psi.tools.validator.ValidatorException;
import psidev.psi.tools.validator.ValidatorMessage;
import psidev.psi.tools.validator.rules.AbstractRule;
import psidev.psi.tools.validator.rules.Rule;
import psidev.psi.tools.validator.rules.cvmapping.CvRule;
import psidev.psi.tools.validator.rules.cvmapping.MappingRuleStatus;
import psidev.psi.tools.validator.rules.cvmapping.Recommendation;
import psidev.psi.tools.validator.util.XpathValidator;
import psidev.psi.tools.validator.xpath.XPathHelper;
import psidev.psi.tools.validator.xpath.XPathResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CvRuleImpl
extends AbstractRule
implements CvRule {
    public static final Log log = LogFactory.getLog(CvRuleImpl.class);
    private CvMappingRule cvMappingRule;
    private MappingRuleStatus status = MappingRuleStatus.NOT_CHECKED;

    public CvRuleImpl(OntologyManager ontologyManager) {
        super(ontologyManager);
        this.cvMappingRule = new CvMappingRule();
    }

    public CvMappingRule getCvMappingRule() {
        return this.cvMappingRule;
    }

    public void setCvMappingRule(CvMappingRule mappingRule) {
        this.cvMappingRule = mappingRule;
    }

    @Override
    public List<CvTerm> getCVTerms() {
        return this.cvMappingRule.getCvTerm();
    }

    @Override
    public String getElementPath() {
        return this.cvMappingRule.getCvElementPath();
    }

    @Override
    public String getScopePath() {
        return this.cvMappingRule.getScopePath();
    }

    @Override
    public String getRequirementLevel() {
        return this.cvMappingRule.getRequirementLevel();
    }

    public String getCvTermsCombinationLogic() {
        return this.cvMappingRule.getCvTermsCombinationLogic();
    }

    @Override
    public MappingRuleStatus getStatus() {
        return this.status;
    }

    @Override
    public void resetStatus() {
        this.status = MappingRuleStatus.NOT_CHECKED;
    }

    @Override
    public String getId() {
        return this.cvMappingRule.getId();
    }

    @Override
    public String getName() {
        return this.cvMappingRule.getName();
    }

    @Override
    public boolean canCheck(String xPath) {
        if (xPath == null) {
            return true;
        }
        return this.getElementPath().startsWith(xPath);
    }

    @Override
    public Collection<ValidatorMessage> check(Object object, String prefixXpath) throws ValidatorException {
        List<XPathResult> results;
        if (object == null) {
            throw new ValidatorException("Cannot validate a null object.");
        }
        ArrayList<ValidatorMessage> messages = new ArrayList<ValidatorMessage>();
        if (this.status.equals((Object)MappingRuleStatus.INVALID_XPATH)) {
            return messages;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Given prefix Xpath: " + prefixXpath));
        }
        Recommendation level = Recommendation.forName(this.getRequirementLevel());
        String scopeXpath = this.getScopePath();
        String elementXpath = this.getElementPath();
        if (prefixXpath != null) {
            scopeXpath = this.removeXpathPrefix(scopeXpath, prefixXpath);
            elementXpath = this.removeXpathPrefix(elementXpath, prefixXpath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updated scope Xpath using prefix '" + prefixXpath + "' to: " + scopeXpath));
                log.debug((Object)("Updated element Xpath using prefix '" + prefixXpath + "' to: " + elementXpath));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Xpath to fetch objects to check on: " + scopeXpath));
        }
        try {
            results = XPathHelper.evaluateXPath(scopeXpath, object);
            if (log.isDebugEnabled()) {
                log.debug((Object)("XPath '" + scopeXpath + "' allowed to fetch " + results.size() + " object(s) from the given " + object.getClass().getSimpleName() + ": " + this.printObjectAccessions(results)));
            }
        }
        catch (JXPathException e) {
            messages.add(this.buildMessage(scopeXpath, level, "Skip this rule as the XPath expression could not be compiled: '" + scopeXpath + "'"));
            return messages;
        }
        if (results.isEmpty()) {
            if (!this.status.equals((Object)MappingRuleStatus.VALID_RULE)) {
                XpathValidator validator = new XpathValidator(elementXpath);
                String msg = validator.validate(object);
                if (msg != null) {
                    messages.add(new ValidatorMessage(msg, MessageLevel.ERROR, new Context("Flaw in the rule definition: " + this.getCvMappingRule().getId()), this));
                    this.status = MappingRuleStatus.INVALID_XPATH;
                    return messages;
                }
                this.status = MappingRuleStatus.VALID_XPATH;
            }
        } else {
            String resultClassName = results.iterator().next().getResult().getClass().getSimpleName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + results.size() + (results.isEmpty() ? " hit" : " hits of type " + resultClassName)));
            }
            String valueXpath = this.removeXpathPrefix(elementXpath, scopeXpath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Xpath allowing to retreive the values from the Objects: " + valueXpath));
            }
            for (XPathResult result : results) {
                Object objectToCheck = result.getResult();
                this.checkSingleObject(objectToCheck, elementXpath, valueXpath, messages, level);
                if (!this.status.equals((Object)MappingRuleStatus.INVALID_XPATH)) continue;
                return messages;
            }
        }
        return messages;
    }

    private void checkSingleObject(Object objectToCheck, String elementXpath, String valueXpath, Collection<ValidatorMessage> messages, Recommendation level) throws ValidatorException {
        List<XPathResult> valueResults;
        String resultClassName = objectToCheck.getClass().getSimpleName();
        try {
            valueResults = XPathHelper.evaluateXPath(valueXpath, objectToCheck);
            if (!valueResults.isEmpty()) {
                this.status = MappingRuleStatus.VALID_RULE;
            } else if (!this.status.equals((Object)MappingRuleStatus.VALID_RULE)) {
                XpathValidator validator = new XpathValidator(valueXpath);
                String msg = validator.validate(objectToCheck);
                if (msg != null) {
                    messages.add(new ValidatorMessage(msg, MessageLevel.ERROR, new Context("Flaw in the rule definition: " + this.getCvMappingRule().getId()), this));
                    this.status = MappingRuleStatus.INVALID_XPATH;
                    return;
                }
                this.status = MappingRuleStatus.VALID_XPATH;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("XPath '" + valueXpath + "' allowed to fetch " + valueResults.size() + " value(s) from the given " + resultClassName + ": " + this.printObjectAccessions(valueResults)));
            }
        }
        catch (JXPathException e) {
            messages.add(this.buildMessage(valueXpath, level, "Skip this rule as the XPath expression could not be compiled: '" + valueXpath + "'"));
            return;
        }
        int resultCount = valueResults.size();
        if (resultCount == 0) {
            if (this.getCVTerms() != null && this.getCVTerms().size() > 0) {
                StringBuilder sb = new StringBuilder(256);
                sb.append("None of the given CvTerms were found at '").append(this.getElementPath()).append("' because no values were found:\n");
                Iterator<CvTerm> iterator = this.getCVTerms().iterator();
                while (iterator.hasNext()) {
                    CvTerm cvTerm = iterator.next();
                    sb.append("  - ").append(this.printCvTerm(cvTerm));
                    if (!iterator.hasNext()) continue;
                    sb.append("\n");
                }
                messages.add(this.buildMessage(elementXpath, level, sb.toString()));
            }
        } else {
            StringBuilder sb;
            Map<XPathResult, Map<CvTerm, Integer>> result2termCount = this.checkValuesAgainstCvTerms(valueResults, messages, level);
            String operator = this.getCvTermsCombinationLogic();
            if (operator != null) {
                operator = operator.trim();
            }
            int matchingCvTermCount = this.calculateMatchingResultCount(result2termCount);
            Map<CV, Integer> term2count = this.calculateCvTermUsage(result2termCount);
            for (Map.Entry<CV, Integer> entry2 : term2count.entrySet()) {
                CV cvTerm = entry2.getKey();
                Integer count = entry2.getValue();
                if (cvTerm.isRepeatable() || count <= 1) continue;
                StringBuilder sb2 = new StringBuilder(256);
                sb2.append("According to the CvMapping, the term '").append(cvTerm.getAccession()).append("' wasn't meant to be repeated, yet it appeared ").append(count).append(" times in elements pointed out by the XPath expression: ").append(this.getElementPath());
                messages.add(this.buildMessage(this.getElementPath(), level, sb2.toString()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Matching term count: " + matchingCvTermCount));
            }
            if ("OR".equalsIgnoreCase(operator)) {
                boolean match = false;
                for (CV cv : term2count.keySet()) {
                    if (term2count.get(cv) <= 0) continue;
                    match = true;
                }
                if (!match) {
                    sb = new StringBuilder(256);
                    sb.append("The result found at: ").append(elementXpath).append(" for which the values ").append(valueResults.size() > 1 ? "are " : "is ").append(" '").append(this.printObjectAccessions(valueResults)).append("' didn't match " + (this.getCVTerms().size() > 1 ? "any of the " : "the ")).append(this.getCVTerms().size()).append(" specified CV term").append(this.getCVTerms().size() > 1 ? "s" : "").append(":\n").append(this.listCvTerms("  - ", this.getCVTerms()));
                    messages.add(this.buildMessage(elementXpath, level, sb.toString()));
                }
            } else if ("AND".equalsIgnoreCase(operator)) {
                boolean match = true;
                for (CV cv : term2count.keySet()) {
                    if (term2count.get(cv) >= 1) continue;
                    match = false;
                }
                if (!match) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found only " + matchingCvTermCount + " matching terms while we were expecting " + this.getCVTerms().size()));
                    }
                    sb = new StringBuilder(256);
                    sb.append("Not all of the ").append(resultCount).append(" values ").append(resultClassName).append("'s CV terms [").append(this.printObjectAccessions(valueResults)).append("] found using the Xpath '").append(elementXpath).append("' matched any of the ").append(this.getCVTerms().size()).append(" CvTerm(s):\n").append(this.listCvTerms("  - ", this.getCVTerms()));
                    messages.add(this.buildMessage(elementXpath, level, sb.toString()));
                }
            } else if ("XOR".equalsIgnoreCase(operator)) {
                int match = 0;
                for (CV cv : term2count.keySet()) {
                    if (term2count.get(cv) <= 0) continue;
                    ++match;
                }
                if (match != 1) {
                    sb = new StringBuilder(256);
                    sb.append("Not exactly one of the ").append(resultCount).append(" ").append(resultClassName).append("'s CV terms [").append(this.printObjectAccessions(valueResults)).append("] found using the Xpath '").append(elementXpath).append("' matched any of the ").append(this.getCVTerms().size()).append(" CvTerm(s):\n").append(this.listCvTerms("  - ", this.getCVTerms()));
                    messages.add(this.buildMessage(elementXpath, level, sb.toString()));
                }
            } else {
                throw new UnsupportedOperationException("CvRule count not handle boolean operator: '" + operator + "'");
            }
        }
    }

    private Map<XPathResult, Map<CvTerm, Integer>> checkValuesAgainstCvTerms(Collection<XPathResult> valueResults, Collection<ValidatorMessage> messages, Recommendation level) {
        HashMap<XPathResult, Map<CvTerm, Integer>> result2termCount = new HashMap<XPathResult, Map<CvTerm, Integer>>(valueResults.size());
        for (XPathResult valueResult : valueResults) {
            HashMap<CvTerm, Integer> term2count = new HashMap<CvTerm, Integer>(this.getCVTerms().size());
            result2termCount.put(valueResult, term2count);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing value: " + valueResult.getResult()));
            }
            for (CvTerm cvTerm : this.getCVTerms()) {
                if (this.isMatchingCv(cvTerm, valueResult, messages, level, term2count)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Match between '" + valueResult.getResult() + "' and " + this.printCvTerm(cvTerm)));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No match between '" + valueResult.getResult() + "' and " + this.printCvTerm(cvTerm)));
            }
        }
        if (log.isDebugEnabled()) {
            this.printMap(result2termCount);
        }
        return result2termCount;
    }

    private boolean isMatchingCv(CvTerm cvTerm, XPathResult xpResult, Collection<ValidatorMessage> messages, Recommendation level, Map<CvTerm, Integer> term2count) {
        boolean isMatching = false;
        String accession = null;
        try {
            accession = (String)xpResult.getResult();
        }
        catch (ClassCastException cce) {
            messages.add(this.buildMessage(this.getElementPath(), level, "The object pointed to by the XPath(" + this.getElementPath() + ") was not a CV term accession (String) as " + "expected, instead: " + xpResult.getResult().getClass().getName()));
        }
        String ontologyID = ((CvReference)cvTerm.getCvIdentifierRef()).getCvIdentifier();
        String ruleTermAcc = cvTerm.getTermAccession();
        boolean allowChildren = cvTerm.isAllowChildren();
        boolean useTerm = cvTerm.isUseTerm();
        boolean useTermName = cvTerm.isUseTermName();
        Set allowedTerms = this.ontologyManager.getOntologyAccess(ontologyID).getValidTerms(ruleTermAcc, allowChildren, useTerm);
        Collection allowedValues = useTermName ? OntologyUtils.getTermNames((Collection)allowedTerms) : OntologyUtils.getAccessions((Collection)allowedTerms);
        if (allowedValues.contains(accession)) {
            if (!term2count.containsKey(cvTerm)) {
                term2count.put(cvTerm, 1);
            } else {
                Integer count = term2count.get(cvTerm) + 1;
                term2count.put(cvTerm, count);
            }
            isMatching = true;
        } else if (!term2count.containsKey(cvTerm)) {
            term2count.put(cvTerm, 0);
        }
        return isMatching;
    }

    @Override
    public ValidatorMessage buildMessage(String xpath, Recommendation level, String message, Rule rule) {
        return new ValidatorMessage(message, this.convertCvMappingLevel(level), new Context(xpath), rule);
    }

    @Override
    public MessageLevel convertCvMappingLevel(Recommendation level) {
        switch (level) {
            case MAY: {
                return MessageLevel.INFO;
            }
            case SHOULD: {
                return MessageLevel.WARN;
            }
            case MUST: {
                return MessageLevel.ERROR;
            }
        }
        throw new IllegalArgumentException("Unknown CvMapping RequirementLevel: " + (Object)((Object)level));
    }

    private int calculateMatchingResultCount(Map<XPathResult, Map<CvTerm, Integer>> result2termCount) {
        int matchingResultCount = 0;
        for (Map.Entry<XPathResult, Map<CvTerm, Integer>> e : result2termCount.entrySet()) {
            Map<CvTerm, Integer> t2c = e.getValue();
            int matchingCvTermCount = 0;
            for (Map.Entry<CvTerm, Integer> entry : t2c.entrySet()) {
                Integer count = entry.getValue();
                if (count <= 0) continue;
                ++matchingCvTermCount;
            }
            if (matchingCvTermCount <= 0) continue;
            ++matchingResultCount;
        }
        return matchingResultCount;
    }

    private Map<CV, Integer> calculateCvTermUsage(Map<XPathResult, Map<CvTerm, Integer>> result2termCount) {
        HashMap<CV, Integer> term2count = new HashMap<CV, Integer>();
        for (Map.Entry<XPathResult, Map<CvTerm, Integer>> e : result2termCount.entrySet()) {
            Map<CvTerm, Integer> t2c = e.getValue();
            for (Map.Entry<CvTerm, Integer> entry : t2c.entrySet()) {
                CV cvTerm = new CV(entry.getKey());
                Integer count = entry.getValue();
                if (!term2count.containsKey(cvTerm)) {
                    term2count.put(cvTerm, 0);
                }
                if (count <= 0) continue;
                Integer totalCount = (Integer)term2count.get(cvTerm);
                term2count.put(cvTerm, totalCount + count);
            }
        }
        return term2count;
    }

    private void printMap(Map<XPathResult, Map<CvTerm, Integer>> result2termCount) {
        log.debug((Object)"===============================================================");
        log.debug((Object)"Printing Map<XPathResult, Map<CvTerm, Integer>>...");
        for (Map.Entry<XPathResult, Map<CvTerm, Integer>> entry : result2termCount.entrySet()) {
            XPathResult result = entry.getKey();
            Map<CvTerm, Integer> term2count = entry.getValue();
            log.debug((Object)("XPathResult: " + result.getResult()));
            if (term2count.isEmpty()) {
                log.debug((Object)"     No association");
                continue;
            }
            for (Map.Entry<CvTerm, Integer> entry2 : term2count.entrySet()) {
                CvTerm t = entry2.getKey();
                Integer count = entry2.getValue();
                log.debug((Object)("      " + this.printSimpleCvTerm(t) + " --> " + count));
            }
        }
        log.debug((Object)"===============================================================");
    }

    private String printObjectAccessions(List<XPathResult> results) {
        StringBuilder sb = new StringBuilder(128);
        Iterator<XPathResult> iterator = results.iterator();
        while (iterator.hasNext()) {
            XPathResult result = iterator.next();
            sb.append('\'').append(result.getResult()).append('\'');
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private String listCvTerms(String prefix, Collection<CvTerm> terms) {
        StringBuilder sb = new StringBuilder(256);
        Iterator<CvTerm> iterator = terms.iterator();
        while (iterator.hasNext()) {
            CvTerm cvTerm = iterator.next();
            sb.append(prefix).append(this.printCvTerm(cvTerm));
            if (!iterator.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private ValidatorMessage buildMessage(String xpath, Recommendation level, String message) {
        return this.buildMessage(xpath, level, message, this);
    }

    private String printCvTerm(CvTerm cv) {
        StringBuilder sb = new StringBuilder(512);
        if (cv.isUseTerm() && cv.isAllowChildren()) {
            sb.append(cv.getTermAccession()).append(" (").append(cv.getTermName()).append(")");
            sb.append(" or any of its children. ");
        } else if (!cv.isUseTerm() && cv.isAllowChildren()) {
            sb.append("Any children term of ").append(cv.getTermAccession()).append(" (").append(cv.getTermName()).append("). ");
        } else if (cv.isUseTerm() && !cv.isAllowChildren()) {
            sb.append("The sole term ").append(cv.getTermAccession()).append(" (").append(cv.getTermName()).append(") ").append("or any of its children. ");
        } else {
            throw new IllegalStateException("Either the term itself of its children have to be allowed");
        }
        if (cv.isIsRepeatable()) {
            sb.append("The term can be repeated. ");
        } else {
            sb.append("A single instance of this term can be specified. ");
        }
        if (cv.isUseTermName()) {
            sb.append("The matching value has to be the name of the term, not its identifier.");
        } else {
            sb.append("The matching value has to be the identifier of the term, not its name.");
        }
        return sb.toString();
    }

    private String printSimpleCvTerm(CvTerm cv) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'').append(cv.getTermName()).append('\'').append(' ');
        sb.append('(').append(cv.getTermAccession()).append(')');
        return sb.toString();
    }

    private String removeXpathPrefix(String xpath, String prefixXpath) {
        if (prefixXpath.equals(".")) {
            return xpath;
        }
        if (!xpath.startsWith(prefixXpath)) {
            throw new IllegalArgumentException("The given prefix '" + prefixXpath + "' is not a prefix of '" + xpath + "'");
        }
        String result = xpath.substring(prefixXpath.length());
        if (result.length() == 0) {
            result = ".";
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("[Rule: ID=");
        sb.append(this.getId());
        if (this.getName() != null && this.getName().trim().length() > 0) {
            sb.append("Name=").append(this.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    private class CV {
        private String name;
        private String accession;
        boolean isRepeatable;

        private CV(CvTerm cvTerm) {
            this.accession = cvTerm.getTermAccession();
            this.name = cvTerm.getTermName();
            this.isRepeatable = cvTerm.isIsRepeatable();
        }

        public String getName() {
            return this.name;
        }

        public String getAccession() {
            return this.accession;
        }

        public boolean isRepeatable() {
            return this.isRepeatable;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("CV");
            sb.append("{accession='").append(this.accession).append('\'');
            sb.append(", name='").append(this.name).append('\'');
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CV cv = (CV)o;
            return this.accession.equals(cv.accession) && !(this.name == null ? cv.name != null : !this.name.equals(cv.name));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + this.accession.hashCode();
            return result;
        }
    }
}

