/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.validator.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpathValidator {
    private static final Log log = LogFactory.getLog(XpathValidator.class);
    private String xpath;

    public XpathValidator(String xpath) {
        if (xpath == null || xpath.trim().length() == 0) {
            throw new IllegalArgumentException("You must give a non null/empty xpath expression");
        }
        this.xpath = xpath;
    }

    public String validate(Object o) {
        List<Object> currentObject = o;
        String localXpath = this.xpath;
        if (localXpath.startsWith("/")) {
            localXpath = localXpath.substring(1);
        }
        String[] xpathElements = localXpath.split("/");
        if (!(currentObject instanceof Collection)) {
            currentObject = Arrays.asList(currentObject);
        }
        return this.check((Collection<Object>)currentObject, xpathElements, 0);
    }

    /*
     * WARNING - void declaration
     */
    private String check(Collection<Object> currentObjects, String[] xpathElements, int idx) {
        String xpathElement = xpathElements[idx];
        for (Object object : currentObjects) {
            void var6_9;
            Object object2;
            if (object == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking for " + xpathElement + " in " + object.getClass().getSimpleName()));
            }
            if (xpathElement.startsWith("@")) {
                xpathElement = xpathElement.substring(1);
            }
            PropertyDescriptor propertyDescriptor = null;
            try {
                propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)object, (String)xpathElement);
            }
            catch (Exception e) {
                log.info((Object)("Error while introspecting fields of bean: " + object.getClass().getName()), (Throwable)e);
            }
            if (propertyDescriptor == null) {
                int currentMinimumLevensteinDistance = Integer.MAX_VALUE;
                ArrayList<String> bestGuesses = new ArrayList<String>(2);
                try {
                    Set properties = PropertyUtils.describe((Object)object).keySet();
                    for (String fieldName : properties) {
                        int distance = StringUtils.getLevenshteinDistance((String)xpathElement, (String)fieldName);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Levenshtein distance(" + xpathElement + ", " + fieldName + ") = " + distance));
                        }
                        if (distance < currentMinimumLevensteinDistance) {
                            bestGuesses.clear();
                            currentMinimumLevensteinDistance = distance;
                            bestGuesses.add(fieldName);
                            continue;
                        }
                        if (distance != currentMinimumLevensteinDistance) continue;
                        bestGuesses.add(fieldName);
                    }
                }
                catch (Exception e) {
                    log.info((Object)("Error while introspecting fields of bean: " + object.getClass().getName()), (Throwable)e);
                }
                return "Could not find property '" + xpathElement + "' of the xpath expression '" + this.xpath + "' (element position: " + (idx + 1) + ") in the given object of: " + object.getClass().getName() + this.printGuess(bestGuesses);
            }
            if (xpathElements.length <= idx + 1) continue;
            Method method = null;
            try {
                method = propertyDescriptor.getReadMethod();
                object2 = method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking method " + object.getClass().getName() + "." + (method.getName() != null ? method.getName() : "???") + "()", e);
            }
            if (!(object2 instanceof Collection)) {
                List<Object> list = Arrays.asList(object2);
            }
            return this.check((Collection)var6_9, xpathElements, idx + 1);
        }
        return null;
    }

    private String printGuess(Collection<String> bestGuesses) {
        switch (bestGuesses.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return " - Did you mean '" + bestGuesses.iterator().next() + "' ?";
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" - Did you mean any of the following: ");
        Iterator<String> stringIterator = bestGuesses.iterator();
        while (stringIterator.hasNext()) {
            String guess = stringIterator.next();
            sb.append('\'').append(guess).append('\'');
            if (!stringIterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(" ?");
        return sb.toString();
    }
}

