package org.pathwaycommons.trans;

import java.util.TreeMap;

import org.genemania.dw.util.GenUtil;

/**
 * PSI-MI 2.5 element/atts tags, as well as other controlled vocab.
 * 
 * @author rashadbadrawi
 */

public final class PSIMITags {

    private static TreeMap <String, String> refTypeMap = new TreeMap <String, String> ();

    static {
        refTypeMap.put (PSIMITags.REFTYPE_IDENT, PSIMITags.REFTYPE_IDENT_ID);
        refTypeMap.put (PSIMITags.REFTYPE_GP, PSIMITags.REFTYPE_GP_ID);
        refTypeMap.put (PSIMITags.REFTYPE_SA, PSIMITags.REFTYPE_SA_ID);
        refTypeMap.put (PSIMITags.REFTYPE_GO, PSIMITags.REFTYPE_GO_ID);
        refTypeMap.put (PSIMITags.REFTYPE_REF, PSIMITags.REFTYPE_REF_ID);
    }

    protected static String getRefTypeAccn (String refType) {

        GenUtil.validateString(refType);
        if (!refTypeMap.containsKey (refType)) {
            throw new IllegalArgumentException ("Invalid refType: " + refType);
        }

        return refTypeMap.get (refType);
    }

    //PSI-MI 2.5 elements
    protected static final String ENTRY_SET = "entrySet";
    public static final String ENTRY = "entry";
    protected static final String SOURCE = "source";
    public static final String INT_LIST = "interactionList";
    public static final String INT = "interaction";
    public static final String PARTLIST = "participantList";
    public static final String PART = "participant";
    public static final String INTERACTOR = "interactor";
    protected static final String ORG = "organism";
    public static final String INT_TYPE = "interactorType";
    public static final String EXP_LIST = "experimentList";
    public static final String EXP_DESC = "experimentDescription";
    public static final String INT_DET_METHOD = "interactionDetectionMethod";
    //used for supporting complexes
    protected static final String PART_REF = "participantRef";
    protected static final String EXP_LIST_REF = "experimentRefList";
    protected static final String EXP_REF = "experimentRef";
    protected static final String INT_REF = "interactionRef";

    //PSI-MI 2.5 shared elements
    public static final String NAMES = "names";
    public static final String SHORT_LABEL = "shortLabel";
    protected static final String FULLNAME = "fullName";
    protected static final String BIB = "bibref";
    public static final String XREF = "xref";
    public static final String PREF = "primaryRef";
    public static final String SREF = "secondaryRef";
    public static final String ATTLIST = "attributeList";
    public static final String ATT = "attribute";

    //PSI-MI 2.5 attributes
    protected static final String LEVEL_ATT = "level";
    protected static final String VERSION_ATT = "version";
    protected static final String REL_DATE_ATT = "releaseDate";
    public static final String DB_ATT = "db";
    protected static final String DBACC_ATT = "dbAc";
    protected static final String ID_ATT = "id";
    protected static final String REFTYPE_ATT = "refType";
    protected static final String REFTYPEAC_ATT = "refTypeAc";
    protected static final String ALIASTYPE_ATT = "type";
    protected static final String ALIASTYPEACC_ATT = "typeAc";
    public static final String NAME_ATT = "name";
    protected static final String NCBI_TAXID = "ncbiTaxId";

    //PSI-MI translation settings
    protected static final String LEVEL = "2";
    protected static final String VERSION = "5";
    public static final String PSIMI_NS = "net:sf:psidev:mi";
    protected static final String SCHEMA_LOC =
       "net:sf:psidev:mi http://psidev.sourceforge.net/mi/rel25/src/MIF25.xsd";
    //PSI-MI controlled vocabs
    protected static final String DB_PSIMI = "psimi";
    protected static final String MI_PREFIX = "MI:";
    protected static final String ENTREZ_GENE_DB = "Entrez Gene";
    //3 dummies for Entrez GIs used as BIND x-ref source terms
    protected static final String ENTREZ_GI_DB = "Entrez GI";
    protected static final String ENTREZ_GI__PRO_DB = "Entrez_GI_PRO_IDMAP";
    protected static final String ENTREZ_GI_NUC_DB = "Entrez_GI_NUC_IDMAP";

    protected static final String TYPE_PROTEIN_SL = "protein";
    protected static final String TYPE_SM_SL = "small molecule";
    protected static final String TYPE_DNA_SL = "dna";
    protected static final String TYPE_RNA_SL = "rna";
    protected static final String TYPE_COMPLEX_SL = "complex";
    protected static final String TYPE_GENE_SL = "gene";
    protected static final String TYPE_UP_SL = "unknown participant";

    protected static final String BIND_SL = "bind";
    protected static final String BIND_COMPLEXID_SL = "BIND_COMPLEXID";  //dummy
    protected static final String BIND_UNIPROT_SL = "SWISSPROT_IDMAP";   //dummy
    protected static final String BIND_REFSEQ_P_SL = "REFSEQ_P_IDMAP";   //dummy
    protected static final String BIND_REFSEQ_M_SL = "REFSEQ_M_IDMAP";   //dummy
    protected static final String BIND_PRO_SL = "PROTEIN_IDMAP";         //dummy
    //protected static final String BIND_FL = "The Biomolecular Interaction Network Database";
    protected static final String PUBMED_SL = "pubmed";    
    //Reference Types
    protected static final String REFTYPE_IDENT = "identity";
    protected static final String REFTYPE_GP = "gene product";
    protected static final String REFTYPE_SA = "see-also";
    protected static final String REFTYPE_GO = "gene ontology";
    protected static final String REFTYPE_REF = "source reference";
    protected static final String ALIASTYPE_GEN = "alias type";

    protected static final String REFTYPE_IDENT_ID = "MI:0356";
    protected static final String REFTYPE_GP_ID = "MI:0251";
    protected static final String REFTYPE_SA_ID = "MI:0361";
    protected static final String REFTYPE_GO_ID = "MI:0448";
    protected static final String REFTYPE_REF_ID = "MI:0685";

    protected static final String ID_PSIMI = "MI:0488";
    protected static final String TYPE_UP_ID = "MI:0329";
    protected static final String ID_PUBMED = "MI:0446";
    protected static final String ID_BIND = "MI:0462";

    protected static final String ID_METHOD_NS = "MI:0686";
    protected static final String SL_METHOD_NS = "unspecified method";
    protected static final String TAXID_UN_ID = "32644";
    protected static final String TAXID_UN_NAME = "unidentified";
    protected static final String GEN_XREF = "participant xref";
    protected static final String GEN_IDM = "experimental interac";
    protected static final String GEN_IDM_FN = "experimental interaction detection";
    public static final String ATT_BIND_DIVISION = "BIND Interaction Division";
    protected static final String ATT_BAD_DATA_FILE = "BAD Data File";
    //complex specific atts
    public static final String ATT_COMPLEX_SUBUNIT_CNT = "Complex Number of Subunits";
    protected static final String ATT_COMPLEX_SUBUNIT_NUM = "Complex Subunit Number";
    protected static final String ATT_COMPLEX_INT_LIST = "Complex Interactions List";
    protected static final String ATT_COMPLEX_INT_LIST_BIND = "Complex Interactions List - BIND IDs";
    protected static final String ATT_COMPLEX_INT_REF_BIND = "Interaction Ref - BIND ID";
    protected static final String ATT_COMPLEX_INT_ORDERED = "Complex Interactions List Ordered";
    protected static final String ATT_COMPLEX_INT_SRC = "Complex Interactant Source";
    protected static final String ATT_COMPLEX_INT_REF_A = "BIND Interactant A";
    protected static final String ATT_COMPLEX_INT_REF_B = "BIND Interactant B";
}
