package org.pathwaycommons.trans.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;

import org.pathwaycommons.trans.PSIMITags;
import psidev.psi.mi.xml.converter.ConverterException;
//import psidev.psi.mi.xml.InteractionIterator;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.PsimiXmlPullReader;
import psidev.psi.mi.xml.PsimiXmlReaderException;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.EntrySet;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.Participant;

/**
 * Implementation for the PSIMI Miner for translated BIND models,  using the
 * java object model, from the PSI-MI java API. There seems to be:
 * - An issue in the Participant class
 * - An issue in the xml reader not being able to process some large XML files
 * properly. Throws exceptions complaining of poorly-formed XML files for
 * well-formed ones.
 * 
 * @author rashadbadrawi
 */

public class PSIMIMinerModel extends PSIMIMiner {

    private PsimiXmlPullReader pullReader;
    private Interaction interaction;                  //handy att

    protected PSIMIMinerModel (String inputFileName, String reportFileName,
                               String miningType) throws Exception {

        super (inputFileName, reportFileName, miningType);
    }

    protected void minePSIMI (String inputFileName)
                  throws PsimiXmlReaderException, IOException, JAXBException,
                                    ConverterException {

        super.termMap = new TreeMap <String, Integer> ();
        super.interactionCnt = 0;
        File inputFile = new File(inputFileName);
        EntrySet entrySet;
        PsimiXmlReader pr = new PsimiXmlReader();
        this.pullReader = new PsimiXmlPullReader(inputFile);
        entrySet = pr.read(inputFile);
        for (Entry entry : entrySet.getEntries()) {     //one entry, anyway
            ArrayList <Interaction> interactionsList =
                               (ArrayList <Interaction>)entry.getInteractions();
            for (int i = 0; i < interactionsList.size (); i++) {
                this.interaction = interactionsList.get (i);
                try {
                //InteractionIterator iterator = this.pullReader.getInteractionIterator();
                //while (iterator.hasNext()) {
                //    try {
                //        this.interaction = iterator.next();
                    if (getAtt (PSIMITags.ATT_COMPLEX_SUBUNIT_CNT) != null) {
                        if (!PSIMIMiner.MINING_COMPLEX_SUBUNIT_NUM.equals (super.miningType)) {
                            //System.out.println ("Skipping complex: " + super.interactionCnt);
                            super.skipCnt++;
                            continue;
                        } else {
                            super.interactionCnt++;
                        }
                    }
                    if (!PSIMIMiner.MINING_COMPLEX_SUBUNIT_NUM.equals (super.miningType)) {
                        super.interactionCnt++;
                    }
                    //System.out.println(interaction.getNames().getShortLabel() );
                    if (PSIMIMiner.MINING_INT_DET_METHOD.equals (super.miningType)) {
                        mineDetMethod ();
                    } else if (PSIMIMiner.MINING_INTERACTOR_TYPE.equals (super.miningType)) {
                        mineInteractorType ();
                    } else if (PSIMIMiner.MINING_COMPLEX_SUBUNIT_NUM.equals (super.miningType)) {
                        mineComplexSubunits ();
                    } else if (PSIMIMiner.MINING_BIND_DIV.equals (super.miningType)) {
                        mineBINDDivCategory();
                    } else if (PSIMIMiner.MINING_INT_XREF.equals (super.miningType)) {
                        mineInteractorXRef();
                    } else throw new IllegalArgumentException
                                     ("Unsupported mining request: " + super.miningType);
                } catch (Exception e) {
                    //e.printStackTrace();
                    e.printStackTrace(log);
                    System.err.println ("ERROR: Skipping in file: " +
                                        super.interactionCnt + " " + inputFileName);
                    super.skipCnt++;
                    continue;
                }
            }
            super.incrementCounts (inputFileName);
        }
    }

    protected void mineDetMethod () {

        ArrayList <ExperimentDescription> expDescList  =
                (ArrayList <ExperimentDescription>)this.interaction.getExperiments();
        for (int i = 0; i < expDescList.size (); i++) {
            String shortLabel = expDescList.get (i).
                     getInteractionDetectionMethod().getNames().getShortLabel();
            trackTermCnt (shortLabel);
        }
    }

    protected void mineInteractorType () throws PsimiXmlReaderException {

        ArrayList <Participant> partList = (ArrayList <Participant>)this.interaction.getParticipants();
        for (int j = 0; j < partList.size (); j++) {
            Interactor interactor = pullReader.getInteractorById(partList.get (j).getId());
            //Interactor interactor = participant.getInteractor();
            String type = interactor.getInteractorType().getNames().getShortLabel();
            trackTermCnt (type);
        }
    }

    protected void mineInteractorXRef () throws Exception {

        ArrayList <Participant> partList = (ArrayList <Participant>)this.interaction.getParticipants();
        for (int j = 0; j < partList.size (); j++) {
            Interactor interactor = pullReader.getInteractorById(partList.get (j).getId());
            //Interactor interactor = participant.getInteractor();
            ArrayList <DbReference> refList = new ArrayList <DbReference> ();
            refList.add (interactor.getXref().getPrimaryRef());
            refList.addAll (interactor.getXref().getSecondaryRef());
            for (int i = 0; i < refList.size (); i++) {
                trackTermCnt (refList.get (i).getDb());
            }
        }
    }

    //helper method, assumes att is listed once in an att list.
    protected void trackAtt (String attName) {

        String attVal = getAtt (attName);
        if (attVal != null) {
            trackTermCnt (attVal);
        }
    }

    protected String getAtt (String attName) {

        ArrayList <Attribute> attList = (ArrayList <Attribute>)
                                        this.interaction.getAttributeList();
        String attVal = null;
        for (int i = 0; i < attList.size (); i++) {
            Attribute att = attList.get (i);
            if (att.getName().equals (attName)) {
               attVal = att.getValue();
               break;
            }
        }

        return attVal;
    }
}